/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist.index;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.contentassist.index.JSCAHandler;
import com.aptana.editor.js.contentassist.index.JSCAReader;
import com.aptana.editor.js.contentassist.index.JSIndexReader;
import com.aptana.editor.js.contentassist.index.JSIndexWriter;
import com.aptana.editor.js.contentassist.model.AliasElement;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.editor.js.inferencing.JSTypeUtil;
import com.aptana.index.core.AbstractFileIndexingParticipant;
import com.aptana.index.core.BuildContextType;
import com.aptana.index.core.Index;
import com.aptana.index.core.build.BuildContext;
import com.aptana.json.IContextHandler;
import com.aptana.json.SchemaContext;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;

public class JSCAFileIndexingParticipant
extends AbstractFileIndexingParticipant {
    public void index(BuildContext context, Index index, IProgressMonitor monitor) throws CoreException {
        if (context == null || index == null) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                String globalTypeName;
                JSIndexReader jsir;
                List<TypeElement> windows;
                sub.subTask(this.getIndexingMessage(index, context.getURI()));
                JSCAReader reader = new JSCAReader();
                SchemaContext schemaContext = new SchemaContext();
                JSCAHandler handler = new JSCAHandler();
                schemaContext.setHandler((IContextHandler)handler);
                Reader isr = null;
                try {
                    isr = new InputStreamReader(context.openInputStream((IProgressMonitor)sub.newChild(5)));
                    reader.read(isr, schemaContext);
                    sub.worked(45);
                }
                catch (Throwable throwable) {
                    if (isr != null) {
                        try {
                            isr.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (isr != null) {
                    try {
                        isr.close();
                    }
                    catch (IOException iOException) {}
                }
                TypeElement window = !CollectionsUtil.isEmpty(windows = (jsir = new JSIndexReader()).getType(index, globalTypeName = JSTypeUtil.getGlobalType(context.getProject(), context.getName()), true)) ? windows.get(windows.size() - 1) : JSTypeUtil.createGlobalType(globalTypeName);
                JSIndexWriter indexer = new JSIndexWriter();
                TypeElement[] types = handler.getTypes();
                AliasElement[] aliases = handler.getAliases();
                URI location = context.getURI();
                Object[] objectArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyElement property;
                    TypeElement type = objectArray[n2];
                    indexer.writeType(index, type, location);
                    String typeName = type.getName();
                    if (this.isGlobalProperty(type) && (property = window.getProperty(typeName)) == null) {
                        property = new PropertyElement();
                        property.setName(typeName);
                        property.addType(typeName);
                        window.addProperty(property);
                    }
                    ++n2;
                }
                objectArray = aliases;
                n = aliases.length;
                n2 = 0;
                while (n2 < n) {
                    Object alias = objectArray[n2];
                    PropertyElement property = new PropertyElement();
                    property.setName(((AliasElement)alias).getName());
                    property.addType(((AliasElement)alias).getType());
                    window.addProperty(property);
                    ++n2;
                }
                if (window.hasProperties()) {
                    indexer.writeType(index, window, location);
                }
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
                sub.done();
            }
        }
        finally {
            sub.done();
        }
    }

    protected boolean isGlobalProperty(TypeElement type) {
        boolean result = false;
        if (type != null && !type.isInternal()) {
            String typeName = type.getName();
            result = !typeName.contains(".") && !typeName.startsWith("Class<");
        }
        return result;
    }

    public boolean isEnableType(BuildContextType contextType) {
        return true;
    }
}

