/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.contentassist.CompletionProposalType;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.contentassist.PropertyElementProposal;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import java.net.URI;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PlatformUI;

public class FunctionElementProposal
extends PropertyElementProposal {
    public FunctionElementProposal(FunctionElement function, int offset, int replaceLength, URI uri) {
        super(function, offset, replaceLength, uri);
        this.setCompletionProposalType(CompletionProposalType.FUNCTION);
    }

    public String getPrefix(IDocument document, int offset) {
        try {
            int length = offset - this._replacementOffset;
            if (length > 0) {
                String prefix = document.get(this._replacementOffset, length);
                if (prefix.startsWith("\"") && "__html_tag".equals(document.getPartition(offset).getType())) {
                    prefix = prefix.substring(1);
                    ++this._replacementOffset;
                }
                return prefix;
            }
        }
        catch (BadLocationException badLocationException) {}
        return "";
    }

    protected Character nextChar(IDocument document, int offset) {
        try {
            int line = document.getLineOfOffset(offset);
            IRegion region = document.getLineInformation(line);
            int lineEndOffset = region.getOffset() + region.getLength();
            while (offset < lineEndOffset) {
                char c = document.getChar(offset);
                if (!Character.isWhitespace(c)) {
                    return Character.valueOf(c);
                }
                ++offset;
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        try {
            if (this.nextChar(viewer.getDocument(), offset).charValue() == '(') {
                this._replacementString = this.property.getName();
                this._cursorPosition = this.property.getName().length();
                this.setApplyNeedReContentAssist(false);
            }
        }
        catch (Exception exception) {}
        super.apply(viewer, trigger, stateMask, offset);
        this.applyLinkedModel(viewer, offset);
        this.showContentInfo(viewer);
    }

    protected void applyLinkedModel(ITextViewer viewer, int offset) {
        try {
            if (this._replacementString.indexOf("(") > 0 && this._replacementString.indexOf(")") > 0) {
                int[] _positions;
                IDocument document = viewer.getDocument();
                LinkedModeModel.closeAllModels((IDocument)document);
                LinkedModeModel model = new LinkedModeModel();
                int i = 0;
                int shift = offset - this._replacementOffset;
                int[] nArray = _positions = new int[]{this._replacementString.length() - 1, this._replacementString.length()};
                int n = _positions.length;
                int n2 = 0;
                while (n2 < n) {
                    int pos = nArray[n2];
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    group.addPosition(new LinkedPosition(document, offset - shift + pos, 0, i++));
                    model.addGroup(group);
                    ++n2;
                }
                model.forceInstall();
                LinkedModeUI ui = new LinkedModeUI(model, viewer);
                ui.setCyclingMode(LinkedModeUI.CYCLE_ALWAYS);
                ui.setSimpleMode(true);
                ui.setExitPosition(viewer, offset - shift + _positions[_positions.length - 1], 0, Integer.MAX_VALUE);
                ui.enter();
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
        }
    }

    private void showContentInfo(final ITextViewer viewer) {
        try {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (((ITextOperationTarget)viewer).canDoOperation(14)) {
                        ((ITextOperationTarget)viewer).doOperation(14);
                    }
                }
            });
        }
        catch (Exception exception) {}
    }

    public Point getSelection(IDocument document) {
        if (this._replacementString.indexOf("(") > 0 && this._replacementString.indexOf(")") > 0) {
            int start = this._replacementString.indexOf("(") + 1;
            int end = this._replacementString.indexOf(",");
            if (end < 0) {
                end = this._replacementString.indexOf(")");
            }
            return new Point(this._replacementOffset + start, end - start);
        }
        return super.getSelection(document);
    }
}

