/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js;

import com.aptana.core.build.BuilderJob;
import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.contentassist.MetadataLoader;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.Messages;
import com.aptana.editor.js.contentassist.JSIndexQueryHelper;
import com.aptana.editor.js.contentassist.index.JSIndexCacher;
import com.aptana.editor.js.contentassist.index.JSMetadataReader;
import com.aptana.index.core.BuildContextType;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.RebuildIndexJob;
import com.aptana.ui.util.UIUtils;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.osgi.framework.Bundle;

public class JSMetadataLoader
extends MetadataLoader<JSMetadataReader> {
    public static final String JS_METADATA_SDK = "/metadata/plus_metadata.xml";
    public static final String JS_METADATA_LOADER = "JSMetadataLoader";

    public boolean belongsTo(Object family) {
        if (family != null) {
            System.out.println(family.toString());
            return JS_METADATA_LOADER.equals(family.toString());
        }
        return false;
    }

    public JSMetadataLoader() {
        super(Messages.Loading_Metadata);
    }

    protected JSMetadataReader createMetadataReader() {
        return new JSMetadataReader();
    }

    protected Bundle getBundle() {
        return JSPlugin.getDefault().getBundle();
    }

    protected String getIndexVersionKey() {
        return "JS_INDEX_VERSION";
    }

    protected String[] getMetadataFiles() {
        String[] plusJSLibs = new String[]{JS_METADATA_SDK, "/metadata/js_metadata.xml"};
        return plusJSLibs;
    }

    protected String getPluginId() {
        return "com.aptana.editor.js";
    }

    protected void postRebuild() {
        super.postRebuild();
    }

    private void rebuildProjectIndexes(final IProject project) {
        Job job = new Job(Messages.JSMetadataLoader_Rebuilding_Project_Indexes){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (project == null) {
                        IWorkspace ws = ResourcesPlugin.getWorkspace();
                        IProject[] iProjectArray = ws.getRoot().getProjects();
                        int n = iProjectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject pro = iProjectArray[n2];
                            Job[] jobs = Job.getJobManager().find((Object)pro);
                            boolean isBuildRunning = false;
                            if (jobs != null) {
                                Job[] jobArray = jobs;
                                int n3 = jobs.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    Job job = jobArray[n4];
                                    if (job instanceof BuilderJob) {
                                        isBuildRunning = true;
                                        break;
                                    }
                                    ++n4;
                                }
                            }
                            if (!isBuildRunning && pro != null && pro.isOpen()) {
                                RebuildIndexJob indexJob = new RebuildIndexJob(pro.getLocationURI(), BuildContextType.JS, pro);
                                indexJob.schedule();
                            }
                            ++n2;
                        }
                    } else if (project.isOpen()) {
                        RebuildIndexJob indexJob = new RebuildIndexJob(project.getLocationURI(), BuildContextType.JS, project);
                        indexJob.schedule();
                    }
                }
                catch (Exception e) {
                    UIUtils.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)UIUtils.getActiveShell(), (String)Messages.JSMetadataLoader_RebuildingProjectIndexError_Title, (String)MessageFormat.format("{0} {1}", e.getMessage(), Messages.JSMetadataLoader_RebuildingProjectIndexError_Message));
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected boolean isSDK(URL url) {
        return FileLocator.find((Bundle)this.getBundle(), (IPath)new Path(JS_METADATA_SDK), null).equals(url);
    }

    protected void writeIndex(JSMetadataReader reader) {
        this.getIndexManager().removeIndex(URI.create("metadata:/js"));
        this.getJSIndexCacher().initMetaDataCacher(this.getIndex(), Arrays.asList(reader.getTypes()));
    }

    protected IndexManager getIndexManager() {
        return IndexPlugin.getDefault().getIndexManager();
    }

    protected Index getIndex() {
        return JSIndexQueryHelper.getIndex();
    }

    protected void loadIndexCacher() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject[] projects = ws.getRoot().getProjects();
        try {
            this.loadMetadataCacheIndex();
            if (projects == null || projects.length < 1) {
                return;
            }
            this.loadProjectJSCacheIndex();
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
        }
    }

    private void loadProjectJSCacheIndex() {
        IFile iFile = this.getActiceFile();
        this.loadProjectJSCache(iFile);
    }

    protected void loadProjectJSCache(IFile iFile) {
        boolean isIndexfileExist;
        if (iFile == null) {
            return;
        }
        IProject project = iFile.getProject();
        if (project == null) {
            return;
        }
        URI puri = project.getLocationURI();
        if (puri == null) {
            return;
        }
        String uri = puri.toString();
        JSIndexCacher cacher = this.getJSIndexCacher();
        boolean isExistCache = cacher.isExistCache(uri);
        if (isExistCache) {
            return;
        }
        Index index = this.getIndex(puri);
        File indexFile = this.getJSIndexCacher().getIndexFile(index, false);
        boolean bl = isIndexfileExist = indexFile == null ? false : indexFile.exists();
        if (isIndexfileExist) {
            try {
                cacher.deSerialize(index);
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
                this.rebuildProjectIndexes(project);
            }
            return;
        }
        this.rebuildProjectIndexes(project);
    }

    private IFile getActiceFile() {
        IWorkbenchWindow workbenchWindow = JSPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            return null;
        }
        IWorkbenchPage page = workbenchWindow.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile iFile = null;
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            iFile = fileEditorInput.getFile();
        }
        return iFile;
    }

    private void loadMetadataCacheIndex() {
        boolean isIndexfileExist;
        JSIndexCacher cacher = this.getJSIndexCacher();
        boolean isExistCache = cacher.isExistCache("metadata:/js");
        if (isExistCache) {
            return;
        }
        Index index = this.getIndex();
        File indexFile = this.getJSIndexCacher().getIndexFile(index, false);
        boolean bl = isIndexfileExist = indexFile == null ? false : indexFile.exists();
        if (isIndexfileExist) {
            try {
                cacher.deSerialize(index);
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
                this.buildMetadata((IProgressMonitor)new NullProgressMonitor());
            }
        } else {
            this.buildMetadata((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private JSIndexCacher getJSIndexCacher() {
        return JSIndexCacher.getInstance();
    }

    private Index getIndex(URI uri) {
        IndexManager manager = this.getIndexManager();
        return manager.getIndex(uri);
    }

    protected boolean indexCorrupt() {
        Index index = this.getIndex();
        if (index == null) {
            return true;
        }
        File indexFile = this.getJSIndexCacher().getIndexFile(index, false);
        return indexFile == null || !indexFile.exists();
    }

    public boolean existsSameJobs() {
        Job[] jobs = Job.getJobManager().find((Object)JS_METADATA_LOADER);
        if (jobs != null) {
            Job[] jobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                Job job = jobArray[n2];
                if (job instanceof JSMetadataLoader) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

