/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js;

import com.aptana.core.IFilter;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.inferencing.JSObjectPropertiesCollector;
import com.aptana.editor.js.inferencing.JSPropertyCollection;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.parsing.ast.JSArgumentsNode;
import com.aptana.editor.js.parsing.ast.JSArrayNode;
import com.aptana.editor.js.parsing.ast.JSElementsNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSObjectNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.editor.js.parsing.ast.JSTreeWalker;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.pandora.core.appstream.AbstractNestedASTParser;
import com.pandora.core.appstream.IASTParser;
import com.pandora.core.appstream.RelationTree;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class JSASTParser
extends AbstractNestedASTParser
implements IASTParser {
    public boolean processAST(IFile file, RelationTree tree, IProject project, Set<URI> visitedUris) {
        try {
            ParseResult pResult = ParserPoolFactory.parse((String)"com.aptana.contenttype.js", (String)IOUtils.toString((InputStream)file.getContents(true), (String)file.getCharset()));
            if (pResult != null && pResult.getRootNode() != null) {
                JSParseRootNode rootNode = (JSParseRootNode)pResult.getRootNode();
                StringNodeCollector strCollector = new StringNodeCollector();
                strCollector.visit(rootNode);
                for (String str : strCollector.getStrings()) {
                    tree.addString(str);
                }
                this.processMUISubPages(tree, rootNode);
                this.processCMD(tree, rootNode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    protected void processMUISubPages(RelationTree tree, JSParseRootNode rootNode) {
        ArrayList<JSInvokeNode> invocations = new ArrayList<JSInvokeNode>();
        this.findInvokeNode((IParseNode)rootNode, invocations, CollectionsUtil.newSet((Object[])new String[]{"mui.init", "$.init"}));
        for (JSInvokeNode ivkNode : invocations) {
            IParseNode args = ivkNode.getArguments();
            if (args.isEmpty() || !(args.getChild(0) instanceof JSObjectNode)) continue;
            JSObjectPropertiesCollector objColl = new JSObjectPropertiesCollector();
            objColl.visit((JSNode)args.getChild(0));
            Map<String, JSNode> props = objColl.getProperties();
            JSNode pageNodes = props.get("subpages");
            JSNode valueNode = ParseUtil.getEqualsExpressNode((IParseNode)pageNodes);
            if (valueNode == null || !(valueNode instanceof JSArrayNode)) continue;
            JSArrayNode arrNode = (JSArrayNode)valueNode;
            Iterator iterator = arrNode.iterator();
            while (iterator.hasNext()) {
                IParseNode elements = (IParseNode)iterator.next();
                if (!(elements instanceof JSElementsNode)) continue;
                for (IParseNode child : elements) {
                    JSNode vNode;
                    if (!(child instanceof JSObjectNode)) continue;
                    JSObjectPropertiesCollector objCollector = new JSObjectPropertiesCollector();
                    objCollector.visit((JSObjectNode)child);
                    Map<String, JSNode> optionProperties = objCollector.getProperties();
                    JSNode urlNode = optionProperties.get("url");
                    if (urlNode == null || !((vNode = ParseUtil.getEqualsExpressNode((IParseNode)urlNode)) instanceof JSStringNode)) continue;
                    JSStringNode idString = (JSStringNode)vNode;
                    tree.addSubPage(idString.getString());
                }
            }
        }
    }

    private void findInvokeNode(IParseNode ast, List<JSInvokeNode> invocations, Set<String> expresses) {
        JSInvokeNode ivkNode;
        IParseNode childast;
        if (ast instanceof JSInvokeNode && (childast = (ivkNode = (JSInvokeNode)ast).getExpression()) != null && expresses.contains(childast.toString())) {
            invocations.add((JSInvokeNode)ast);
        }
        IParseNode[] iParseNodeArray = ast.getChildren();
        int n = iParseNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNode childnode = iParseNodeArray[n2];
            this.findInvokeNode(childnode, invocations, expresses);
            ++n2;
        }
    }

    protected void processCMD(RelationTree tree, JSParseRootNode rootNode) {
        JSArgumentsNode argsNode;
        JSInvokeNode ivkNode;
        IParseNode exprNode;
        IParseNode child;
        if (rootNode.hasChildren() && rootNode.getChildCount() == 1 && (child = rootNode.getChild(0)) instanceof JSInvokeNode && "define".equals((exprNode = (ivkNode = (JSInvokeNode)child).getExpression()).toString()) && (argsNode = (JSArgumentsNode)ivkNode.getArguments()).hasChildren() && argsNode.getChild(0) instanceof JSFunctionNode) {
            JSFunctionNode funcNode = (JSFunctionNode)argsNode.getChild(0);
            IParseNode params = funcNode.getParameters();
            String require = params.getChild(0).getText();
            JSScope global = rootNode.getGlobals();
            JSScope funcScope = global.getScopeAtOffset(funcNode.getBody().getStartingOffset());
            JSPropertyCollection property = funcScope.getSymbol(require);
            if (property != null) {
                List<JSNode> calls = property.getCalls();
                if (CollectionsUtil.isEmpty(calls)) {
                    return;
                }
                for (JSNode call : calls) {
                    JSNode requireModule;
                    JSInvokeNode invoke;
                    JSArgumentsNode args;
                    if (!(call.getParent() instanceof JSInvokeNode) || !(args = (JSArgumentsNode)(invoke = (JSInvokeNode)call.getParent()).getArguments()).hasChildren() || !((requireModule = ParseUtil.getEqualsExpressNode(args.getChild(0))) instanceof JSStringNode)) continue;
                    JSStringNode str = (JSStringNode)requireModule;
                    String basePath = tree.getContainer().getBasePath("seajs");
                    tree.addString(String.valueOf(basePath) + str.getString() + ".js");
                }
            }
        }
    }

    public boolean processNestedAST(Object astRoot, final RelationTree tree, IProject project) {
        if (astRoot != null && astRoot instanceof JSParseRootNode) {
            JSParseRootNode rootNode = (JSParseRootNode)((Object)astRoot);
            StringNodeCollector strCollector = new StringNodeCollector();
            strCollector.visit(rootNode);
            for (String str : strCollector.getStrings()) {
                tree.addString(str);
            }
            try {
                this.processMUISubPages(tree, rootNode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            com.aptana.parsing.util.ParseUtil.treeApply((IParseNode)rootNode, (IFilter)new IFilter<IParseNode>(){

                public boolean include(IParseNode item) {
                    if (item instanceof JSInvokeNode) {
                        JSInvokeNode ivkNode = (JSInvokeNode)item;
                        IParseNode exprNode = ivkNode.getExpression();
                        if ("seajs.config".equals(exprNode.toString())) {
                            IParseNode firstArg;
                            JSArgumentsNode argsNode = (JSArgumentsNode)ivkNode.getArguments();
                            if (argsNode.hasChildren() && (firstArg = argsNode.getChild(0)) instanceof JSObjectNode) {
                                JSNode valNode;
                                JSNode value;
                                JSObjectPropertiesCollector properties = new JSObjectPropertiesCollector();
                                properties.visit((JSObjectNode)firstArg);
                                Map<String, JSNode> props = properties.getProperties();
                                if (CollectionsUtil.isNotEmpty(props) && (value = props.get("base")) != null && (valNode = ParseUtil.getEqualsExpressNode((IParseNode)value)) != null && valNode instanceof JSStringNode) {
                                    String seajsBasePath = ((JSStringNode)valNode).getString();
                                    tree.registerBasePath("seajs", seajsBasePath);
                                }
                            }
                            System.out.println(ivkNode.getArguments());
                        } else if ("seajs.use".equals(exprNode.toString())) {
                            IParseNode firstArg;
                            JSNode valNode;
                            JSArgumentsNode argsNode = (JSArgumentsNode)ivkNode.getArguments();
                            if (argsNode.hasChildren() && (valNode = ParseUtil.getEqualsExpressNode((IParseNode)((JSNode)(firstArg = argsNode.getChild(0))))) != null && valNode instanceof JSStringNode) {
                                JSStringNode valStr = (JSStringNode)valNode;
                                tree.addString(String.valueOf(tree.getBasePath("seajs")) + valStr.getString() + ".js");
                            }
                            System.out.println(ivkNode.getArguments());
                        }
                    }
                    return true;
                }
            }, (boolean)false);
        }
        return false;
    }

    static class StringNodeCollector
    extends JSTreeWalker {
        private Set<String> strings = new HashSet<String>();

        StringNodeCollector() {
        }

        @Override
        public void visit(JSStringNode node) {
            this.strings.add(node.getString());
            super.visit(node);
        }

        public Set<String> getStrings() {
            return this.strings;
        }
    }
}

