/*
 * Decompiled with CFR 0.152.
 */
package io.emmet.eclipse;

import io.emmet.eclipse.EclipseEmmetHelper;
import io.emmet.eclipse.EclipseEmmetPlugin;
import io.emmet.eclipse.handlers.ExpandAbbreviationAction;
import io.emmet.eclipse.handlers.InsertFormattedLineBreakAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;

public class TabKeyHandler {
    private static HashMap<Integer, ITextEditor> installedEditors = new HashMap();
    private static HashMap<Integer, VerifyKeyListener> keyListeners = new HashMap();
    private static Set<IWorkbenchPage> inited = new HashSet<IWorkbenchPage>();
    private static boolean enabled = true;

    public static void install(IWorkbenchPart part) {
        IEditorPart editor;
        if (TabKeyHandler.isEnabled() && part instanceof IEditorPart && (editor = EclipseEmmetHelper.getTextEditor((IEditorPart)part)) instanceof ITextEditor) {
            TabKeyHandler.install((ITextEditor)editor);
        }
    }

    public static void install(ITextEditor editor) {
        if (editor == null || !TabKeyHandler.isEnabled()) {
            return;
        }
        Integer id = TabKeyHandler.getEditorId(editor);
        if (!installedEditors.containsKey(id)) {
            try {
                ITextViewer textViewer = EclipseEmmetHelper.getTextViewer((IEditorPart)editor);
                StyledText widget = textViewer.getTextWidget();
                widget.addVerifyKeyListener(TabKeyHandler.getKeyListener(editor));
                installedEditors.put(id, editor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void uninstall(AbstractTextEditor editor) {
        if (editor == null) {
            return;
        }
        Integer id = TabKeyHandler.getEditorId((ITextEditor)editor);
        if (installedEditors.containsKey(id)) {
            try {
                StyledText widget = EclipseEmmetHelper.getTextViewer((IEditorPart)editor).getTextWidget();
                widget.removeVerifyKeyListener(TabKeyHandler.getKeyListener((ITextEditor)editor));
                installedEditors.remove(id);
                keyListeners.remove(id);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void uninstall(IWorkbenchPart part) {
        IEditorPart editor;
        if (part instanceof IEditorPart && (editor = EclipseEmmetHelper.getTextEditor((IEditorPart)part)) instanceof AbstractTextEditor) {
            TabKeyHandler.uninstall((AbstractTextEditor)editor);
        }
    }

    public static Integer getEditorId(ITextEditor editor) {
        return editor.hashCode();
    }

    public static VerifyKeyListener getKeyListener(final ITextEditor editor) {
        Integer id = TabKeyHandler.getEditorId(editor);
        if (!keyListeners.containsKey(id)) {
            keyListeners.put(id, new VerifyKeyListener(){

                public void verifyKey(VerifyEvent event) {
                    IDocument document = EclipseEmmetHelper.getDocument((IEditorPart)editor);
                    if (document == null) {
                        return;
                    }
                    if (LinkedModeModel.hasInstalledModel((IDocument)document)) {
                        return;
                    }
                    if (event.doit) {
                        if (event.keyCode == 9 && TabKeyHandler.shouldHandleTabKey(editor.getEditorInput())) {
                            event.doit = !ExpandAbbreviationAction.expand();
                        } else if (event.keyCode == 13 && TabKeyHandler.allowEnterHandler()) {
                            event.doit = !InsertFormattedLineBreakAction.execute();
                        }
                    }
                }
            });
        }
        return keyListeners.get(id);
    }

    protected static boolean shouldHandleTabKey(IEditorInput editor) {
        if (!TabKeyHandler.allowTabHandler()) {
            return false;
        }
        IPreferenceStore store = EclipseEmmetPlugin.getDefault().getPreferenceStore();
        String exts = store.getString("tabExtensions");
        if (exts == null || exts.trim().length() == 0) {
            return true;
        }
        String[] parts = exts.toLowerCase().split(",");
        String curFilePath = EclipseEmmetHelper.getURI(editor);
        String curExt = "";
        int i = curFilePath.lastIndexOf(46);
        if (i > 0) {
            curExt = curFilePath.substring(i + 1).toLowerCase();
        }
        if (curExt.length() == 0) {
            return false;
        }
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            if (e.trim().equals(curExt)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean allowTabHandler() {
        IPreferenceStore store = EclipseEmmetPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("tabExpand");
    }

    public static boolean allowEnterHandler() {
        IPreferenceStore store = EclipseEmmetPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("upgradeEditors");
    }

    public static void updateActivityState() {
        TabKeyHandler.setEnabled(TabKeyHandler.allowTabHandler() || TabKeyHandler.allowEnterHandler());
    }

    public static void setup(final IWorkbenchPage page) {
        if (page != null && !inited.contains(page)) {
            inited.add(page);
            TabKeyHandler.updateActivityState();
            page.addPartListener(new IPartListener(){

                public void partOpened(IWorkbenchPart part) {
                    if (TabKeyHandler.isEnabled()) {
                        TabKeyHandler.install(part);
                    }
                }

                public void partDeactivated(IWorkbenchPart part) {
                }

                public void partClosed(IWorkbenchPart part) {
                    inited.remove(page);
                    TabKeyHandler.uninstall(part);
                }

                public void partBroughtToTop(IWorkbenchPart part) {
                }

                public void partActivated(IWorkbenchPart part) {
                    if (TabKeyHandler.isEnabled()) {
                        TabKeyHandler.install(part);
                    }
                }
            });
        }
    }

    public static void installForAll() {
        IEditorReference[] editors = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int i = 0;
        while (i < editors.length) {
            IEditorReference editor = editors[i];
            TabKeyHandler.install((IWorkbenchPart)editor.getEditor(false));
            ++i;
        }
    }

    public static void uninstallFromAll() {
        IEditorReference[] editors = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int i = 0;
        while (i < editors.length) {
            IEditorReference editor = editors[i];
            TabKeyHandler.uninstall((IWorkbenchPart)editor.getEditor(false));
            ++i;
        }
    }

    public static void setEnabled(boolean enabled) {
        TabKeyHandler.enabled = enabled;
        if (enabled) {
            TabKeyHandler.installForAll();
        } else {
            TabKeyHandler.uninstallFromAll();
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }
}

