/*
 * Decompiled with CFR 0.152.
 */
package io.emmet.eclipse;

import io.emmet.eclipse.EclipseEmmetEditor;
import java.lang.reflect.Method;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorTypeInvestigator {
    public static String TYPE_HTML = "html";
    public static String TYPE_XML = "xml";
    public static String TYPE_CSS = "css";
    public static String TYPE_HAML = "haml";
    public static String TYPE_XSL = "xsl";
    public static String PROFILE_XML = "xml";
    public static String PROFILE_XHTML = "xhtml";
    public static String PROFILE_HTML = "html";
    public static String PROFILE_DEFAULT = "default";

    private EditorTypeInvestigator() {
    }

    public static String getSyntax(EclipseEmmetEditor editor) {
        IEditorPart ed;
        String result = null;
        IDocument doc = editor.getDocument();
        String className = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getSite().getId().toLowerCase();
        try {
            ITypedRegion[] regions = doc.computePartitioning(editor.getCaretPos(), 0);
            if (regions.length > 0) {
                result = EditorTypeInvestigator.guessSyntaxFromString(regions[0].getType());
            }
        }
        catch (Exception regions) {
            // empty catch block
        }
        if (result == null && (ed = editor.getEditor()) instanceof ITextEditor) {
            Class<?> editorClass = ed.getClass();
            try {
                Method getFileContext = editorClass.getMethod("getFileContext", new Class[0]);
                Object fileContext = getFileContext.invoke((Object)ed, new Object[0]);
                if (fileContext != null) {
                    Class<?> fcClass = fileContext.getClass();
                    Method getPartition = fcClass.getMethod("getPartitionAtOffset", Integer.TYPE);
                    ITypedRegion region = (ITypedRegion)getPartition.invoke(fileContext, editor.getCaretPos());
                    result = EditorTypeInvestigator.guessSyntaxFromString(region.getType());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result == null) {
            result = EditorTypeInvestigator.guessSyntaxFromString(className);
        }
        if (result == TYPE_XML && EditorTypeInvestigator.guessSyntaxFromString(className) == TYPE_XSL) {
            result = TYPE_XSL;
        }
        if (result == null && editor.getEditor().getEditorInput() != null) {
            result = EditorTypeInvestigator.guessSyntaxFromName(editor.getEditor().getEditorInput().getName());
        }
        return result;
    }

    private static String guessSyntaxFromString(String str) {
        if (str.indexOf("xsl") != -1) {
            return TYPE_XSL;
        }
        if (str.indexOf("xml") != -1) {
            return TYPE_XML;
        }
        if (str.indexOf("haml") != -1) {
            return TYPE_HAML;
        }
        if (str.indexOf("sass") != -1) {
            return TYPE_CSS;
        }
        if (str.indexOf("scss") != -1) {
            return TYPE_CSS;
        }
        if (str.indexOf("css") != -1) {
            return TYPE_CSS;
        }
        if (str.indexOf(".less.") != -1) {
            return TYPE_CSS;
        }
        if (str.indexOf("html") != -1) {
            return TYPE_HTML;
        }
        return null;
    }

    private static String guessSyntaxFromName(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.toLowerCase()).endsWith(".xsl")) {
            return TYPE_XSL;
        }
        if (str.endsWith(".xml")) {
            return TYPE_XML;
        }
        if (str.endsWith(".haml")) {
            return TYPE_HAML;
        }
        if (str.endsWith(".sass")) {
            return TYPE_CSS;
        }
        if (str.endsWith(".scss")) {
            return TYPE_CSS;
        }
        if (str.endsWith(".css")) {
            return TYPE_CSS;
        }
        if (str.endsWith(".less")) {
            return TYPE_CSS;
        }
        if (str.endsWith(".html")) {
            return TYPE_HTML;
        }
        return null;
    }

    public static String getOutputProfile(EclipseEmmetEditor editor) {
        String syntax = EditorTypeInvestigator.getSyntax(editor);
        if (syntax != null) {
            if (syntax.equals(TYPE_XML) || syntax.equals(TYPE_XSL)) {
                return PROFILE_XML;
            }
            return syntax;
        }
        return PROFILE_DEFAULT;
    }
}

