/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.text.hyperlink;

import com.aptana.core.IFilter;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.extensions.ISpecialListHandler;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.css.parsing.ast.CSSAttributeSelectorNode;
import com.aptana.editor.css.parsing.ast.CSSRuleNode;
import com.aptana.editor.css.parsing.ast.CSSSelectorNode;
import com.aptana.editor.html.HTMLEditor;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.ext.HTMLScript;
import com.aptana.editor.html.ext.ScriptRange;
import com.aptana.editor.html.parsing.HTMLParseRootNode;
import com.aptana.editor.html.parsing.HTMLParseState;
import com.aptana.editor.html.parsing.ast.HTMLElementNode;
import com.aptana.editor.html.parsing.ast.HTMLSpecialNode;
import com.aptana.editor.html.text.hyperlink.StringSearchHyperlink;
import com.aptana.editor.js.JSSourceEditor;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.htmlext.IAttrNameAware;
import com.aptana.editor.js.hyperlink.IStringHyperlinkDetector;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.index.core.Index;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseNodeAttribute;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import com.pandora.core.utils.URIUtils;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class JSStringHyperlinkDetector
implements IStringHyperlinkDetector {
    private static final String STYLE = "style";
    private IParseNode targetNone;
    private List<IRange> ranges;

    public IHyperlink[] detectHyperlinks(AbstractThemeableEditor editor, String content, IRegion linkRegion, Set<String> types) {
        ArrayList<IHyperlink> hyperlinks = new ArrayList<IHyperlink>();
        if (StringUtil.isEmpty((String)content)) {
            return null;
        }
        String attrValueType = "AttrValueString";
        if (!CollectionsUtil.isEmpty(types)) {
            if (types.contains("IDString")) {
                this.hyperlinkIDString(editor, content, linkRegion, hyperlinks);
            } else if (!types.contains("SelectorString")) {
                JSNode equalsExpressNode;
                IAttrNameAware attrNameHandler;
                String attrName;
                ISpecialListHandler handler;
                if (types.contains("ClassString")) {
                    this.hyperlinkClassString(editor, content, linkRegion, hyperlinks);
                } else if (!types.contains("HTMLString") && !types.contains("URIString") && types.contains(attrValueType) && this.targetNone != null && (handler = (ISpecialListHandler)CommonContentAssistProcessor.SPEC_MAPS.get(attrValueType)) instanceof IAttrNameAware && StringUtil.isNotBlank((String)(attrName = (attrNameHandler = (IAttrNameAware)handler).inferrerAttrName(equalsExpressNode = ParseUtil.getEqualsExpressNode((IParseNode)this.targetNone), editor)))) {
                    if (attrName.toLowerCase().equals("class")) {
                        this.hyperlinkClassString(editor, content, linkRegion, hyperlinks);
                    } else if (attrName.toLowerCase().equals("id")) {
                        this.hyperlinkIDString(editor, content, linkRegion, hyperlinks);
                    }
                }
            }
        }
        if (hyperlinks.size() == 0) {
            return null;
        }
        return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
    }

    protected void hyperlinkClassString(AbstractThemeableEditor editor, String content, IRegion linkRegion, List<IHyperlink> hyperlinks) {
        HTMLParseState state;
        String fileContent;
        IFile file;
        Set<String> set;
        String cls;
        int offset = JFaceTextUtil.getOffsetForCursorLocation((ITextViewer)editor.getISourceViewer());
        String[] classes = content.split(" ");
        IRegion realRegion = this.getRealRegion(linkRegion, editor);
        int startOffset = 0;
        int relativeOffset = offset - realRegion.getOffset();
        String clazz = null;
        String[] stringArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            cls = stringArray[n2];
            if (relativeOffset >= startOffset && relativeOffset <= startOffset + cls.length() - 1) {
                clazz = cls;
                break;
            }
            startOffset = cls.length() + 1;
            ++n2;
        }
        if (StringUtil.isEmpty(clazz)) {
            return;
        }
        cls = clazz;
        Region showRegion = new Region(realRegion.getOffset() + startOffset, cls.length());
        HashSet<IRange> targetRanges = new HashSet<IRange>();
        HTMLIndexQueryHelper htmlIndexHelper = new HTMLIndexQueryHelper();
        Set<Object> htmlFilesSet = new HashSet();
        HashSet<String> cssFilesSet = new HashSet<String>();
        Index index = EditorUtil.getIndex((AbstractThemeableEditor)editor);
        URI curi = EditorUtil.getURI((IEditorPart)editor);
        URI projectURI = EditorUtil.getProjectURI((AbstractThemeableEditor)editor);
        String currentTargetPath = "";
        Map<String, Set<String>> cssFilesMap = htmlIndexHelper.getCSSReferences(index);
        if (editor instanceof HTMLEditor || this.isHtmlEditor(editor)) {
            if (projectURI != null) {
                currentTargetPath = projectURI.relativize(curi).toString();
            }
            this.addCssFilesSet(cssFilesSet, cssFilesMap, currentTargetPath, projectURI);
            try {
                HTMLParseState htmlParseState = new HTMLParseState(editor.getDocument().get());
                this.processHTMLNode(cls, targetRanges, htmlParseState);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
            }
            for (IRange range : targetRanges) {
                try {
                    hyperlinks.add(new StringSearchHyperlink((IRegion)showRegion, "open class definition in local,lineNum=" + (1 + editor.getDocument().getLineOfOffset(range.getStartingOffset())) + "]", (IRegion)new Region(range.getStartingOffset(), range.getLength()), curi));
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
            targetRanges.clear();
        } else if (editor instanceof JSSourceEditor || this.isJSEditor(editor)) {
            String currentUri = curi.toString();
            htmlFilesSet = htmlIndexHelper.getJSReferences(index).get(currentUri);
            if (!CollectionsUtil.isEmpty(htmlFilesSet)) {
                for (String string : htmlFilesSet) {
                    this.addCssFilesSet(cssFilesSet, cssFilesMap, string, projectURI);
                }
            }
        }
        if (CollectionsUtil.isEmpty(htmlFilesSet) && CollectionsUtil.isEmpty(cssFilesSet)) {
            return;
        }
        Map<String, Set<String>> classList = htmlIndexHelper.getClassList(index);
        if (!CollectionsUtil.isEmpty(classList) && !CollectionsUtil.isEmpty(set = classList.get(cls))) {
            if (!CollectionsUtil.isEmpty(htmlFilesSet)) {
                htmlFilesSet.retainAll(set);
            }
            if (!CollectionsUtil.isEmpty(cssFilesSet)) {
                cssFilesSet.retainAll(set);
            }
        }
        if (!CollectionsUtil.isEmpty(htmlFilesSet)) {
            for (String string : htmlFilesSet) {
                file = EditorUtil.getProject((AbstractThemeableEditor)editor).getFile(string);
                try {
                    fileContent = FileUtils.readFileToString((File)file.getLocation().makeAbsolute().toFile(), (String)file.getCharset());
                    state = new HTMLParseState(fileContent);
                    this.processHTMLNode(cls, targetRanges, state);
                    Document document = null;
                    if (!CollectionsUtil.isEmpty(targetRanges)) {
                        document = new Document(fileContent);
                    }
                    for (IRange range : targetRanges) {
                        hyperlinks.add(new StringSearchHyperlink((IRegion)showRegion, "open Class definition in " + string + ",lineNum=" + (1 + document.getLineOfOffset(range.getStartingOffset())) + "]", (IRegion)new Region(range.getStartingOffset(), range.getLength()), file.getLocationURI()));
                    }
                    targetRanges.clear();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (!CollectionsUtil.isEmpty(cssFilesSet)) {
            for (String string : cssFilesSet) {
                file = EditorUtil.getProject((AbstractThemeableEditor)editor).getFile(string);
                try {
                    fileContent = FileUtils.readFileToString((File)file.getLocation().makeAbsolute().toFile(), (String)file.getCharset());
                    state = new ParseState(fileContent);
                    IParseRootNode rootNode = ParserPoolFactory.parse((String)"com.aptana.contenttype.css", (IParseState)state).getRootNode();
                    String language = rootNode.getLanguage();
                    if ("com.aptana.contenttype.css".equals(language)) {
                        this.walkCSSNode((IParseNode)rootNode, targetRanges, cls, 0);
                    }
                    Document document = null;
                    if (!CollectionsUtil.isEmpty(targetRanges)) {
                        document = new Document(fileContent);
                    }
                    for (IRange range : targetRanges) {
                        hyperlinks.add(new StringSearchHyperlink((IRegion)showRegion, "open Class definition in " + string + ",lineNum=" + (1 + document.getLineOfOffset(range.getStartingOffset())) + "]", (IRegion)new Region(range.getStartingOffset(), range.getLength()), file.getLocationURI()));
                    }
                    targetRanges.clear();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean isJSEditor(AbstractThemeableEditor editor) {
        return AbstractThemeableEditor.EDITOR_PART_PROPERTY_TYPE.IS_JS_EDITOR.getValue().equals(editor.getPartProperty("EDITOR_PART_PROPERTY_TYPE_KEY"));
    }

    private boolean isHtmlEditor(AbstractThemeableEditor editor) {
        return AbstractThemeableEditor.EDITOR_PART_PROPERTY_TYPE.IS_HTML_EDITOR.getValue().equals(editor.getPartProperty("EDITOR_PART_PROPERTY_TYPE_KEY"));
    }

    public void processHTMLNode(final String cls, final Set<IRange> targetRanges, HTMLParseState htmlParseState) throws Exception {
        IParseRootNode rootNode = ParserPoolFactory.parse((String)"com.aptana.contenttype.html", (IParseState)htmlParseState).getRootNode();
        if (rootNode instanceof HTMLParseRootNode) {
            com.aptana.parsing.util.ParseUtil.treeApply((IParseNode)rootNode, (IFilter)new IFilter<IParseNode>(){

                public boolean include(IParseNode item) {
                    String language;
                    IParseNode child;
                    HTMLSpecialNode element;
                    String elementName;
                    if (item instanceof HTMLSpecialNode && StringUtil.isNotEmpty((String)(elementName = (element = (HTMLSpecialNode)item).getName())) && elementName.equalsIgnoreCase(JSStringHyperlinkDetector.STYLE) && (child = element.getChild(0)) != null && "com.aptana.contenttype.css".equals(language = child.getLanguage())) {
                        JSStringHyperlinkDetector.this.walkCSSNode(child, targetRanges, cls, child.getStartingOffset());
                    }
                    return true;
                }
            }, (boolean)false);
        }
    }

    protected void walkCSSNode(IParseNode current, Set<IRange> targetRanges, String className, int pOffset) {
        int n;
        int endOffset;
        int startOffset;
        Range valueRange;
        CSSAttributeSelectorNode cssAttributeSelectorNode;
        String text;
        if (current == null || StringUtil.isBlank((String)className)) {
            return;
        }
        if (current instanceof CSSAttributeSelectorNode && !StringUtil.isEmpty((String)(text = (cssAttributeSelectorNode = (CSSAttributeSelectorNode)current).getText())) && text.charAt(0) == '.' && text.equals("." + className) && (valueRange = new Range(pOffset + (startOffset = cssAttributeSelectorNode.getStartingOffset()), pOffset + (endOffset = cssAttributeSelectorNode.getEndingOffset()))) != null) {
            targetRanges.add((IRange)valueRange);
        }
        if (current instanceof CSSRuleNode) {
            CSSRuleNode cssRuleNode = (CSSRuleNode)current;
            CSSSelectorNode[] cSSSelectorNodeArray = cssRuleNode.getSelectors();
            int n2 = cSSSelectorNodeArray.length;
            n = 0;
            while (n < n2) {
                CSSSelectorNode child = cSSSelectorNodeArray[n];
                this.walkCSSNode((IParseNode)child, targetRanges, className, pOffset);
                ++n;
            }
        } else {
            IParseNode[] iParseNodeArray = current.getChildren();
            n = iParseNodeArray.length;
            int n3 = 0;
            while (n3 < n) {
                IParseNode child = iParseNodeArray[n3];
                this.walkCSSNode(child, targetRanges, className, pOffset);
                ++n3;
            }
        }
    }

    public void addCssFilesSet(Set<String> cssFilesSet, Map<String, Set<String>> cssFilesMap, String htmlFile, URI projectURI) {
        if (CollectionsUtil.isEmpty(cssFilesMap) || StringUtil.isBlank((String)htmlFile) || projectURI == null) {
            return;
        }
        String projectPath = projectURI.toString();
        Set<String> cssUriSet = cssFilesMap.keySet();
        for (String cssUri : cssUriSet) {
            String currentTargetPath;
            Set<String> htmlUriSet = cssFilesMap.get(cssUri);
            if (!htmlUriSet.contains(htmlFile) || StringUtil.isBlank((String)(currentTargetPath = URIUtils.relativeLocation((String)cssUri, (String)projectPath)))) continue;
            if (currentTargetPath.startsWith("/")) {
                currentTargetPath = currentTargetPath.substring(1);
            }
            cssFilesSet.add(currentTargetPath);
        }
    }

    protected void hyperlinkIDString(final AbstractThemeableEditor editor, final String content, final IRegion linkRegion, final List<IHyperlink> hyperlinks) {
        if (editor instanceof HTMLEditor || this.isHtmlEditor(editor)) {
            try {
                HTMLParseState htmlParseState = new HTMLParseState(editor.getDocument().get());
                htmlParseState.setParseNestedLanguage(false);
                IParseRootNode rootNode = ParserPoolFactory.parse((String)"com.aptana.contenttype.html", (IParseState)htmlParseState).getRootNode();
                if (rootNode instanceof HTMLParseRootNode) {
                    com.aptana.parsing.util.ParseUtil.treeApply((IParseNode)rootNode, (IFilter)new IFilter<IParseNode>(){

                        public boolean include(IParseNode item) {
                            IParseNodeAttribute attr;
                            IRange valueRange;
                            HTMLElementNode element;
                            if (item instanceof HTMLElementNode && content.equals((element = (HTMLElementNode)item).getID()) && (valueRange = (attr = element.getAttribute("id")).getValueRange()) != null) {
                                try {
                                    hyperlinks.add(new StringSearchHyperlink(JSStringHyperlinkDetector.this.getRealRegion(linkRegion, editor), "open id definition in local[tag=" + element.getElementName() + ",lineNum=" + (1 + editor.getDocument().getLineOfOffset(element.getStartingOffset())) + "]", (IRegion)new Region(valueRange.getStartingOffset() + 1, valueRange.getLength() - 3), EditorUtil.getURI((IEditorPart)editor)));
                                }
                                catch (BadLocationException e) {
                                    IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
                                }
                            }
                            return true;
                        }
                    }, (boolean)false);
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
            }
        } else if (editor instanceof JSSourceEditor || this.isJSEditor(editor)) {
            Set<String> paths;
            HTMLIndexQueryHelper htmlIndexHelper = new HTMLIndexQueryHelper();
            Index index = EditorUtil.getIndex((AbstractThemeableEditor)editor);
            Set<String> htmlFiles = htmlIndexHelper.getJSReferences(index).get(EditorUtil.getURI((IEditorPart)editor).toString());
            Map<String, Set<String>> ids = htmlIndexHelper.getIDList(index);
            if (ids != null && (paths = ids.get(content)) != null && htmlFiles != null) {
                htmlFiles.retainAll(paths);
            }
            if (!CollectionsUtil.isEmpty(htmlFiles)) {
                for (final String htmlFile : htmlFiles) {
                    IFile file = EditorUtil.getProject((AbstractThemeableEditor)editor).getFile(htmlFile);
                    try {
                        String fileContent = FileUtils.readFileToString((File)file.getLocation().makeAbsolute().toFile(), (String)file.getCharset());
                        Document document = new Document(fileContent);
                        HTMLParseState state = new HTMLParseState(fileContent);
                        state.setParseNestedLanguage(false);
                        IParseRootNode rootNode = ParserPoolFactory.parse((String)"com.aptana.contenttype.html", (IParseState)state).getRootNode();
                        if (!(rootNode instanceof HTMLParseRootNode)) continue;
                        com.aptana.parsing.util.ParseUtil.treeApply((IParseNode)rootNode, (IFilter)new IFilter<IParseNode>((IDocument)document, file){
                            private final /* synthetic */ IDocument val$document;
                            private final /* synthetic */ IFile val$file;
                            {
                                this.val$document = iDocument;
                                this.val$file = iFile;
                            }

                            public boolean include(IParseNode item) {
                                IParseNodeAttribute attr;
                                IRange valueRange;
                                HTMLElementNode element;
                                if (item instanceof HTMLElementNode && content.equals((element = (HTMLElementNode)item).getID()) && (valueRange = (attr = element.getAttribute("id")).getValueRange()) != null) {
                                    try {
                                        hyperlinks.add(new StringSearchHyperlink(linkRegion, "open id definition in " + htmlFile + "[tag=" + element.getElementName() + ",lineNum=" + (1 + this.val$document.getLineOfOffset(element.getStartingOffset())) + "]", (IRegion)new Region(valueRange.getStartingOffset() + 1, valueRange.getLength() - 3), this.val$file.getLocationURI()));
                                    }
                                    catch (BadLocationException e) {
                                        e.printStackTrace();
                                    }
                                }
                                return true;
                            }
                        }, (boolean)false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private IRegion getRealRegion(IRegion astRegion, AbstractThemeableEditor editor) {
        if (editor instanceof HTMLEditor || this.isHtmlEditor(editor)) {
            IEditorInput input = editor.getEditorInput();
            IFile file = null;
            if (input != null && input instanceof IFileEditorInput) {
                IFileEditorInput fileInput = (IFileEditorInput)input;
                file = fileInput.getFile();
            }
            HTMLScript htmlScript = new HTMLScript(editor.getDocument(), 0, file, null, this.getRanges());
            List<IRange> ranges = htmlScript.getScriptsInHTML();
            for (IRange range : ranges) {
                ScriptRange scriptRange;
                if (!(range instanceof ScriptRange) || (scriptRange = (ScriptRange)range).getAllSourceStartOffset() > (long)astRegion.getOffset() || scriptRange.getAllSourceEndOffset() < (long)astRegion.getOffset()) continue;
                int sourceStartOffset = (int)scriptRange.getAllSourceStartOffset();
                int sourceOffset = astRegion.getOffset();
                int subSourceOffset = sourceOffset - sourceStartOffset;
                return new Region(scriptRange.getStartingOffset() + subSourceOffset, astRegion.getLength());
            }
        }
        return astRegion;
    }

    public void setTargetNode(IParseNode node) {
        this.targetNone = node;
    }

    public void setRanges(List<IRange> ranges) {
        this.ranges = ranges;
    }

    public List<IRange> getRanges() {
        return this.ranges;
    }
}

