/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.text.hyperlink;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.ext.HTMLScriptRange;
import com.aptana.editor.html.text.hyperlink.CSSClassHyperlinkDetector;
import com.aptana.editor.html.text.hyperlink.HTMLScriptHyperlinkDetector;
import com.aptana.parsing.lexer.IRange;
import com.pandora.core.utils.RegularUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;

public class HTMLHyperlinkDetector
extends AbstractHyperlinkDetector {
    protected static final String JAVASCRIPT_PREFIX = "javascript:";
    protected final CSSClassHyperlinkDetector cssClassHyperlinkDetector = new CSSClassHyperlinkDetector();
    protected final HTMLScriptHyperlinkDetector htmlScriptHyperlinkDetector = new HTMLScriptHyperlinkDetector();

    protected AbstractThemeableEditor getEditor(ITextViewer textViewer) {
        AbstractThemeableEditor result = null;
        if (textViewer instanceof IAdaptable) {
            result = (AbstractThemeableEditor)((IAdaptable)textViewer).getAdapter(AbstractThemeableEditor.class);
        }
        return result;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        AbstractThemeableEditor editor = this.getEditor(textViewer);
        return this.detectHyperlinks(editor, region, canShowMultipleHyperlinks);
    }

    public IHyperlink[] detectHyperlinks(AbstractThemeableEditor editor, IRegion region, boolean canShowMultipleHyperlinks) {
        IDocument doc = editor.getDocument();
        IdeLog.logInfo((Plugin)HTMLPlugin.getDefault(), (String)"step into html hyperlink inferrer....");
        int offset = region.getOffset();
        HTMLScriptRange range = new HTMLScriptRange();
        IRange scriptRange = range.getActiveRange(doc, offset);
        if (scriptRange != null) {
            IdeLog.logInfo((Plugin)HTMLPlugin.getDefault(), (String)"step into htmlscript hyperlink inferrer....");
            return this.htmlScriptHyperlinkDetector.detectHyperlinks(editor, region, canShowMultipleHyperlinks);
        }
        try {
            IRegion lineRegion = doc.getLineInformationOfOffset(region.getOffset());
            String line = doc.get(lineRegion.getOffset(), lineRegion.getLength());
            IRegion[] regions = RegularUtils.matchs((String)"[\\s]+(on[a-zA-Z]+)[\\s]*=[\\s]*[\"']([\\{\\}'(,)\\.\\s=:;_a-zA-Z0-9-]*)[\"']", (String)line, (int)2);
            if (regions == null || regions.length == 0) {
                return this.cssClassHyperlinkDetector.detectHyperlinks(editor, region, canShowMultipleHyperlinks);
            }
            int lineOffset = offset - lineRegion.getOffset();
            IRegion targetRegion = null;
            IRegion[] iRegionArray = regions;
            int n = regions.length;
            int n2 = 0;
            while (n2 < n) {
                IRegion r = iRegionArray[n2];
                if (r.getOffset() <= lineOffset && r.getOffset() + r.getLength() >= lineOffset) {
                    targetRegion = r;
                    break;
                }
                ++n2;
            }
            if (targetRegion != null) {
                String jsEventFuncName = line.substring(targetRegion.getOffset(), targetRegion.getOffset() + targetRegion.getLength());
                int start = targetRegion.getOffset();
                int length = targetRegion.getLength();
                if (StringUtil.isNotEmpty((String)jsEventFuncName) && jsEventFuncName.startsWith(JAVASCRIPT_PREFIX)) {
                    jsEventFuncName = jsEventFuncName.replaceFirst(JAVASCRIPT_PREFIX, "");
                    start += JAVASCRIPT_PREFIX.length();
                    length -= JAVASCRIPT_PREFIX.length();
                }
                Region region2 = new Region(lineRegion.getOffset() + start, length);
                return this.htmlScriptHyperlinkDetector.detectHyperlinks(editor, region, canShowMultipleHyperlinks, jsEventFuncName, (IRegion)region2);
            }
            return this.cssClassHyperlinkDetector.detectHyperlinks(editor, region, canShowMultipleHyperlinks);
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
            return null;
        }
    }
}

