/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.text.hyperlink;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.IOUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.ExtendedFastPartitioner;
import com.aptana.editor.common.IExtendedPartitioner;
import com.aptana.editor.common.IPartitionerSwitchStrategy;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.NullPartitionerSwitchStrategy;
import com.aptana.editor.common.text.hyperlink.EditorSearchHyperlink;
import com.aptana.editor.common.text.hyperlink.IndexQueryingHyperlinkDetector;
import com.aptana.editor.common.text.rules.CompositePartitionScanner;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.NullSubPartitionScanner;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.HTMLSourceConfiguration;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.index.core.Index;
import com.aptana.index.core.QueryResult;
import com.pandora.core.project.HMobileProject;
import com.pandora.core.utils.RegularUtils;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public class CSSClassHyperlinkDetector
extends IndexQueryingHyperlinkDetector {
    private static final Pattern CSS_CLASS_PATTERN = Pattern.compile("class[\\s]*=[\\s]*[\"']([_a-zA-Z0-9-\\s]+)[\"']");
    HTMLIndexQueryHelper indexQueryHelper = new HTMLIndexQueryHelper();
    Index index;
    IProject project;
    List<String> cssRefrenceList;

    protected Index getIndex() {
        return this.getIndexManager().getIndex(this.project.getLocationURI());
    }

    protected AbstractThemeableEditor getEditor(ITextViewer textViewer) {
        AbstractThemeableEditor result = null;
        if (textViewer instanceof IAdaptable) {
            result = (AbstractThemeableEditor)((IAdaptable)textViewer).getAdapter(AbstractThemeableEditor.class);
        }
        return result;
    }

    protected IProject getProject(AbstractThemeableEditor editor) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            IProject project = file.getProject();
            return project;
        }
        return null;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        AbstractThemeableEditor editor = this.getEditor(textViewer);
        IHyperlink[] hyperlinks = this.detectHyperlinks(editor, region, canShowMultipleHyperlinks);
        return hyperlinks;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IHyperlink[] detectHyperlinks(AbstractThemeableEditor editor, IRegion region, boolean canShowMultipleHyperlinks) {
        IFile file = this.getIFile(editor);
        if (file == null) {
            return null;
        }
        ArrayList<EditorSearchHyperlink> hyperlinks = new ArrayList<EditorSearchHyperlink>();
        try {
            this.project = this.getProject(editor);
            IDocument doc = editor.getDocument();
            IRegion lineRegion = doc.getLineInformationOfOffset(region.getOffset());
            String line = doc.get(lineRegion.getOffset(), lineRegion.getLength());
            Matcher m = CSS_CLASS_PATTERN.matcher(line);
            this.index = this.getIndex();
            if (this.index == null) {
                return null;
            }
            int cursorOffset = region.getOffset() - lineRegion.getOffset();
            boolean findToken = false;
            String content = editor.getDocument().get();
            String iFileP = file.getLocationURI().toString();
            this.cssRefrenceList = this.getCSSFileRefrences(file);
            while (m.find() && !findToken) {
                String cssClass = m.group(1);
                if (StringUtil.isEmpty((String)cssClass)) {
                    return null;
                }
                int startOffset = m.start(1);
                String[] tokens = cssClass.split(" ");
                String cssToken = null;
                int offset = 0;
                String[] stringArray = tokens;
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    int endOffset = offset + token.length() + 1;
                    if (startOffset + endOffset > cursorOffset && startOffset + offset <= cursorOffset) {
                        cssToken = token;
                        findToken = true;
                        break;
                    }
                    offset = endOffset;
                    ++n2;
                }
                if (StringUtil.isEmpty(cssToken)) continue;
                List results = this.index.query(new String[]{"css.class"}, cssToken, 8);
                if (results == null || results.isEmpty()) {
                    return null;
                }
                int start = m.start(1) + lineRegion.getOffset() + offset;
                int length = cssToken.length();
                Region linkRegion = new Region(start, length);
                for (QueryResult result : results) {
                    Set documents = result.getDocuments();
                    if (documents == null || documents.isEmpty()) continue;
                    for (String filepath : documents) {
                        IRegion[] regs;
                        if (!this.checkFilePath(filepath, file) || iFileP.equals(filepath) && ((regs = RegularUtils.matchs((String)("\\." + cssToken + "[^a-zA-Z0-9_]"), (String)content, (int)0)) == null || regs.length < 1)) continue;
                        hyperlinks.add(new EditorSearchHyperlink(this.project, (IRegion)linkRegion, "\\." + cssToken + "[^a-zA-Z0-9_]", new URI(filepath)));
                        if (canShowMultipleHyperlinks) continue;
                        return new IHyperlink[]{(IHyperlink)hyperlinks.get(0)};
                    }
                }
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
        }
        if (hyperlinks.isEmpty()) {
            return null;
        }
        return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
    }

    private boolean checkFilePath(String filepath, IFile file) {
        String fpath = filepath.substring(this.project.getLocationURI().toString().length() + 1);
        if (HMobileProject.isFilterFolder((String)fpath)) {
            return false;
        }
        if (fpath.equals(file.getProjectRelativePath().toString())) {
            return true;
        }
        return this.cssRefrenceList.contains(filepath);
    }

    private List<String> getCSSFileRefrences(IFile file) {
        Map<String, Set<String>> map = this.indexQueryHelper.getCSSReferences(this.index);
        if (CollectionsUtil.isEmpty(map)) {
            return Collections.emptyList();
        }
        Set<Map.Entry<String, Set<String>>> resourceEntrySet = map.entrySet();
        String fPath = file.getProjectRelativePath().toString();
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, Set<String>> entry : resourceEntrySet) {
            Set<String> set = entry.getValue();
            if (!set.contains(fPath)) continue;
            list.add(entry.getKey());
        }
        return list;
    }

    private IDocument getDocumentByIFile(IFile iFile) {
        try {
            InputStream inputStream = iFile.getContents();
            String content = IOUtil.read((InputStream)inputStream);
            Document document = new Document(content);
            CompositePartitionScanner partitionScanner = new CompositePartitionScanner(HTMLSourceConfiguration.getDefault().createSubPartitionScanner(), (ISubPartitionScanner)new NullSubPartitionScanner(), (IPartitionerSwitchStrategy)new NullPartitionerSwitchStrategy());
            ExtendedFastPartitioner partitioner = new ExtendedFastPartitioner((IPartitionTokenScanner)partitionScanner, HTMLSourceConfiguration.getDefault().getContentTypes());
            partitionScanner.setPartitioner((IExtendedPartitioner)partitioner);
            partitioner.connect((IDocument)document);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
            CommonEditorPlugin.getDefault().getDocumentScopeManager().registerConfiguration((IDocument)document, (IPartitioningConfiguration)HTMLSourceConfiguration.getDefault());
            return document;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    private IFile getIFile(AbstractThemeableEditor editor) {
        IFile file = null;
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            file = ((IFileEditorInput)input).getFile();
        }
        return file;
    }
}

