/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.inspect;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.html.HTMLEditor;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.parsing.HTMLParseRootNode;
import com.aptana.editor.html.parsing.ast.HTMLElementNode;
import com.aptana.editor.html.parsing.ast.HTMLNode;
import com.aptana.editor.html.parsing.ast.HTMLSpecialNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.ui.util.UIUtils;
import com.pandora.cef3.inspect.InspectNodeStructure;
import com.pandora.cef3.inspect.InspectNodeStructureListener;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.IEditorPart;

public class InspectNodeStructureToEditorListenerImpl
implements InspectNodeStructureListener {
    public void notify(InspectNodeStructure nodeStructure) {
        try {
            IParseRootNode root;
            if (nodeStructure != null && nodeStructure.getSize() > 0 && (root = this.getRootNode()) instanceof HTMLParseRootNode) {
                List nodeNames = nodeStructure.getNodeNames();
                List nodeNums = nodeStructure.getNodeNums();
                int relativeOffset = root.getStartingOffset();
                IParseNode result = this.search(0, (IParseNode)root, nodeNames, nodeNums);
                if (result != null) {
                    final int offset = relativeOffset + (result == root ? 0 : result.getStartingOffset());
                    final int length = result.getLength();
                    try {
                        UIUtils.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                IEditorPart editor = UIUtils.getActiveEditor();
                                if (editor instanceof HTMLEditor) {
                                    ((HTMLEditor)editor).setForceHighlightSelectNode(true);
                                    ((HTMLEditor)editor).selectAndReveal(offset, length);
                                }
                            }
                        });
                    }
                    catch (Throwable e) {
                        IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
                    }
                }
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
        }
    }

    private IParseNode search(int num, IParseNode node, List<String> nodeNames, List<Integer> nodeNums) {
        if (nodeNames.size() == 1) {
            return node;
        }
        if (num < nodeNames.size() && node != null) {
            IParseNode[] children = node.getChildren();
            if (children == null || children.length <= 0) {
                return null;
            }
            int sameNodeNum = 0;
            int i = 0;
            while (i < children.length) {
                IParseNode child = children[i];
                if (child instanceof HTMLElementNode && !(child instanceof HTMLSpecialNode)) {
                    String name = ((HTMLElementNode)child).getName();
                    String nodeName = nodeNames.get(num);
                    if (nodeName != null && nodeName.equalsIgnoreCase(name)) {
                        if (sameNodeNum == nodeNums.get(num)) {
                            if (num == nodeNames.size() - 1) {
                                return child;
                            }
                            return this.search(++num, child, nodeNames, nodeNums);
                        }
                        ++sameNodeNum;
                    }
                }
                ++i;
            }
            if (num == 0 || num == 1) {
                if (num == 1 && nodeNames.size() == 2) {
                    boolean startToFindStartNode = false;
                    IParseNode startNode = null;
                    IParseNode endNode = null;
                    int i2 = 0;
                    while (i2 < children.length) {
                        IParseNode child = children[i2];
                        if (child instanceof HTMLElementNode && !(child instanceof HTMLSpecialNode)) {
                            if (startToFindStartNode) {
                                if (startNode == null) {
                                    startNode = child;
                                }
                                endNode = child;
                            } else {
                                String name = ((HTMLElementNode)child).getName();
                                if ("head".equalsIgnoreCase(name)) {
                                    startToFindStartNode = true;
                                }
                            }
                        }
                        ++i2;
                    }
                    if (startNode != null && endNode != null) {
                        return new HTMLNode(2, startNode.getStartingOffset(), endNode.getEndingOffset());
                    }
                }
                return this.search(++num, node, nodeNames, nodeNums);
            }
        }
        return null;
    }

    private IParseRootNode getRootNode() {
        final IParseRootNode[] parseRootNode = new IParseRootNode[1];
        try {
            UIUtils.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    IEditorPart editor = UIUtils.getActiveEditor();
                    if (editor instanceof HTMLEditor) {
                        parseRootNode[0] = ((HTMLEditor)editor).getAST();
                    }
                }
            });
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
        }
        return parseRootNode[0];
    }
}

