/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.ExtendedFastPartitioner;
import com.aptana.editor.common.IExtendedPartitioner;
import com.aptana.editor.common.IPartitionerSwitchStrategy;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.NullPartitionerSwitchStrategy;
import com.aptana.editor.common.contentassist.ILexemeProvider;
import com.aptana.editor.common.text.rules.CompositePartitionScanner;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.NullSubPartitionScanner;
import com.aptana.editor.html.HTMLSourceConfiguration;
import com.aptana.editor.html.contentassist.HTMLContentAssistProcessor;
import com.aptana.editor.html.parsing.lexer.HTMLTokenType;
import com.aptana.parsing.lexer.IRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public class ScriptHTMLContentAssistProcessor
extends HTMLContentAssistProcessor {
    private IRange activeRange = null;

    public ScriptHTMLContentAssistProcessor() {
        super(null);
    }

    public ScriptHTMLContentAssistProcessor(AbstractThemeableEditor editor) {
        super(editor);
    }

    public ScriptHTMLContentAssistProcessor(AbstractThemeableEditor editor, IRange activeRange) {
        this(editor);
        this.activeRange = activeRange;
    }

    @Override
    protected IRange getAttributeValueRange(ILexemeProvider<HTMLTokenType> lexemeProvider, int offset) {
        IRange range = super.getAttributeValueRange(lexemeProvider, offset);
        return range;
    }

    @Override
    protected IDocument getDocument(ITextViewer viewer) {
        IDocument currentDocument = viewer.getDocument();
        try {
            if (this.activeRange == null) {
                return currentDocument;
            }
            Document subDoc = new Document(currentDocument.get(this.activeRange.getStartingOffset(), this.activeRange.getLength()));
            CompositePartitionScanner partitionScanner = new CompositePartitionScanner(HTMLSourceConfiguration.getDefault().createSubPartitionScanner(), (ISubPartitionScanner)new NullSubPartitionScanner(), (IPartitionerSwitchStrategy)new NullPartitionerSwitchStrategy());
            ExtendedFastPartitioner partitioner = new ExtendedFastPartitioner((IPartitionTokenScanner)partitionScanner, HTMLSourceConfiguration.getDefault().getContentTypes());
            partitionScanner.setPartitioner((IExtendedPartitioner)partitioner);
            partitioner.connect((IDocument)subDoc);
            subDoc.setDocumentPartitioner((IDocumentPartitioner)partitioner);
            CommonEditorPlugin.getDefault().getDocumentScopeManager().registerConfiguration((IDocument)subDoc, (IPartitioningConfiguration)HTMLSourceConfiguration.getDefault());
            return subDoc;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return currentDocument;
        }
    }

    @Override
    public IRange getActiveRange() {
        return this.activeRange;
    }

    @Override
    public void setActiveRange(IRange activeRange) {
        this.activeRange = activeRange;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated, boolean inJs) {
        return this.computeCompletionProposals(viewer, offset, activationChar, autoActivated);
    }

    @Override
    public boolean isEnableEmmet(IDocument document, int offset) {
        return false;
    }
}

