/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext;

import com.aptana.editor.common.ProblemAnnotation;
import com.aptana.editor.common.quickassist.CommonQuickAssistProcessor;
import com.aptana.editor.html.ext.HTMLScriptRange;
import com.aptana.editor.html.ext.Messages;
import com.aptana.editor.html.ext.ScriptRange;
import com.aptana.editor.html.validator.HTMLScriptReferencesProblem;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickFixableAnnotation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class HTMLScriptQuickAssistProcessor
extends CommonQuickAssistProcessor {
    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext quickAssistContext) {
        int offset = quickAssistContext.getOffset();
        ISourceViewer viewer = quickAssistContext.getSourceViewer();
        Iterator it = viewer.getAnnotationModel().getAnnotationIterator();
        Annotation anno = null;
        Position pos = null;
        int distance = Integer.MIN_VALUE;
        int anOffset = offset;
        while (it.hasNext()) {
            Annotation an = (Annotation)it.next();
            if (!this.canFix(an)) continue;
            pos = viewer.getAnnotationModel().getPosition(an);
            if (pos.includes(offset)) {
                anOffset = pos.getOffset();
                anno = an;
                break;
            }
            int nowDistance = offset - pos.getOffset();
            if (!(distance == Integer.MIN_VALUE || distance < 0 && nowDistance > 0 || distance > 0 && nowDistance > 0 && nowDistance < distance) && (distance >= 0 || nowDistance >= 0 || nowDistance <= distance)) continue;
            distance = nowDistance;
            anOffset = pos.getOffset();
            anno = an;
        }
        if (anno == null) {
            return null;
        }
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        String[] missingScripts = null;
        if (anno instanceof IQuickFixableAnnotation) {
            Object missingScript;
            if (anno instanceof MarkerAnnotation) {
                try {
                    missingScript = (String)((MarkerAnnotation)anno).getMarker().getAttribute("MISSS_SCRIPTS");
                    if (missingScript != null) {
                        missingScripts = ((String)missingScript).split(":");
                    }
                }
                catch (CoreException coreException) {}
            } else if (anno instanceof ProblemAnnotation && ((ProblemAnnotation)anno).getProblem() instanceof HTMLScriptReferencesProblem && (missingScript = ((HTMLScriptReferencesProblem)((ProblemAnnotation)anno).getProblem()).getMissingScripts()) != null) {
                missingScripts = missingScript.toArray(new String[0]);
            }
        }
        if (missingScripts == null || missingScripts.length == 0) {
            return null;
        }
        IDocument doc = viewer.getDocument();
        String scriptTagTemplate = "<script type=\"text/javascript\" src=\"{0}\"></script>";
        int insertOffset = 0;
        int lineOffset = 0;
        int tabLength = 0;
        try {
            HTMLScriptRange htmlScriptActiveRange = new HTMLScriptRange();
            ScriptRange activeScriptRange = (ScriptRange)htmlScriptActiveRange.getActiveRange(doc, anOffset);
            if (activeScriptRange != null) {
                insertOffset = activeScriptRange.getStartingOffset() - activeScriptRange.getWholeTag().length();
                int line = doc.getLineOfOffset(insertOffset);
                lineOffset = doc.getLineOffset(line);
                tabLength = insertOffset - lineOffset;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        String[] stringArray = missingScripts;
        int n = missingScripts.length;
        int n2 = 0;
        while (n2 < n) {
            String missingScript = stringArray[n2];
            try {
                String insertReplaceString = missingScript;
                String scriptTag = MessageFormat.format(scriptTagTemplate, insertReplaceString);
                insertReplaceString = String.valueOf(scriptTag) + "\r\n" + doc.get(lineOffset, tabLength);
                proposals.add(new CompletionProposal(insertReplaceString, insertOffset, 0, insertReplaceString.length(), null, missingScript, null, Messages.HTMLScriptQuickAssistProcessor_ReferenceJs));
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        viewer.setSelectedRange(anOffset, 0);
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    public boolean canFix(Annotation annotation) {
        return super.canFix(annotation) || annotation.getType().equals("com.aptana.editor.html.js_ref.warning");
    }
}

