/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.contentassist.CompletionProposalType;
import com.aptana.editor.html.HTMLEditor;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.contentassist.model.AttributeElement;
import com.aptana.editor.html.contentassist.model.ValueElement;
import com.aptana.editor.html.ext.CommonSpecialListHandler;
import com.aptana.editor.html.ext.inferrer.HTMLElementClassInferrer;
import com.aptana.editor.html.ext.inferrer.HTMLElementIDInferrer;
import com.aptana.editor.html.parsing.HTMLParseRootNode;
import com.aptana.editor.js.JSSourceEditor;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.htmlext.DomProperties;
import com.aptana.editor.js.htmlext.IHTMLDomPropertiesAware;
import com.aptana.editor.js.htmlext.IJSActivationCharAware;
import com.aptana.editor.js.htmlext.IJSCurrentNodeAware;
import com.aptana.editor.js.parsing.ast.JSArgumentsNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.lexer.IRange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class HTMLPropertiesValueSpecialListHandler
extends CommonSpecialListHandler
implements IJSCurrentNodeAware,
IHTMLDomPropertiesAware,
IJSActivationCharAware {
    private JSNode currentNode = null;
    private DomProperties domProperties = null;
    private char activationChar;
    private boolean autoActivated;
    private CompletionProposalType completionProposalType = CompletionProposalType.DEFALUT;

    public CompletionProposalType getCompletionProposalType() {
        return this.completionProposalType;
    }

    public void setCompletionProposalType(CompletionProposalType completionProposalType) {
        this.completionProposalType = completionProposalType;
    }

    public void doComputeSpecialProposals(AbstractThemeableEditor editor, int offset, IRange replaceRange, Set<ICompletionProposal> result, boolean isHTML) {
        if (this.currentNode != null) {
            JSGetPropertyNode getNode = ParseUtil.getGetPropertyNode((IParseNode)this.currentNode, (IParseNode)this.currentNode.getContainingStatementNode());
            if (getNode == null) {
                getNode = ParseUtil.getGetPropertyNodeByVisitAst((IParseNode)this.currentNode, (IParseNode)this.currentNode.getContainingStatementNode());
            }
            if (getNode != null) {
                IParseNode rhs = getNode.getRightHandSide();
                if (getNode.getParent() instanceof JSInvokeNode) {
                    IParseNode child;
                    IParseNode arguNodes;
                    JSArgumentsNode arguNode;
                    String property;
                    JSInvokeNode ivkNode = (JSInvokeNode)getNode.getParent();
                    if (rhs != null && "getAttribute".equals(property = rhs.getText()) && (arguNode = (JSArgumentsNode)(arguNodes = ivkNode.getArguments())) != null && arguNode.hasChildren() && (child = arguNode.getChild(0)) instanceof JSStringNode) {
                        JSStringNode strNode = (JSStringNode)child;
                        this.addPropertiesValue(editor, replaceRange, result, strNode.getString(), isHTML);
                    }
                } else if (rhs != null) {
                    String property = rhs.getText();
                    this.addPropertiesValue(editor, replaceRange, result, property, isHTML);
                }
            }
        }
    }

    private void addPropertiesValue(AbstractThemeableEditor editor, IRange replaceRange, Set<ICompletionProposal> result, String property, boolean isHTML) {
        List<AttributeElement> attrs;
        if (this.autoActivated && !this.checkNeedReContentAssist(property, this.activationChar)) {
            return;
        }
        HashMap<String, String> values = new HashMap<String, String>();
        HTMLIndexQueryHelper queryHelper = new HTMLIndexQueryHelper();
        if (this.domProperties != null) {
            HashSet<String> tags = new HashSet<String>();
            this.processIds(editor, queryHelper, tags);
            this.processClasses(editor, queryHelper, tags);
            this.processTags(values, tags, property, queryHelper);
        }
        if (values.isEmpty() && !CollectionsUtil.isEmpty(attrs = queryHelper.getAttribute(property))) {
            for (AttributeElement attrElement : attrs) {
                if (attrElement == null) continue;
                List<ValueElement> valueRanges = attrElement.getValues();
                for (ValueElement value : valueRanges) {
                    String ownTag = StringUtil.isNotEmpty((String)attrElement.getElement()) ? String.valueOf(StringUtil.toBolder((String)("&lt;" + attrElement.getElement() + "&gt;"))) + "<br />" : "";
                    values.put(value.getName(), String.valueOf(ownTag) + value.getDescription());
                }
            }
        }
        this.addProposals(replaceRange, result, values, this.getCompletionProposalType(), 90, isHTML);
    }

    protected void processIds(AbstractThemeableEditor editor, HTMLIndexQueryHelper queryHelper, Set<String> tags) {
        ArrayList<HTMLParseRootNode> rootNodes = new ArrayList<HTMLParseRootNode>();
        if (!this.domProperties.getIds().isEmpty()) {
            if (editor instanceof HTMLEditor) {
                IParseRootNode iParseRootNode = editor.getAST();
                if (iParseRootNode instanceof HTMLParseRootNode) {
                    rootNodes.add((HTMLParseRootNode)iParseRootNode);
                }
            } else if (editor instanceof JSSourceEditor) {
                rootNodes.addAll(this.getHTMLRootNodesByReference(editor, queryHelper));
            }
            for (HTMLParseRootNode hTMLParseRootNode : rootNodes) {
                for (String id : this.domProperties.getIds()) {
                    HTMLElementIDInferrer inferrer = new HTMLElementIDInferrer(id);
                    inferrer.visit((IParseNode)hTMLParseRootNode);
                    tags.addAll(inferrer.getTags());
                }
            }
        }
    }

    protected void processClasses(AbstractThemeableEditor editor, HTMLIndexQueryHelper queryHelper, Set<String> tags) {
        ArrayList<HTMLParseRootNode> rootNodes = new ArrayList<HTMLParseRootNode>();
        if (!this.domProperties.getClasses().isEmpty()) {
            if (editor instanceof HTMLEditor) {
                IParseRootNode iParseRootNode = editor.getAST();
                if (iParseRootNode instanceof HTMLParseRootNode) {
                    rootNodes.add((HTMLParseRootNode)iParseRootNode);
                }
            } else if (editor instanceof JSSourceEditor) {
                rootNodes.addAll(this.getHTMLRootNodesByReference(editor, queryHelper));
            }
            for (HTMLParseRootNode hTMLParseRootNode : rootNodes) {
                for (String cls : this.domProperties.getClasses()) {
                    HTMLElementClassInferrer inferrer = new HTMLElementClassInferrer(cls);
                    inferrer.visit((IParseNode)hTMLParseRootNode);
                    tags.addAll(inferrer.getTags());
                }
            }
        }
    }

    protected void processTags(Map<String, String> values, Set<String> tags, String property, HTMLIndexQueryHelper queryHelper) {
        if (!this.domProperties.getTags().isEmpty()) {
            tags.addAll(this.domProperties.getTags());
        }
        for (String tag : tags) {
            AttributeElement attr = queryHelper.getAttribute(tag, property);
            if (attr == null) continue;
            if (CommonContentAssistProcessor.checkTypesContainsNumber(attr.getTypes())) {
                this.setCompletionProposalType(CompletionProposalType.NUMBER);
            } else {
                this.setCompletionProposalType(CompletionProposalType.DEFALUT);
            }
            List<ValueElement> vals = attr.getValues();
            for (ValueElement val : vals) {
                values.put(val.getName(), val.getDescription());
            }
        }
    }

    public void setCurrentNode(JSNode jsnode) {
        this.currentNode = jsnode;
    }

    public void setDomProperties(DomProperties domProperties) {
        this.domProperties = domProperties;
    }

    public void setActivationChar(char activationChar) {
        this.activationChar = activationChar;
    }

    public void setAutoActivated(boolean autoActivated) {
        this.autoActivated = autoActivated;
    }
}

