/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.contentassist.CommonCompletionProposal;
import com.aptana.editor.common.contentassist.CompletionProposalType;
import com.aptana.editor.common.contentassist.ContentAssistant;
import com.aptana.editor.common.contentassist.StringValueCompletionProposal;
import com.aptana.editor.common.extensions.ISpecialValueListLocationType;
import com.aptana.editor.common.extensions.SpecialValueLocationType;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.html.contentassist.HTMLAttributeValueProposal;
import com.aptana.editor.html.contentassist.HTMLContentAssistProcessor;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.contentassist.model.ValueElement;
import com.aptana.editor.html.ext.CommonSpecialListHandler;
import com.aptana.editor.html.ext.URLSpecialListHandler;
import com.aptana.editor.js.JSSourceEditor;
import com.aptana.parsing.lexer.IRange;
import com.pandora.core.utils.ProjectUtils;
import com.pandora.core.utils.URIUtils;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public class FileSpecialListHandler
extends CommonSpecialListHandler
implements ISpecialValueListLocationType {
    IFile iFile;
    IProject project;
    AbstractThemeableEditor editor;
    IRange repalceRange;
    IFileStore projectStore;
    String iFilePath;
    HTMLIndexQueryHelper _queryHelper;
    int offset;
    SpecialValueLocationType specialValueLocationType = SpecialValueLocationType.IN_HTML;
    private int count = 0;
    public static String UNPACKAGE_DIR = "unpackage/";

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void addCount() {
        ++this.count;
    }

    public void doComputeSpecialProposals(AbstractThemeableEditor editor, int offset, IRange repalceRange, Set<ICompletionProposal> result, boolean isHTML) {
        this._queryHelper = new HTMLIndexQueryHelper();
        this.editor = editor;
        this.repalceRange = repalceRange;
        this.offset = offset;
        this.init();
        if (this.project == null || this.iFile == null) {
            return;
        }
        try {
            this.addFileProposal(result, isHTML);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void addFileProposal(Set<ICompletionProposal> list, boolean isHTML) throws CoreException {
        try {
            this.setCount(0);
            CollectingResourceVisitor visitor = new CollectingResourceVisitor(list, isHTML);
            this.project.accept((IResourceVisitor)visitor);
        }
        catch (Exception exception) {
            URLSpecialListHandler handler = new URLSpecialListHandler();
            if (list != null && !list.isEmpty()) {
                list.clear();
            }
            if (this.specialValueLocationType == SpecialValueLocationType.IN_CSS || this.specialValueLocationType == SpecialValueLocationType.IN_JS_CSS) {
                handler.setNeedAddURL(true);
            }
            handler.doComputeSpecialProposals(this.editor, this.offset, this.repalceRange, list, isHTML);
        }
    }

    public void createFileSpecialProposal(Set<ICompletionProposal> list, File file, String fname, String extend, boolean isHTML) {
        CommonCompletionProposal proposal = this.createFileProposal(file, fname, isHTML);
        proposal.setCompletionProposalType(CompletionProposalType.FILE);
        proposal.setImage(HTMLContentAssistProcessor.TEXT_ICON);
        list.add((ICompletionProposal)proposal);
    }

    public boolean checkFileExtend(String fname) {
        return true;
    }

    public CommonCompletionProposal createFileProposal(File file, String fname, boolean isHTML) {
        HTMLAttributeValueProposal proposal = null;
        switch (this.specialValueLocationType) {
            case IN_HTML: {
                ValueElement value = this.createValueElement(fname);
                proposal = new HTMLAttributeValueProposal(value, this.repalceRange, null);
                proposal.setFileInfo(file, true);
                break;
            }
            case IN_JS_CSS: {
                fname = this.computeInJSFileName(file, fname);
                fname = "url(" + fname + ")";
                proposal = new StringValueCompletionProposal(fname, this.repalceRange, ATTRIBUTE_ICON, "");
                break;
            }
            case IN_JS_HTML: {
                fname = this.computeInJSFileName(file, fname);
                proposal = new StringValueCompletionProposal(fname, this.repalceRange, ATTRIBUTE_ICON, "");
                break;
            }
            case IN_CSS: {
                fname = "url(" + fname + ")";
                proposal = new CommonCompletionProposal(fname, this.repalceRange.getStartingOffset(), this.repalceRange.getLength(), fname.length(), null, fname, null, "");
                break;
            }
        }
        if (proposal != null) {
            proposal.setIsHTML(isHTML);
        }
        return proposal;
    }

    protected String computeInJSFileName(File file, String fname) {
        String fileLocation;
        Map<String, Set<String>> results;
        if (this._queryHelper == null) {
            this._queryHelper = new HTMLIndexQueryHelper();
        }
        if ((results = this._queryHelper.getJSReferences(EditorUtil.getIndex((AbstractThemeableEditor)this.editor))) == null) {
            results = Collections.emptyMap();
        }
        if ((fileLocation = this.iFile.getLocationURI().toString()).endsWith(".js")) {
            Set<String> htmlFiles = results.get(fileLocation);
            if (htmlFiles != null && htmlFiles.size() == 1) {
                fname = URIUtils.relativeURI((String)ProjectUtils.getSourceRoot((IProject)this.project).append(htmlFiles.iterator().next()).makeAbsolute().toString(), (String)file.getPath().replace("\\", "/"));
            } else {
                fname = URIUtils.relativeURI((String)ProjectUtils.getSourceRoot((IProject)this.project).makeAbsolute().toString(), (String)file.getPath().replace("\\", "/"));
                if (!fname.startsWith("/")) {
                    fname = "/" + fname;
                }
            }
        }
        return fname;
    }

    public ValueElement createValueElement(String name) {
        ValueElement value = new ValueElement();
        value.setName(name);
        return value;
    }

    public String getExtention(String fileName) {
        if (StringUtil.isNotBlank((String)fileName) && fileName.lastIndexOf(".") > -1) {
            int index = fileName.lastIndexOf(".") + 1;
            return fileName.substring(index);
        }
        return "";
    }

    public void init() {
        if (this.editor != null) {
            IEditorInput editorInput = this.editor.getEditorInput();
            if (editorInput instanceof IFileEditorInput) {
                IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
                this.iFile = fileEditorInput.getFile();
                this.project = this.iFile.getProject();
                try {
                    IFileStore ifileStore = EFS.getStore((URI)this.iFile.getLocationURI());
                    this.iFilePath = ifileStore.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor()).getPath();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            if (this.editor instanceof JSSourceEditor && this.specialValueLocationType == SpecialValueLocationType.IN_CSS) {
                this.setLocationType(SpecialValueLocationType.IN_JS_CSS);
            }
        }
    }

    public void setLocationType(SpecialValueLocationType specialValueLocationType) {
        this.specialValueLocationType = specialValueLocationType;
    }

    private class CollectingResourceVisitor
    implements IResourceVisitor {
        Set<ICompletionProposal> result;
        boolean isHTML;

        private CollectingResourceVisitor(Set<ICompletionProposal> list, boolean isHTML) {
            this.result = list;
            this.isHTML = isHTML;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (1 == resource.getType()) {
                IFile iFile = (IFile)resource;
                String relativePath = iFile.getProjectRelativePath().toString();
                if (relativePath.startsWith(UNPACKAGE_DIR)) {
                    return false;
                }
                String fname = iFile.getName();
                String extend = FileSpecialListHandler.this.getExtention(fname);
                if (!FileSpecialListHandler.this.checkFileExtend(extend)) {
                    return false;
                }
                if (FileSpecialListHandler.this.getCount() > ContentAssistant.getSPEC_FILE_MAX_COUNT()) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
                IFileStore fileStore = EFS.getStore((URI)iFile.getLocationURI());
                File file = fileStore.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor());
                if (fname.charAt(0) == '.' || StringUtil.contains((String[])HTMLContentAssistProcessor.HTML_EXCLUDE_PROJECT_FILE, (String)fname)) {
                    return false;
                }
                FileSpecialListHandler.this.iFilePath = FileSpecialListHandler.this.iFilePath.replace("\\", "/");
                String path = file.getPath();
                fname = URIUtils.relativeURI((String)FileSpecialListHandler.this.iFilePath, (String)(path = path.replace("\\", "/")));
                if (StringUtil.isBlank((String)fname)) {
                    return false;
                }
                FileSpecialListHandler.this.createFileSpecialProposal(this.result, file, fname, extend, this.isHTML);
                return false;
            }
            return 2 != resource.getType() || !"unpackage".equals(resource.getName());
        }
    }
}

