/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.contentassist.index;

import com.aptana.build.util.BuildHelper;
import com.aptana.buildpath.core.BuildPathCorePlugin;
import com.aptana.buildpath.core.BuildPathEntry;
import com.aptana.buildpath.core.BuildPathManager;
import com.aptana.core.IFilter;
import com.aptana.core.build.BuildFileManager;
import com.aptana.core.build.SDocMLFileIndexingFilter;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.resolver.URIResolver;
import com.aptana.editor.css.contentassist.index.CSSFileIndexingParticipant;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.parsing.HTMLParseState;
import com.aptana.editor.html.parsing.ast.HTMLElementNode;
import com.aptana.editor.html.parsing.ast.HTMLSpecialNode;
import com.aptana.editor.js.contentassist.index.JSFileIndexingParticipant;
import com.aptana.editor.js.contentassist.index.SDocMLFileIndexingParticipant;
import com.aptana.index.core.AbstractFileIndexingParticipant;
import com.aptana.index.core.BuildContextType;
import com.aptana.index.core.FileStoreBuildContext;
import com.aptana.index.core.IFileStoreIndexingContextType;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.build.BuildContext;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.util.ParseUtil;
import com.pandora.core.stats.Stats;
import com.pandora.core.utils.ProjectUtils;
import com.pandora.core.utils.RegularUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;

public class HTMLFileIndexingParticipant
extends AbstractFileIndexingParticipant
implements IFileStoreIndexingContextType {
    private static final String ELEMENT_LINK = "link";
    private static final String ELEMENT_SCRIPT = "script";
    private static final String ATTRIBUTE_HREF = "href";
    private static final String ATTRIBUTE_SRC = "src";
    private JSFileIndexingParticipant jsIndex;
    private SDocMLFileIndexingParticipant sdocmlIndex;
    private BuildContextType buildContextType = BuildContextType.ALL;

    public void index(BuildContext context, Index index, IProgressMonitor monitor) throws CoreException {
        IParseRootNode ast;
        SubMonitor sub;
        block11: {
            sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            sub.subTask(this.getIndexingMessage(index, context.getURI()));
            this.jsIndex = null;
            ast = null;
            HTMLParseState parseState = null;
            try {
                try {
                    parseState = new HTMLParseState(context.getContents());
                    if (context.isNeedSleep()) {
                        parseState.setNeedSleep(true);
                    }
                    ast = ParserPoolFactory.parse((String)"com.aptana.contenttype.html", (IParseState)parseState).getRootNode();
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
                    Stats.addExceptionInfo((Throwable)e);
                    if (parseState != null) {
                        parseState.clearEditState();
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                if (parseState != null) {
                    parseState.clearEditState();
                }
                throw throwable;
            }
            if (parseState != null) {
                parseState.clearEditState();
            }
        }
        if (ast != null) {
            this.walkAST(context, index, (IParseNode)ast, monitor);
        }
        if (this.jsIndex != null) {
            this.jsIndex.flushJSIndexCacher(index, context.getURI(), context.isNeedSleep());
        }
        sub.done();
    }

    private void processHTMLElementNode(Index index, URI uri, HTMLElementNode element) {
        URIResolver resolver;
        URI resolved;
        String cssLink;
        String id;
        String reg;
        String cssClass = element.getCSSClass();
        if (!StringUtil.isEmpty((String)cssClass) && RegularUtils.isMatch((String)(reg = "^[\\w-\\s\u4e00-\u9fa5]+$"), (String)cssClass)) {
            StringTokenizer tokenizer = new StringTokenizer(cssClass);
            while (tokenizer.hasMoreTokens()) {
                this.addIndex(index, uri, "css.class", tokenizer.nextToken());
            }
        }
        if (!StringUtil.isEmpty((String)(id = element.getID()))) {
            this.addIndex(index, uri, "css.identifier", id);
        }
        if (element.getName().equalsIgnoreCase(ELEMENT_LINK) && !StringUtil.isEmpty((String)(cssLink = element.getAttributeValue(ATTRIBUTE_HREF))) && (resolved = (resolver = new URIResolver(uri)).resolveURI(cssLink)) != null) {
            this.addIndex(index, uri, "html.resource.css", resolved.toString());
            BuildFileManager.getInstance().addJSReferencesHighPriorityIFile(resolved);
        }
    }

    private void processHTMLSpecialNode(Index index, BuildContext context, HTMLSpecialNode htmlSpecialNode) {
        String language;
        IParseNode child = htmlSpecialNode.getChild(0);
        if (child != null && "com.aptana.contenttype.css".equals(language = child.getLanguage()) && (BuildContextType.CSS == this.buildContextType || BuildContextType.ALL == this.buildContextType)) {
            CSSFileIndexingParticipant cssIndex = this.createCSSIndexer();
            int[] counts = new int[]{0};
            cssIndex.walkNode(index, context.getURI(), child, context.isNeedSleep(), counts);
        }
        if (htmlSpecialNode.getName().equalsIgnoreCase(ELEMENT_SCRIPT)) {
            String jsSource = htmlSpecialNode.getAttributeValue(ATTRIBUTE_SRC);
            URI uri = null;
            if (StringUtil.isNotEmpty((String)jsSource) && !jsSource.trim().startsWith("<") && !jsSource.trim().startsWith("{") && context.getProject() != null) {
                try {
                    URIResolver resolver = null;
                    IProject project = context.getProject();
                    if (project == null) {
                        return;
                    }
                    IPath path = ProjectUtils.getSourceRoot((IProject)project);
                    if (path == null) {
                        return;
                    }
                    File file = path.toFile();
                    if (file == null) {
                        return;
                    }
                    URI appsource = file.toURI();
                    if (jsSource.startsWith("//")) {
                        jsSource = "http:" + jsSource;
                    }
                    URI resolved = null;
                    URI jsSourceUri = new URI(jsSource);
                    if (jsSourceUri.getScheme() == null) {
                        if (jsSource.startsWith("/")) {
                            try {
                                uri = new URI(String.valueOf(appsource.toString()) + "/config.xml");
                                resolver = new URIResolver(uri);
                            }
                            catch (URISyntaxException e) {
                                e.printStackTrace();
                            }
                            jsSource = jsSource.substring(1, jsSource.length());
                        } else {
                            uri = context.getURI();
                            resolver = new URIResolver(context.getURI());
                        }
                        resolved = resolver.resolveURI(jsSource);
                    } else {
                        this.autoCheckAndBuildSDOCML(jsSource, project);
                    }
                    if (resolved != null) {
                        this.addIndex(index, context.getURI(), "html.resource.js", resolved.toString());
                        BuildFileManager.getInstance().addJSReferencesHighPriorityIFile(resolved);
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
                }
            } else if (child != null && "com.aptana.contenttype.js".equals(child.getLanguage()) && (BuildContextType.JS == this.buildContextType || BuildContextType.ALL == this.buildContextType)) {
                this.jsIndex = this.createJSIndexer(index, context.getURI());
                this.jsIndex.processParseResults(context, index, child, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    private void autoCheckAndBuildSDOCML(String jsSource, IProject project) throws CoreException {
        if (StringUtil.isBlank((String)jsSource) || project == null) {
            return;
        }
        int sIndex = jsSource.lastIndexOf("/");
        String fname = "";
        String tmpVersion = "";
        if (sIndex > -1) {
            fname = jsSource.substring(sIndex + 1);
            tmpVersion = jsSource.substring(0, sIndex);
            if ((sIndex = tmpVersion.lastIndexOf("/")) > -1) {
                tmpVersion = tmpVersion.substring(sIndex + 1);
            }
        }
        if (StringUtil.isBlank((String)fname)) {
            return;
        }
        String disPlayName = "";
        BuildPathManager buildPathManager = BuildPathManager.getInstance();
        String reg = "\\d+\\.?(\\d*\\.?)\\d*";
        String jqKey = "jquery";
        String tmpKey = "";
        if (SDocMLFileIndexingFilter.buildPathEntrys == null || SDocMLFileIndexingFilter.buildPathEntrys.isEmpty()) {
            SDocMLFileIndexingFilter.init();
        }
        Set keySet = SDocMLFileIndexingFilter.displayNames.keySet();
        for (String[] nv : keySet) {
            String key = nv[0];
            if (!fname.contains(key = key.toLowerCase())) continue;
            tmpKey = key;
            boolean isJQKey = jqKey.equals(key);
            if (!isJQKey) {
                if (!SDocMLFileIndexingFilter.checkIsZeptoJS((String)fname) && !SDocMLFileIndexingFilter.checkIsMuiJS((String)fname) && !SDocMLFileIndexingFilter.checkIsWXJS((String)fname)) break;
                disPlayName = (String)SDocMLFileIndexingFilter.displayNames.get(nv);
                break;
            }
            if (!SDocMLFileIndexingFilter.checkIsJQ((String)fname)) break;
            disPlayName = "jquery 2.0";
            Object v = RegularUtils.match((String)reg, (String)fname, (int)0);
            if (StringUtil.isBlank((String)v) && StringUtil.isBlank((String)(v = RegularUtils.match((String)reg, (String)tmpVersion, (int)0)))) break;
            String[] vs = ((String)v).split("\\.");
            String lv = vs[0];
            if (nv[1].startsWith(lv)) {
                disPlayName = (String)SDocMLFileIndexingFilter.displayNames.get(nv);
                break;
            }
            boolean isexist = false;
            for (String[] nvs : keySet) {
                if (!nvs[0].equals(key) || !nvs[1].startsWith(lv)) continue;
                disPlayName = (String)SDocMLFileIndexingFilter.displayNames.get(nvs);
                isexist = true;
                break;
            }
            if (isexist) break;
        }
        if (StringUtil.isNotBlank((String)disPlayName)) {
            BuildPathEntry buildPathEntry = (BuildPathEntry)SDocMLFileIndexingFilter.buildPathEntryMap.get(disPlayName);
            Set buildPathEntrySet = buildPathManager.getBuildPaths(project);
            if (!buildPathEntrySet.contains(buildPathEntry)) {
                boolean isAdded = false;
                if (StringUtil.isNotBlank((String)tmpKey)) {
                    for (BuildPathEntry bpe : buildPathEntrySet) {
                        if (!bpe.getDisplayName().toLowerCase().contains(tmpKey)) continue;
                        isAdded = true;
                        break;
                    }
                }
                if (!isAdded) {
                    this.buildSDOCmlFile(buildPathEntry, project);
                    buildPathEntrySet.add(buildPathEntry);
                    Object[] bea = new BuildPathEntry[buildPathEntrySet.size()];
                    ArrayList list = new ArrayList();
                    buildPathEntrySet.toArray(bea);
                    CollectionsUtil.addToList(list, (Object[])bea);
                    buildPathManager.setBuildPaths(project, list);
                }
            }
        }
    }

    private void buildSDOCmlFile(BuildPathEntry buildPathEntry, IProject project) throws CoreException {
        if (buildPathEntry == null || project == null) {
            return;
        }
        if (this.sdocmlIndex == null) {
            this.sdocmlIndex = new SDocMLFileIndexingParticipant();
        }
        Index index = IndexPlugin.getDefault().getIndexManager().getIndex(this.getURI(project));
        IFileStore fileStore = EFS.getStore((URI)buildPathEntry.getPath());
        FileStoreBuildContext context = new FileStoreBuildContext(project, fileStore);
        this.sdocmlIndex.index((BuildContext)context, index, (IProgressMonitor)new NullProgressMonitor());
    }

    protected URI getURI(IProject project) {
        if (project == null) {
            return null;
        }
        URI uri = project.getLocationURI();
        if (uri != null) {
            return uri;
        }
        IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (String)MessageFormat.format("Project's location URI is null. raw location: {0}, path: {1}", project.getRawLocationURI(), project.getFullPath()));
        return project.getRawLocationURI();
    }

    protected JSFileIndexingParticipant createJSIndexer(Index index, URI location) {
        if (this.jsIndex == null) {
            this.jsIndex = new JSFileIndexingParticipant();
            this.jsIndex.removeIndex(index, location.toString());
        }
        this.jsIndex.setNeedReflush(false);
        return this.jsIndex;
    }

    protected CSSFileIndexingParticipant createCSSIndexer() {
        return new CSSFileIndexingParticipant();
    }

    protected void processNode(Index index, BuildContext context, URI uri, IParseNode current, int[] counts) {
        if (current instanceof HTMLSpecialNode) {
            if (context.isNeedSleep()) {
                BuildHelper.sleep((String)"HTML_INDEX_TYPE");
            }
            this.processHTMLSpecialNode(index, context, (HTMLSpecialNode)current);
        }
        if (current instanceof HTMLElementNode && BuildContextType.ALL == this.buildContextType) {
            this.processHTMLElementNode(index, uri, (HTMLElementNode)current);
        }
    }

    public void walkAST(final BuildContext context, final Index index, IParseNode parent, IProgressMonitor monitor) {
        if (context == null || index == null || parent == null) {
            return;
        }
        final URI uri = context.getURI();
        final int[] counts = new int[]{0};
        ParseUtil.treeApply((IParseNode)parent, (IFilter)new IFilter<IParseNode>(){

            public boolean include(IParseNode item) {
                HTMLFileIndexingParticipant.this.processNode(index, context, uri, item, counts);
                return true;
            }
        }, (boolean)context.isNeedSleep());
    }

    public void setBuildContextType(BuildContextType contextType) {
        this.buildContextType = contextType;
    }

    public BuildContextType getBuildContextType() {
        return this.buildContextType;
    }

    public boolean isEnableType(BuildContextType contextType) {
        return true;
    }
}

