/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.contentassist;

import com.aptana.core.IFilter;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.html.parsing.ast.HTMLSpecialNode;
import com.aptana.editor.js.JSSourceEditor;
import com.aptana.editor.js.inferencing.JSPropertyCollection;
import com.aptana.editor.js.parsing.ast.JSAssignmentNode;
import com.aptana.editor.js.parsing.ast.JSDeclarationNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSNameValuePairNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.util.ParseUtil;
import com.pandora.core.index.QuickSearchIndexResult;
import com.pandora.core.utils.RegularUtils;
import java.util.List;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class IndexQuickSearchIndexResult
extends QuickSearchIndexResult {
    public ITextSelection getSelection(IEditorPart editorPart) {
        block21: {
            try {
                AbstractTextEditor editor = null;
                if (editorPart instanceof AbstractTextEditor) {
                    editor = (AbstractTextEditor)editorPart;
                }
                if (editor == null) {
                    return super.getSelection(editorPart);
                }
                if (this.getFileType() == QuickSearchIndexResult.FileType.CSS_FILE) {
                    return super.getSelection(editorPart);
                }
                if (this.getFileType() == QuickSearchIndexResult.FileType.HTML_FILE) {
                    if (this.getType() == QuickSearchIndexResult.ResultType.CLASS) {
                        IDocumentProvider documentProvider = editor.getDocumentProvider();
                        IDocument document = null;
                        if (documentProvider != null) {
                            document = documentProvider.getDocument((Object)editor.getEditorInput());
                        }
                        if (document == null) {
                            return super.getSelection(editorPart);
                        }
                        FindReplaceDocumentAdapter findReplaceDocumentAdapter = new FindReplaceDocumentAdapter(document);
                        String findString = "\\." + this.getName();
                        IRegion region = findReplaceDocumentAdapter.find(0, findString, true, false, false, true);
                        if (region == null) {
                            findString = "class[\\s]*=[\\s]*[\"']" + this.getName() + "[\"']";
                            region = RegularUtils.matchFirst((String)findString, (String)document.get(), (int)0);
                        }
                        if (region != null) {
                            return new TextSelection(region.getOffset(), region.getLength());
                        }
                        break block21;
                    }
                    if (this.getType() == QuickSearchIndexResult.ResultType.ID) {
                        IDocumentProvider documentProvider = editor.getDocumentProvider();
                        IDocument document = null;
                        if (documentProvider != null) {
                            document = documentProvider.getDocument((Object)editor.getEditorInput());
                        }
                        if (document == null) {
                            return super.getSelection(editorPart);
                        }
                        String findString = "id[\\s]*=[\\s]*[\"']" + this.getName() + "[\"']";
                        IRegion region = RegularUtils.matchFirst((String)findString, (String)document.get(), (int)0);
                        if (region == null) {
                            findString = "#" + this.getName();
                            FindReplaceDocumentAdapter findReplaceDocumentAdapter = new FindReplaceDocumentAdapter(document);
                            region = findReplaceDocumentAdapter.find(0, findString, true, false, false, true);
                        }
                        if (region != null) {
                            return new TextSelection(region.getOffset(), region.getLength());
                        }
                        break block21;
                    }
                    AbstractThemeableEditor ateditor = null;
                    if (editor instanceof AbstractThemeableEditor) {
                        ateditor = (AbstractThemeableEditor)editor;
                    }
                    final ITextSelection[] selection = new ITextSelection[1];
                    try {
                        ParseUtil.treeApply((IParseNode)ateditor.getAST(), (IFilter)new IFilter<IParseNode>(){

                            public boolean include(IParseNode item) {
                                HTMLSpecialNode spNode;
                                String name;
                                if (item != null && item instanceof HTMLSpecialNode && "script".equals(name = (spNode = (HTMLSpecialNode)item).getName())) {
                                    IParseNode child = spNode.getChild(0);
                                    if (child instanceof JSParseRootNode) {
                                        selection[0] = IndexQuickSearchIndexResult.this.processJsNode((JSParseRootNode)child);
                                        if (selection[0] != null) {
                                            throw new RuntimeException();
                                        }
                                    }
                                    return false;
                                }
                                return true;
                            }
                        }, (boolean)false);
                    }
                    catch (RuntimeException runtimeException) {}
                    return selection[0];
                }
                if (this.getFileType() == QuickSearchIndexResult.FileType.JS_FILE) {
                    JSSourceEditor ateditor = null;
                    if (editor instanceof JSSourceEditor) {
                        ateditor = (JSSourceEditor)editor;
                    }
                    JSParseRootNode root = (JSParseRootNode)ateditor.getAST();
                    return this.processJsNode(root);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return super.getSelection(editorPart);
    }

    public ITextSelection processJsNode(JSParseRootNode root) {
        IParseNode functionNode;
        JSPropertyCollection jsPropertyCollection = root.getGlobals().getSymbol(this.getName());
        if (jsPropertyCollection == null) {
            return null;
        }
        List listNode = jsPropertyCollection.getValues();
        if (listNode == null || listNode.isEmpty()) {
            return null;
        }
        JSNode jsNode = (JSNode)listNode.get(0);
        if (jsNode == null) {
            return null;
        }
        TextSelection selection = null;
        if (jsNode instanceof JSFunctionNode && (selection = this.getJsSelection(functionNode = ((JSFunctionNode)jsNode).getName())) != null) {
            return selection;
        }
        jsNode = (JSNode)jsNode.getParent();
        switch (jsNode.getNodeType()) {
            case 63: {
                JSDeclarationNode dNode = (JSDeclarationNode)jsNode;
                IParseNode pNode = dNode.getIdentifier();
                selection = this.getJsSelection(pNode);
                if (selection == null) break;
                return selection;
            }
            case 1: {
                JSAssignmentNode aNode = (JSAssignmentNode)jsNode;
                IParseNode lNode = aNode.getLeftHandSide();
                selection = this.getJsSelection(lNode);
                if (selection == null) break;
                return selection;
            }
            case 76: {
                JSNameValuePairNode nvNode = (JSNameValuePairNode)jsNode;
                IParseNode nNode = nvNode.getName();
                selection = this.getJsSelection(nNode);
                if (selection == null) break;
                return selection;
            }
        }
        return null;
    }

    public TextSelection getJsSelection(IParseNode functionNode) {
        if (functionNode != null) {
            int start = functionNode.getStartingOffset();
            int end = functionNode.getEndingOffset();
            return new TextSelection(start, end - start + 1);
        }
        return null;
    }
}

