/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.contentassist;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.contentassist.CommonCompletionProposal;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.HTMLTagScanner;
import com.aptana.editor.html.contentassist.model.ValueElement;
import com.aptana.editor.html.parsing.lexer.HTMLLexemeProvider;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Lexeme;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.swt.graphics.Image;

public class HTMLAttributeValueProposal
extends CommonCompletionProposal {
    boolean isAutoReplace = true;
    private static final Image ATTRIBUTE_ICON = HTMLPlugin.getImage("/icons/assistant/attribute.png");

    public void setAutoReplace(boolean isAutoReplace) {
        this.isAutoReplace = isAutoReplace;
    }

    public HTMLAttributeValueProposal(ValueElement value, IRange range, Map<String, String> userAgents) {
        super(value.getName(), range.getStartingOffset(), range.getLength(), value.getName().length(), ATTRIBUTE_ICON, value.getDisplayName() == null ? value.getName() : value.getDisplayName(), null, value.getDescription());
        this.setFileLocation("");
        this.setUserAgentImages(userAgents);
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        try {
            IDocument document = viewer.getDocument();
            ITypedRegion iTypedRegion = document.getPartition(this._replacementOffset);
            char prevChar = document.getChar(this._replacementOffset - 1);
            char quote = '\"';
            switch (prevChar) {
                case '\'': {
                    quote = '\'';
                    break;
                }
                case ' ': 
                case '\"': 
                case '/': {
                    break;
                }
                case '=': {
                    this._replacementString = "\"" + this._replacementString;
                    ++this._cursorPosition;
                    break;
                }
                default: {
                    if (iTypedRegion.getType().equals("__html_doctype") || this._replacementString.startsWith("&") || this._replacementString.startsWith("#")) break;
                    this._replacementString = "\"" + this._replacementString;
                    ++this._cursorPosition;
                }
            }
            int nextCharIndex = this._replacementOffset + this._replacementLength;
            if (nextCharIndex >= document.getLength()) {
                this._replacementString = String.valueOf(this._replacementString) + quote;
            } else {
                char nextChar = document.getChar(nextCharIndex);
                String replacementChar = document.get(this._replacementOffset + 1, this._replacementLength).trim();
                switch (nextChar) {
                    case '\'': {
                        if (replacementChar.endsWith("=")) {
                            this._replacementString = String.valueOf(this._replacementString) + quote;
                            this._replacementLength = 0;
                        }
                        if (!StringUtil.isBlank((String)replacementChar)) break;
                        this._replacementLength = 0;
                        break;
                    }
                    case '\"': {
                        if (replacementChar.endsWith("=")) {
                            this._replacementString = String.valueOf(this._replacementString) + quote;
                            this._replacementLength = 0;
                        }
                        if (!StringUtil.isBlank((String)replacementChar)) break;
                        this._replacementLength = 0;
                        break;
                    }
                    case '\t': 
                    case ' ': 
                    case '/': 
                    case '>': {
                        boolean needAddQuote = this.checkNeedAddQuote(document);
                        if (iTypedRegion.getType().equals("__html_doctype") || !needAddQuote) break;
                        this._replacementString = String.valueOf(this._replacementString) + quote;
                        break;
                    }
                    default: {
                        boolean needAdd = this.checkNeedAddQuote(document);
                        if (this._replacementString.startsWith("&") || this._replacementString.startsWith("#") || !needAdd) break;
                        this._replacementString = String.valueOf(this._replacementString) + quote + " ";
                    }
                }
            }
            String replaceString = document.get(this._replacementOffset, this._replacementLength).trim();
            if (!this._replacementString.startsWith(replaceString)) {
                this.setAutoReplace(false);
            }
        }
        catch (BadLocationException badLocationException) {}
        super.apply(viewer, trigger, stateMask, offset);
    }

    private boolean checkNeedAddQuote(IDocument document) {
        block6: {
            ITypedRegion iTypedRegion = document.getPartition(this._replacementOffset);
            if (!"__js_string_double".equals(iTypedRegion.getType()) && !"__js_string_single".equals(iTypedRegion.getType()) || this._replacementString == null || this._replacementString.startsWith("\"")) break block6;
            return false;
        }
        try {
            if (this.isSelfPrefix() || this._replacementString != null && this._replacementString.endsWith(")") && this._replacementString.startsWith("url(")) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HTMLLexemeProvider lexemeProvider = this.createLexemeProvider(document, this._replacementOffset > 0 ? this._replacementOffset - 1 : this._replacementOffset);
        Lexeme tempLexeme = lexemeProvider.getLexemeFromOffset(this._replacementOffset);
        boolean needAddQuote = true;
        if (tempLexeme == null) {
            return needAddQuote;
        }
        String valueText = tempLexeme.getText();
        if (StringUtil.isNotBlank((String)valueText) && (valueText.endsWith("\"") || valueText.endsWith("'"))) {
            needAddQuote = false;
        }
        return needAddQuote;
    }

    HTMLLexemeProvider createLexemeProvider(IDocument document, int offset) {
        int documentLength = document.getLength();
        int lexemeProviderOffset = offset >= documentLength ? documentLength - 1 : offset;
        return new HTMLLexemeProvider(document, lexemeProviderOffset, (ITokenScanner)new HTMLTagScanner(false));
    }

    protected boolean isAutoReplace() {
        return this.isAutoReplace;
    }
}

