/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.actions;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.PlatformUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.ui.util.UIUtils;
import com.pandora.realtime.preview.RealTimeHelper;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;

public class ShowContextInformationTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof ITextSelection) {
            if (property.equalsIgnoreCase("isWebbrowserShow")) {
                final boolean[] show = new boolean[1];
                try {
                    UIUtils.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            show[0] = PlatformUtil.isWindows() && RealTimeHelper.isWebViewShowed();
                        }
                    });
                }
                catch (Throwable e) {
                    IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
                }
                return show[0];
            }
            AbstractThemeableEditor editor = null;
            IEditorPart activeEditor = UIUtils.getActiveEditor();
            if (activeEditor instanceof AbstractThemeableEditor) {
                editor = (AbstractThemeableEditor)activeEditor;
            }
            if (editor == null || editor.getDocument() == null) {
                return false;
            }
            String contentType = editor.getContentType();
            if ("com.aptana.contenttype.js".equals(contentType)) {
                return true;
            }
            if ("com.aptana.contenttype.html".equals(contentType)) {
                IDocument document = editor.getDocument();
                ISelection _selection = editor.getSelectionProvider().getSelection();
                if (_selection instanceof TextSelection) {
                    TextSelection textSelection = (TextSelection)_selection;
                    try {
                        contentType = document.getPartition(textSelection.getOffset()).getType();
                        if (contentType.startsWith("__js_")) {
                            return true;
                        }
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return false;
    }
}

