/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.actions;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.js.JSPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class JSSurroundWithAction
implements IEditorActionDelegate,
IWorkbenchWindowActionDelegate {
    private IEditorPart targetEditor = null;
    private ISelection selection = null;
    IWorkbenchWindow window = null;

    public void run(IAction action) {
        if (this.targetEditor != null && this.targetEditor instanceof AbstractThemeableEditor) {
            AbstractThemeableEditor themeableEditor = (AbstractThemeableEditor)this.targetEditor;
            this.selection = themeableEditor.getSelectionProvider().getSelection();
            ITextSelection textSelection = (ITextSelection)this.selection;
            IDocument doc = themeableEditor.getDocumentProvider().getDocument((Object)themeableEditor.getEditorInput());
            try {
                int line = doc.getLineOfOffset(textSelection.getOffset());
                int offset = doc.getLineOffset(line);
                int tabLength = textSelection.getOffset() - offset;
                String prefix = doc.get(offset, tabLength);
                StringBuffer space = new StringBuffer();
                char[] cArray = prefix.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    if (c == '\t') {
                        space.append(this.getTabString());
                    } else {
                        space.append(" ");
                    }
                    ++n2;
                }
                StringBuffer tab = new StringBuffer(space.toString());
                StringBuffer sb = new StringBuffer();
                sb.append("try{").append("\r\n");
                sb.append(tab.toString()).append("\t").append(textSelection.getText().replaceAll("\r\n", "\r\n\t").replaceAll("\n", "\n\t"));
                sb.append("\r\n").append(tab.toString()).append("}catch(e){").append("\r\n");
                sb.append(tab.toString()).append("\t").append("//TODO handle the exception").append("\r\n");
                sb.append(tab.toString()).append("}").append("\r\n");
                doc.replace(textSelection.getOffset(), textSelection.getLength(), sb.toString());
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
            }
        }
    }

    private String getTabString() {
        try {
            IPreferenceStore store = (IPreferenceStore)this.targetEditor.getClass().getMethod("getChainedPreferenceStore", new Class[0]).invoke((Object)this.targetEditor, new Object[0]);
            int size = store.getDefaultInt("tabWidth");
            StringBuffer tabStr = new StringBuffer();
            int i = 0;
            while (i < size) {
                tabStr.append(" ");
                ++i;
            }
            return tabStr.toString();
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
            return "    ";
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.targetEditor = targetEditor;
        if (action instanceof Action) {
            ((Action)action).setEnabled(true);
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }
}

