/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html;

import com.aptana.editor.common.IPartitionScannerSwitchStrategy;
import com.aptana.editor.common.PartitionScannerSwitchStrategy;
import com.aptana.editor.common.text.rules.CompositeSubPartitionScanner;
import com.aptana.editor.common.text.rules.ExtendedToken;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.SubPartitionScanner;
import com.aptana.editor.css.CSSSourceConfiguration;
import com.aptana.editor.html.HTMLSourceConfiguration;
import com.aptana.editor.html.parsing.HTMLUtils;
import com.aptana.editor.js.JSSourceConfiguration;
import com.aptana.editor.svg.SVGSourceConfiguration;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class HTMLSubPartitionScanner
extends CompositeSubPartitionScanner {
    private static final int TYPE_JS = 1;
    private static final int TYPE_CSS = 2;
    private static final int TYPE_SVG = 3;
    private static final String[] JS_SWITCH_SEQUENCES = new String[]{"</script>"};
    private static final String[] CSS_SWITCH_SEQUENCES = new String[]{"</style>"};
    private static final String[] SVG_SWITCH_SEQUENCES = new String[]{"</svg>"};

    public HTMLSubPartitionScanner() {
        super(new ISubPartitionScanner[]{new SubPartitionScanner(HTMLSourceConfiguration.getDefault().getPartitioningRules(), HTMLSourceConfiguration.CONTENT_TYPES, (IToken)new Token((Object)"__html__dftl_partition_content_type")), JSSourceConfiguration.getDefault().createSubPartitionScanner(), CSSSourceConfiguration.getDefault().createSubPartitionScanner(), SVGSourceConfiguration.getDefault().createSubPartitionScanner()}, new IPartitionScannerSwitchStrategy[]{new PartitionScannerSwitchStrategy(JS_SWITCH_SEQUENCES), new PartitionScannerSwitchStrategy(CSS_SWITCH_SEQUENCES), new PartitionScannerSwitchStrategy(SVG_SWITCH_SEQUENCES)});
    }

    public void setLastToken(IToken token) {
        super.setLastToken(token);
        if (token == null) {
            return;
        }
        Object data = token.getData();
        if (!(data instanceof String)) {
            this.current = 0;
            return;
        }
        String contentType = (String)data;
        if ("__html_script".equals(contentType) || "__svg_script".equals(contentType)) {
            if (!(token instanceof ExtendedToken) || !HTMLUtils.isTagSelfClosing(((ExtendedToken)token).getContents()) && HTMLUtils.isJavaScriptTag(((ExtendedToken)token).getContents())) {
                this.current = 1;
                super.setLastToken(null);
            }
        } else if ("__html_style".equals(contentType) || "__svg_style".equals(contentType)) {
            if (!(token instanceof ExtendedToken) || !HTMLUtils.isTagSelfClosing(((ExtendedToken)token).getContents()) && HTMLUtils.isTagComplete(((ExtendedToken)token).getContents())) {
                this.current = 2;
                super.setLastToken(null);
            }
        } else if ("__html__dftl_partition_content_type".equals(contentType) || "__dftl_partition_content_type".equals(contentType)) {
            this.current = 0;
        } else {
            int i = 0;
            while (i < this.subPartitionScanners.length) {
                if (this.subPartitionScanners[i].hasContentType(contentType)) {
                    this.current = i;
                    break;
                }
                ++i;
            }
        }
    }
}

