/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.text.CommonDoubleClickStrategy;
import com.aptana.editor.html.HTMLPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class HTMLDoubleClickStrategy
extends CommonDoubleClickStrategy {
    protected boolean selectWord(int caretPos) {
        return this.selectSpecialOpenTags(caretPos) ? true : super.selectWord(caretPos);
    }

    private boolean selectSpecialOpenTags(int caretPos) {
        block8: {
            char current;
            IDocument doc;
            block7: {
                block6: {
                    doc = this.fText.getDocument();
                    if (caretPos != doc.getLength()) break block6;
                    return false;
                }
                current = doc.getChar(caretPos);
                if (caretPos >= doc.getLength() - 1) break block7;
                char after = doc.getChar(caretPos + 1);
                if (current != '<' || after != '/' && after != '!') break block7;
                this.selectRange(caretPos - 1, caretPos + 2);
                return true;
            }
            try {
                if (caretPos > 0) {
                    char before = doc.getChar(caretPos - 1);
                    if ((current == '/' || current == '!') && before == '<') {
                        this.selectRange(caretPos - 2, caretPos + 1);
                        return true;
                    }
                }
            }
            catch (BadLocationException x) {
                if (!Platform.inDebugMode()) break block8;
                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)x);
            }
        }
        return false;
    }
}

