/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.webserver.ui.preferences;

import com.aptana.webserver.core.AliasServer;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.WebServerCorePlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class WebServerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "com.pandora.ui.preferences.webservers";
    public static final String WEBSERVERS_PREFERENCE_PAGE_ID = "com.pandora.webserver.preferences.servers";
    public static final String WEBSERVERS_LOCAL_PREFERENCE_PAGE_ID = "com.pandora.webserver.preferences.servers.local";
    private List<ComboViewer> serversView = new ArrayList<ComboViewer>();

    public void init(IWorkbench workbench) {
        this.setMessage("Web\u670d\u52a1\u5668\u8bbe\u7f6e");
        this.setDescription("\u8bbe\u7f6e\u5728\u5404\u7c7b\u6587\u4ef6\u4e2d\u8fdb\u884c\u6d4f\u89c8\u5668\u8fd0\u884c\u548c\u8fb9\u6539\u8fb9\u770b\u65f6\u4f7f\u7528\u7684Web\u670d\u52a1\u5668");
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        composite.setFont(parent.getFont());
        this.createServerSection(composite);
        return composite;
    }

    private void createServerSection(Composite parent) {
        Group group = new Group(parent, 0x800000);
        group.setText("Web\u670d\u52a1\u5668\u9009\u62e9");
        group.setFont(parent.getFont());
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).margins(10, 10).spacing(0, 15).create());
        List aliasSevers = WebServerCorePlugin.getDefault().getServerManager().getAllAliasServers();
        for (AliasServer aliasSever : aliasSevers) {
            Label html = new Label((Composite)group, 0);
            html.setText(String.valueOf(aliasSever.getAlias()) + "\u7c7b\u6587\u4ef6\uff1a");
            html.setLayoutData((Object)GridDataFactory.swtDefaults().create());
            ComboViewer comboViewer = new ComboViewer((Composite)group, 12);
            comboViewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
            comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof IServer) {
                        return ((IServer)element).toString();
                    }
                    return super.getText(element);
                }
            });
            comboViewer.setData("alias", (Object)aliasSever.getAlias());
            this.serversView.add(comboViewer);
        }
        Label alert = new Label((Composite)group, 0);
        alert.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
        alert.setText("\u6ce8\uff1aHBuilder\u5185\u7f6eWeb\u670d\u52a1\u5668\u4ec5\u652f\u6301html\u7c7b\u9759\u6001\u6587\u4ef6,\u5efa\u8bae\u975ehtml\u7c7b\u6587\u4ef6\u4f7f\u7528\u5916\u7f6eWeb\u670d\u52a1\u5668");
        alert.setForeground(this.getShell().getDisplay().getSystemColor(3));
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(131072, 4, true, false));
        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).margins(10, 10).spacing(15, 0).create());
        Link local = new Link(composite, 0);
        local.setText("<a>\u5185\u7f6eWeb\u670d\u52a1\u5668\u8bbe\u7f6e</a>");
        local.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, true).create());
        local.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog p = PreferencesUtil.createPreferenceDialogOn((Shell)WebServerPreferencePage.this.getShell(), (String)WebServerPreferencePage.WEBSERVERS_LOCAL_PREFERENCE_PAGE_ID, null, null);
                p.open();
            }
        });
        Link ext = new Link(composite, 0);
        ext.setText("<a>\u5916\u7f6eWeb\u670d\u52a1\u5668\u8bbe\u7f6e</a>");
        ext.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, true).create());
        ext.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog p = PreferencesUtil.createPreferenceDialogOn((Shell)WebServerPreferencePage.this.getShell(), (String)WebServerPreferencePage.WEBSERVERS_PREFERENCE_PAGE_ID, null, null);
                p.open();
            }
        });
    }

    private void init() {
        for (ComboViewer comboViewer : this.serversView) {
            comboViewer.setInput((Object)WebServerCorePlugin.getDefault().getServerManager().getAllServers());
            String alias = (String)comboViewer.getData("alias");
            IServer server = WebServerCorePlugin.getDefault().getServerManager().findAndCheckServerByAlias(alias);
            if (server != null) {
                comboViewer.setSelection((ISelection)new StructuredSelection((Object)server));
                continue;
            }
            comboViewer.getCombo().select(0);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.init();
        }
    }

    public boolean performOk() {
        for (ComboViewer comboViewer : this.serversView) {
            IStructuredSelection selection = (IStructuredSelection)comboViewer.getSelection();
            if (selection.isEmpty()) continue;
            IServer server = (IServer)selection.getFirstElement();
            WebServerCorePlugin.getDefault().getServerManager().setServerByAlias((String)comboViewer.getData("alias"), server.getName());
        }
        return super.performOk();
    }
}

