/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.webserver.ui.internal.actions;

import com.aptana.ui.ImageAssociations;
import com.aptana.webserver.core.IServerManager;
import com.aptana.webserver.core.IServerType;
import com.aptana.webserver.core.WebServerCorePlugin;
import com.aptana.webserver.ui.WebServerUIPlugin;
import com.aptana.webserver.ui.internal.actions.AddServerHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ServerTypesContributionItem
extends ContributionItem {
    public ServerTypesContributionItem() {
    }

    public ServerTypesContributionItem(String id) {
        super(id);
    }

    public void fill(Menu menu, int index) {
        IServerManager manager = WebServerCorePlugin.getDefault().getServerManager();
        ArrayList serverTypes = new ArrayList(manager.getServerTypes());
        Collections.sort(serverTypes, new Comparator<IServerType>(){

            @Override
            public int compare(IServerType o1, IServerType o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        for (IServerType type : serverTypes) {
            NewServerContributionItem item = new NewServerContributionItem(type);
            item.fill(menu, menu.getItemCount());
        }
    }

    private class NewServerContributionItem
    extends ContributionItem {
        private IServerType serverType;

        NewServerContributionItem(IServerType serverType) {
            this.serverType = serverType;
        }

        public void fill(Menu menu, int index) {
            MenuItem menuItem = new MenuItem(menu, 8, index);
            menuItem.setText(this.serverType.getName());
            menuItem.setImage(this.getImage(this.serverType));
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AddServerHandler.createServer(NewServerContributionItem.this.serverType.getId());
                }
            });
        }

        private Image getImage(IServerType serverType) {
            String id = serverType.getId();
            Image img = WebServerUIPlugin.getDefault().getImageRegistry().get(id);
            if (img != null) {
                return img;
            }
            ImageDescriptor desc = ImageAssociations.getInstance().getImageDescriptor(id);
            if (desc != null) {
                WebServerUIPlugin.getDefault().getImageRegistry().put(id, desc);
                return WebServerUIPlugin.getDefault().getImageRegistry().get(id);
            }
            return WebServerUIPlugin.getImage("icons/obj16/server.png");
        }
    }
}

