/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.webserver.ui.internal.actions;

import com.aptana.webserver.core.IServer;
import org.eclipse.core.expressions.PropertyTester;

public class ServerTester
extends PropertyTester {
    private static final String CAN_PROFILE = "canProfile";
    private static final String CAN_DEBUG = "canDebug";
    private static final String CAN_RUN = "canRun";
    private static final String CAN_EDIT = "canEdit";
    private static final String CAN_DELETE = "canDelete";
    private static final String CAN_RESTART = "canRestart";
    private static final String CAN_STOP = "canStop";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver == null || !(receiver instanceof IServer)) {
            return false;
        }
        IServer server = (IServer)receiver;
        if (CAN_RUN.equals(property)) {
            if (server.getState() != IServer.State.STOPPED) {
                return false;
            }
            return server.getAvailableModes().contains("run") && server.canStart();
        }
        if (CAN_DEBUG.equals(property)) {
            if (server.getState() != IServer.State.STOPPED) {
                return false;
            }
            return server.getAvailableModes().contains("debug") && server.canStart();
        }
        if (CAN_PROFILE.equals(property)) {
            if (server.getState() != IServer.State.STOPPED) {
                return false;
            }
            return server.getAvailableModes().contains("profile") && server.canStart();
        }
        if (CAN_STOP.equals(property)) {
            return server.getState() == IServer.State.STARTED && server.canStop();
        }
        if (CAN_RESTART.equals(property)) {
            return server.getState() == IServer.State.STARTED && server.canRestart();
        }
        return CAN_DELETE.equals(property) || CAN_EDIT.equals(property);
    }
}

