/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.webserver.ui.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.IPropertyDialog;
import com.aptana.ui.IPropertyDialogProvider;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.SimpleWebServer;
import com.aptana.webserver.core.WebServerCorePlugin;
import com.aptana.webserver.ui.WebServerUIPlugin;
import com.aptana.webserver.ui.internal.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SimpleWebServerPropertyDialog
extends TitleAreaDialog
implements IPropertyDialog {
    private static final int LABEL_WIDTH = 70;
    private SimpleWebServer source;
    private Text nameText;
    private Text baseUrlText;
    private ModifyListener modifyListener;

    public SimpleWebServerPropertyDialog(Shell parentShell) {
        super(parentShell);
        this.setHelpAvailable(false);
    }

    public Object getPropertySource() {
        return this.source;
    }

    public void setPropertySource(Object element) {
        this.source = null;
        if (element instanceof SimpleWebServer) {
            this.source = (SimpleWebServer)element;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.setTitle(Messages.SimpleWebServerPropertyDialog_Title);
        this.getShell().setText(Messages.SimpleWebServerPropertyDialog_ShellTitle);
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        PixelConverter converter = new PixelConverter((Control)composite);
        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(converter.convertHorizontalDLUsToPixels(7), converter.convertVerticalDLUsToPixels(7)).spacing(converter.convertHorizontalDLUsToPixels(4), converter.convertVerticalDLUsToPixels(4)).numColumns(3).create());
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(70), -1).create());
        label.setText(StringUtil.makeFormLabel((String)Messages.SimpleWebServerPropertyDialog_Name_Label));
        this.nameText = new Text(composite, 2052);
        this.nameText.setLayoutData((Object)GridDataFactory.fillDefaults().hint(this.convertHorizontalDLUsToPixels(200), -1).span(2, 1).grab(true, false).create());
        label = new Label(composite, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(70), -1).create());
        label.setText(StringUtil.makeFormLabel((String)Messages.SimpleWebServerPropertyDialog_BaseURL_Label));
        this.baseUrlText = new Text(composite, 2052);
        this.baseUrlText.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)this.baseUrlText).convertHorizontalDLUsToPixels(200), -1).span(2, 1).align(4, 0x1000000).grab(true, false).create());
        this.baseUrlText.setText("http://");
        label = new Label(composite, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(70), -1).create());
        label = new Label(composite, 0);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().hint(this.convertHorizontalDLUsToPixels(200), -1).span(2, 1).grab(true, false).create());
        label.setText("\u4f8b\uff1a http://127.0.0.1:8080/");
        if (this.source != null) {
            String name = this.source.getName();
            this.nameText.setText(name != null ? name : "");
            URL url = this.source.getBaseURL();
            if (url != null) {
                this.baseUrlText.setText(url.toExternalForm());
            }
        }
        this.addListeners();
        return dialogArea;
    }

    protected Control createContents(Composite parent) {
        try {
            Control control = super.createContents(parent);
            return control;
        }
        finally {
            this.validate();
        }
    }

    protected void okPressed() {
        if (!this.isValid()) {
            return;
        }
        if (this.source != null) {
            this.source.setName(this.nameText.getText());
            try {
                this.source.setBaseURL(new URL(this.baseUrlText.getText()));
            }
            catch (MalformedURLException e) {
                IdeLog.logError((Plugin)WebServerUIPlugin.getDefault(), (Throwable)e);
            }
        }
        WebServerCorePlugin.getDefault().saveServerConfigurations();
        super.okPressed();
    }

    private boolean isValid() {
        String message = null;
        if (this.nameText.getText().length() == 0) {
            message = Messages.SimpleWebServerPropertyDialog_EmptyNameError;
        } else {
            IServer server;
            if (this.source != null && !this.nameText.getText().equals(this.source.getName()) && (server = WebServerCorePlugin.getDefault().getServerManager().findServerByName(this.nameText.getText())) != null) {
                message = "\u5df2\u5b58\u5728\u540c\u540d\u7684Web\u670d\u52a1\u5668";
            }
            if (message == null) {
                try {
                    if (new URL(this.baseUrlText.getText()).getHost().length() == 0) {
                        message = Messages.SimpleWebServerPropertyDialog_InvalidURLError;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    message = Messages.SimpleWebServerPropertyDialog_InvalidURLError;
                }
            }
        }
        if (message == null) {
            this.setErrorMessage(null);
            this.setMessage(null);
            return true;
        }
        this.setErrorMessage(message);
        return false;
    }

    private void validate() {
        boolean valid = this.isValid();
        this.getButton(0).setEnabled(valid);
    }

    protected void addListeners() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SimpleWebServerPropertyDialog.this.validate();
                }
            };
        }
        this.nameText.addModifyListener(this.modifyListener);
        this.baseUrlText.addModifyListener(this.modifyListener);
    }

    protected void removeListeners() {
        if (this.modifyListener != null) {
            this.nameText.removeModifyListener(this.modifyListener);
            this.baseUrlText.removeModifyListener(this.modifyListener);
        }
    }

    public static class Provider
    implements IPropertyDialogProvider {
        public Dialog createPropertyDialog(IShellProvider shellProvider) {
            return new SimpleWebServerPropertyDialog(shellProvider.getShell());
        }
    }
}

