/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.core.listener;

import com.pandora.core.log.HBLog;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.launcher.core.DefaultMobileManager;
import com.pandora.launcher.core.LauncherCoreActivator;
import com.pandora.launcher.core.android.AndroidLauncher;
import com.pandora.launcher.core.ios_sim.IOSSimulatorLauncher;
import com.pandora.launcher.core.iphone.IPhoneLauncher;
import com.pandora.tools.android.AndroidPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.IStartup;

public class DeviceStartupListener
implements IStartup {
    private static AndroidLauncher androidLauncher = null;
    private static IPhoneLauncher iPhoneLauncher = null;
    private static IOSSimulatorLauncher iOSSimulatorLauncher = null;

    public void earlyStartup() {
        try {
            HBLog.logInfo((Plugin)LauncherCoreActivator.getDefault(), (String)("\u542f\u52a8\u9879" + this.getClass().getSimpleName() + "\u5df2\u7ecf\u5c31\u7eea\uff01"));
            AndroidPlugin.initTools();
            androidLauncher = new AndroidLauncher();
            androidLauncher.addLauncherListener(DefaultMobileManager.getInstance());
            iPhoneLauncher = new IPhoneLauncher();
            androidLauncher.startADBServer(true);
            HBLog.logInfo((Plugin)LauncherCoreActivator.getDefault(), (String)"\u542f\u52a8ADB\u670d\u52a1");
            AndroidLauncher androidLauncher = DeviceStartupListener.getAndroidLauncher();
            DeviceStartupListener.startAndroidLauncher();
            DeviceStartupListener.addShutdownHook(androidLauncher);
            DeviceStartupListener.startIPhoneLauncher();
            DeviceStartupListener.startIOSSimulatorLauncher();
        }
        catch (Throwable e) {
            HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (Throwable)e);
        }
    }

    public static void startIPhoneLauncher() {
        IPhoneLauncher iPhoneLauncher = DeviceStartupListener.getIPhoneLauncher();
        if (iPhoneLauncher != null) {
            iPhoneLauncher.addLauncherListener(DefaultMobileManager.getInstance());
            iPhoneLauncher.listeningDeviceList();
        }
    }

    public static void startAndroidLauncher() {
        if (androidLauncher == null) {
            androidLauncher = new AndroidLauncher();
            DeviceStartupListener.addShutdownHook(androidLauncher);
        }
        androidLauncher.addLauncherListener(DefaultMobileManager.getInstance());
        androidLauncher.listeningDeviceList();
    }

    public static void startIOSSimulatorLauncher() {
        if (!PlatformUtil.isMac()) {
            return;
        }
        if (iOSSimulatorLauncher == null) {
            iOSSimulatorLauncher = new IOSSimulatorLauncher();
        }
        iOSSimulatorLauncher.addLauncherListener(DefaultMobileManager.getInstance());
        iOSSimulatorLauncher.listeningDeviceList();
    }

    private static void addShutdownHook(final AndroidLauncher androidLauncher) {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                androidLauncher.stopJobs();
                androidLauncher.killADBServer(true);
                HBLog.logInfo((Plugin)LauncherCoreActivator.getDefault(), (String)"JVM\u5173\u95ed\u94a9\u5b50\u53d1\u8d77\u5173\u95edADB\u670d\u52a1\u6307\u4ee4...");
            }
        }));
    }

    public static AndroidLauncher getAndroidLauncher() {
        return androidLauncher;
    }

    public static IPhoneLauncher getIPhoneLauncher() {
        return iPhoneLauncher;
    }

    public static IOSSimulatorLauncher getIOSSimulatorLauncher() {
        return iOSSimulatorLauncher;
    }
}

