/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.core.iphone.util.plist;

import com.pandora.launcher.core.iphone.util.StringUtil;
import com.pandora.launcher.core.iphone.util.plist.ArrayElement;
import com.pandora.launcher.core.iphone.util.plist.BooleanElement;
import com.pandora.launcher.core.iphone.util.plist.DataElement;
import com.pandora.launcher.core.iphone.util.plist.DateElement;
import com.pandora.launcher.core.iphone.util.plist.DictionaryElement;
import com.pandora.launcher.core.iphone.util.plist.IntegerElement;
import com.pandora.launcher.core.iphone.util.plist.PElement;
import com.pandora.launcher.core.iphone.util.plist.PElementAdapter;
import com.pandora.launcher.core.iphone.util.plist.PElementType;
import com.pandora.launcher.core.iphone.util.plist.PList;
import com.pandora.launcher.core.iphone.util.plist.RealElement;
import com.pandora.launcher.core.iphone.util.plist.StringElement;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class JPlistBuilder {
    private static Logger log = Logger.getLogger("JPlistBuilder");
    private static SAXBuilder builder = new SAXBuilder();

    static {
        builder.setValidation(false);
        builder.setIgnoringElementContentWhitespace(true);
        builder.setIgnoringBoundaryWhitespace(true);
        builder.setFeature("http://xml.org/sax/features/validation", false);
        builder.setFeature("http://apache.org/xml/features/validation/schema", false);
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
    }

    public static PList buildPList(String content) {
        try {
            return JPlistBuilder.buildPList(builder.build((Reader)new StringReader(content)));
        }
        catch (Exception e) {
            log.severe(StringUtil.getStackTrace(e));
            return new PList();
        }
    }

    public static PList buildPList(InputStream is) {
        try {
            return JPlistBuilder.buildPList(builder.build(is));
        }
        catch (Exception e) {
            log.severe(StringUtil.getStackTrace(e));
            return new PList();
        }
    }

    public static PList buildPList(File file) {
        try {
            return JPlistBuilder.buildPList(new FileInputStream(file));
        }
        catch (Exception e) {
            log.severe(StringUtil.getStackTrace(e));
            return new PList();
        }
    }

    public static PList buildPList(Document doc) {
        List eplist;
        if (doc.getDocType() != null) {
            doc.removeContent((Content)doc.getDocType());
        }
        if ((eplist = doc.getContent()) == null || eplist.size() > 1) {
            throw new IllegalArgumentException("plist can only have one <plist/> root!");
        }
        Element edict = ((Element)eplist.get(0)).getChild("dict");
        if (!edict.getName().equals("dict")) {
            throw new IllegalArgumentException("plist must have <dict> as its first element!");
        }
        DictionaryElement dict = JPlistBuilder.parseDictionary(edict);
        return new PList(dict);
    }

    private static PElement parseGeneric(Element pelement) {
        PElementAdapter value;
        PElementType vType = PElementType.getType(pelement.getName());
        switch (vType) {
            case ARRAY: {
                value = JPlistBuilder.parseArray(pelement);
                break;
            }
            case BOOLEAN: {
                value = new BooleanElement(pelement.getName().equalsIgnoreCase("true"));
                break;
            }
            case STRING: {
                value = new StringElement(pelement.getValue());
                break;
            }
            case INTEGER: {
                value = new IntegerElement(pelement.getValue());
                break;
            }
            case DATA: {
                value = new DataElement(pelement.getValue());
                break;
            }
            case DICTIONARY: {
                value = JPlistBuilder.parseDictionary(pelement);
                break;
            }
            case REAL: {
                value = new RealElement(Double.parseDouble(pelement.getValue()));
                break;
            }
            case DATE: {
                value = new DateElement(pelement.getValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Value:" + pelement);
            }
        }
        return value;
    }

    private static DictionaryElement parseDictionary(Element edict) {
        List children = edict.getChildren();
        DictionaryElement dict = new DictionaryElement();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            Element keyElement = (Element)iter.next();
            PElementType keyType = PElementType.getType(keyElement.getName());
            if (keyType != PElementType.KEY) {
                throw new IllegalArgumentException("Missing KEY!");
            }
            String key = keyElement.getValue();
            Element pelement = (Element)iter.next();
            PElement value = JPlistBuilder.parseGeneric(pelement);
            dict.put(key, value);
        }
        return dict;
    }

    private static ArrayElement parseArray(Element parray) {
        List children = parray.getChildren();
        ArrayElement array = new ArrayElement();
        for (Element child : children) {
            PElement pechild = JPlistBuilder.parseGeneric(child);
            array.add(pechild);
        }
        return array;
    }
}

