/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.core.iphone.util;

import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class FileUtil {
    private static Logger log;
    private static final String TEMP_DIR_PREFIX = "tmp-mgr-";
    private static File sTmpDir;

    static {
        File[] tmpFiles;
        log = Logger.getLogger("FileUtil");
        sTmpDir = null;
        FileFilter tmpDirFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.getName().startsWith(FileUtil.TEMP_DIR_PREFIX);
            }
        };
        String tmpDirName = System.getProperty("java.io.tmpdir");
        File tmpDir = new File(tmpDirName);
        File[] fileArray = tmpFiles = tmpDir.listFiles(tmpDirFilter);
        int n = tmpFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File tmpFile = fileArray[n2];
            File lockFile = new File(tmpFile.getParent(), String.valueOf(tmpFile.getName()) + ".lck");
            if (!lockFile.exists()) {
                Logger.getLogger("default").log(Level.FINE, "TempFileManager::deleting old temp directory " + tmpFile);
                try {
                    FileUtil.recursiveDelete(tmpFile);
                }
                catch (IOException ex) {
                    Logger.getLogger("default").log(Level.INFO, "TempFileManager::unable to delete " + tmpFile.getAbsolutePath());
                    ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                    ex.printStackTrace(new PrintStream(ostream));
                    Logger.getLogger("default").log(Level.FINE, ostream.toString());
                }
            }
            ++n2;
        }
    }

    public static void main(String[] args) {
        FileUtil.setHostsEntry("127.0.0.1 gs.apple.com", false);
    }

    public static File backupFile(File file) {
        int i = 0;
        File bakFile = new File(String.valueOf(file.getAbsolutePath()) + "." + i++ + ".bak");
        while (bakFile.exists()) {
            bakFile = new File(String.valueOf(file.getAbsolutePath()) + "." + i++ + ".bak");
        }
        FileUtil.fileCopy(file, bakFile);
        return bakFile;
    }

    public static File getHostsFile() {
        File hosts = null;
        if (Platform.isMac() || Platform.isLinux()) {
            hosts = new File("/etc/hosts");
        } else if (Platform.isWindows()) {
            String winpath = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", (String)"PathName");
            hosts = new File(String.valueOf(winpath) + "\\system32\\drivers\\etc\\hosts");
        }
        return hosts;
    }

    public static synchronized boolean setHostsEntry(String entry, boolean active) {
        try {
            String line;
            if (entry == null) {
                throw new IllegalArgumentException("Entry must be 'override-host old-host'");
            }
            String[] vals = entry.trim().split("\\s+");
            if (vals == null || vals.length != 2) {
                throw new IllegalArgumentException("Entry must be 'override-host old-host'");
            }
            File hosts = FileUtil.getHostsFile();
            if (hosts == null || !hosts.exists()) {
                throw new RuntimeException("Unable to find hosts file!");
            }
            File ohosts = new File(hosts.getParentFile(), "hosts.umbrella");
            FileUtil.fileCopy(hosts, ohosts);
            BufferedReader br = new BufferedReader(new FileReader(ohosts));
            BufferedWriter bw = new BufferedWriter(new FileWriter(hosts));
            String key = vals[0];
            String value = vals[1];
            boolean entryAdded = false;
            while ((line = br.readLine()) != null) {
                if (!entryAdded) {
                    if (line.startsWith("#")) {
                        String ncline = line.substring(1);
                        if (ncline.matches(String.valueOf(key) + "\\s+" + value) && active) {
                            bw.append(ncline);
                            bw.newLine();
                            entryAdded = true;
                            continue;
                        }
                    } else if (line.matches(String.valueOf(key) + "\\s+" + value)) {
                        if (!active) {
                            bw.append("#");
                        }
                        if (active) {
                            entryAdded = true;
                        }
                    } else if (line.contains(value)) {
                        bw.append("#");
                        bw.append(line);
                        bw.newLine();
                        if (!active) continue;
                        bw.append(entry);
                        bw.newLine();
                        entryAdded = true;
                        continue;
                    }
                }
                bw.append(line);
                bw.newLine();
            }
            if (active && !entryAdded) {
                bw.append(entry);
                bw.newLine();
            }
            bw.close();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        if (sTmpDir == null) {
            String tmpDirName = System.getProperty("java.io.tmpdir");
            File tmpDir = File.createTempFile(TEMP_DIR_PREFIX, ".tmp", new File(tmpDirName));
            tmpDir.delete();
            File lockFile = new File(tmpDirName, String.valueOf(tmpDir.getName()) + ".lck");
            lockFile.createNewFile();
            lockFile.deleteOnExit();
            if (!tmpDir.mkdirs()) {
                throw new IOException("Unable to create temporary directory:" + tmpDir.getAbsolutePath());
            }
            sTmpDir = tmpDir;
        }
        return File.createTempFile(prefix, suffix, sTmpDir);
    }

    public static File createTempFile(InputStream is) {
        try {
            int count;
            if (is == null) {
                throw new Exception("Stream was null!");
            }
            File lib = FileUtil.createTempFile("_futil", null);
            lib.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(lib);
            byte[] buf = new byte[8192];
            while ((count = is.read(buf, 0, buf.length)) > 0) {
                fos.write(buf, 0, count);
            }
            try {
                fos.close();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            try {
                is.close();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            return lib;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File createTempFile(byte[] buf) {
        return FileUtil.createTempFile(new ByteArrayInputStream(buf));
    }

    public static void fileMove(File from, File to) {
        FileUtil.fileCopy(from, to);
        from.delete();
    }

    public static void fileCopy(File src, File dst) {
        try {
            if (dst.exists()) {
                dst.delete();
            }
            byte[] bytes = new byte[(int)src.length()];
            FileInputStream fis = new FileInputStream(src);
            fis.read(bytes);
            fis.close();
            FileOutputStream fos = new FileOutputStream(dst);
            fos.write(bytes);
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
    }

    public static byte[] readFile(String f) {
        return FileUtil.readFile(new File(f));
    }

    public static byte[] readFile(File f) {
        byte[] bytes;
        try {
            if (!f.exists()) {
                f.createNewFile();
            }
            bytes = new byte[(int)f.length()];
            FileInputStream fis = new FileInputStream(f);
            fis.read(bytes);
            fis.close();
        }
        catch (Exception exception) {
            bytes = null;
        }
        return bytes;
    }

    public static void writeFile(String name, byte[] d) throws IOException {
        File f = new File(name);
        if (f.exists()) {
            f.delete();
            f = new File(f.getAbsolutePath());
        }
        FileOutputStream out = new FileOutputStream(f);
        out.write(d);
        out.flush();
        out.close();
    }

    public static void writeFile(String src, File f) throws IOException {
        if (f.exists()) {
            f.delete();
            f = new File(f.getAbsolutePath());
        }
        FileOutputStream out = new FileOutputStream(f);
        out.write(src.trim().getBytes());
        out.close();
    }

    public static String getSHA(byte[] bytes) {
        String verString = "";
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA");
            sha.update(bytes);
            BigInteger bi = new BigInteger(sha.digest());
            verString = bi.toString(16);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return verString;
    }

    public static boolean verifySHA(byte[] bytes, String sha) {
        String tsha = FileUtil.getSHA(bytes);
        return sha.equals(tsha);
    }

    public static Map<String, byte[]> readRawJar(File path) {
        return FileUtil.readRawJar(path.getAbsolutePath());
    }

    public static Map<String, byte[]> readRawJar(String path) {
        HashMap<String, byte[]> code = new HashMap<String, byte[]>();
        try {
            JarFile jar = new JarFile(path, false);
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry je = e.nextElement();
                try {
                    InputStream is = jar.getInputStream(je);
                    byte[] data = new byte[8192];
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    int read = is.read(data);
                    while (read != -1) {
                        baos.write(data, 0, read);
                        read = is.read(data);
                    }
                    code.put(je.getName(), baos.toByteArray());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return code;
    }

    public static void dumpRawJar(File fileName, Map<String, byte[]> code) {
        FileUtil.dumpRawJar(fileName.getAbsolutePath(), code);
    }

    public static void dumpRawJar(String fileName, Map<String, byte[]> code) {
        try {
            File f = new File(fileName);
            FileOutputStream fos = new FileOutputStream(f);
            JarOutputStream jos = new JarOutputStream(fos);
            Set<Map.Entry<String, byte[]>> cset = code.entrySet();
            for (Map.Entry<String, byte[]> entry : cset) {
                String name = entry.getKey();
                byte[] bytes = entry.getValue();
                jos.putNextEntry(new JarEntry(name));
                jos.write(bytes);
                jos.flush();
            }
            jos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void recursiveDelete(File rootDir) throws IOException {
        File[] files;
        File[] fileArray = files = rootDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                FileUtil.recursiveDelete(rootDir);
            } else if (!file.delete()) {
                throw new IOException("Could not delete: " + file.getAbsolutePath());
            }
            ++n2;
        }
        if (!rootDir.delete()) {
            throw new IOException("Could not delete: " + rootDir.getAbsolutePath());
        }
    }
}

