/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.core.iphone.fw;

import com.pandora.launcher.core.iphone.fw.DeviceHardware;
import com.pandora.launcher.core.iphone.fw.DeviceOSVersion;
import com.pandora.launcher.core.iphone.util.plist.PElementType;
import com.pandora.launcher.core.iphone.util.plist.PList;

public class DeviceInfo {
    private PList dinfo;
    private boolean isValid = false;

    public DeviceInfo(PList plist) {
        this.dinfo = plist;
        this.isValid = this.getUUID().length() > 0;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String getDeviceName() {
        return this.dinfo.containsKey("DeviceName") ? this.dinfo.get("DeviceName").asString() : "";
    }

    public DeviceHardware getDeviceHardware() {
        String hw = this.dinfo.containsKey("HardwareModel") ? this.dinfo.get("HardwareModel").asString() : "";
        return DeviceHardware.get(hw, this.dinfo.containsKey("BasebandVersion"));
    }

    public DeviceOSVersion getDeviceOSVersion() {
        String hardware = this.dinfo.containsKey("HardwareModel") ? this.dinfo.get("HardwareModel").asString() : "";
        String buildVersion = this.dinfo.containsKey("BuildVersion") ? this.dinfo.get("BuildVersion").asString() : "";
        String basebandVersion = this.dinfo.containsKey("BasebandVersion") ? this.dinfo.get("BasebandVersion").asString() : "N/A";
        return DeviceOSVersion.get(DeviceHardware.get(hardware, !basebandVersion.equalsIgnoreCase("N/A")), buildVersion);
    }

    public String getECID(int base) {
        long ecid = this.dinfo.get("UniqueChipID").asLong();
        return Long.toString(ecid, base);
    }

    public String getBasebandSerialNumber() {
        return this.dinfo.containsKey("BasebandSerialNumber") ? (this.dinfo.get("BasebandSerialNumber").getType() == PElementType.DATA ? this.dinfo.get("BasebandSerialNumber").asData() : this.dinfo.get("BasebandSerialNumber").asString()) : "";
    }

    public String getBasebandBootloader() {
        return this.dinfo.containsKey("BasebandBootloaderVersion") ? this.dinfo.get("BasebandBootloaderVersion").asString() : "";
    }

    public int getBasebandGoldCertId() {
        return this.dinfo.containsKey("BasebandGoldCertId") ? (int)this.dinfo.get("BasebandGoldCertId").asLong() : 257;
    }

    public String getBasebandVersion() {
        return this.dinfo.containsKey("BasebandVersion") ? this.dinfo.get("BasebandVersion").asString() : "N/A";
    }

    public String getModelNumber() {
        String regionInfo;
        String modelNumber = this.dinfo.containsKey("ModelNumber") ? this.dinfo.get("ModelNumber").asString() : "";
        String string = regionInfo = this.dinfo.containsKey("RegionInfo") ? this.dinfo.get("RegionInfo").asString() : "";
        if (regionInfo.length() > 0) {
            modelNumber = String.valueOf(modelNumber) + regionInfo;
        }
        return modelNumber;
    }

    public String getSerialNumber() {
        return this.dinfo.containsKey("SerialNumber") ? this.dinfo.get("SerialNumber").asString() : "";
    }

    public String getUUID() {
        return this.dinfo.containsKey("UniqueDeviceID") ? this.dinfo.get("UniqueDeviceID").asString() : "";
    }
}

