/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.core.iphone;

import com.pandora.core.Platform;
import com.pandora.core.log.HBLog;
import com.pandora.core.utils.EclipseUtil;
import com.pandora.core.utils.FileUtil;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.core.utils.StatusLineUtils;
import com.pandora.core.utils.StringUtil;
import com.pandora.launcher.core.HMobileDeviceLauncher;
import com.pandora.launcher.core.ILauncher;
import com.pandora.launcher.core.IMobileListener;
import com.pandora.launcher.core.IPrintlnable;
import com.pandora.launcher.core.LauncherCoreActivator;
import com.pandora.launcher.core.exception.OperateException;
import com.pandora.launcher.core.internal.ApplicationsInfo;
import com.pandora.launcher.core.internal.Apps;
import com.pandora.launcher.core.internal.Mobile;
import com.pandora.launcher.core.iphone.Messages;
import com.pandora.launcher.core.iphone.jna.LibraryFinder;
import com.pandora.launcher.core.iphone.jna.idevice.DeviceLibraryRegistry;
import com.pandora.launcher.core.iphone.jna.idevice.IApplicationLogHandler;
import com.pandora.launcher.core.iphone.jna.idevice.IDevice;
import com.pandora.launcher.core.iphone.jna.idevice.IDeviceLibrary;
import com.pandora.launcher.core.iphone.jna.idevice.IDeviceNotificationHandler;
import com.pandora.launcher.core.iphone.jna.idevice.ILookupApplicationsNotificationHandler;
import com.pandora.launcher.core.iphone.jna.idevice.IScheduleHandler;
import com.pandora.launcher.core.iphone.jna.idevice.win.AFCConnection;
import com.pandora.launcher.core.iphone.util.plist.DictionaryElement;
import com.pandora.launcher.core.iphone.util.plist.PElement;
import com.pandora.launcher.core.iphone.util.plist.PElementType;
import com.pandora.launcher.core.iphone.util.plist.PList;
import com.pandora.tools.android.AndroidPlugin;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ui.PlatformUI;

public class IPhoneLauncher
implements ILauncher {
    private Mobile mobileTarget;
    private HashMap<Mobile, List<ApplicationsInfo>> appMap = new HashMap();
    private boolean isExist = false;
    private IMobileListener listener = null;
    private AFCConnection uploadServiceConnection = null;
    private AFCConnection afcConnection = null;
    private AFCConnection houseArrestService = null;
    private AFCConnection installServiceConnection;
    public static final String SERVICE_NAME_START = "com.apple.afc";
    public static final String SERVICE_NAME_install = "com.apple.mobile.installation_proxy";
    private static IDeviceLibrary deviceLibrary;
    private boolean isReRun = false;
    private boolean isDelete = false;
    private static String regEx;
    private static Pattern pattern;
    Job logJob;
    boolean isStoped = false;
    private String logFileName = "hb.log";
    private boolean isNeedWarnCache;

    static {
        regEx = "[\u4e00-\u9fa5]";
        pattern = Pattern.compile(regEx);
    }

    public IPhoneLauncher() {
        deviceLibrary = deviceLibrary == null ? DeviceLibraryRegistry.getDeviceLibrary() : deviceLibrary;
    }

    @Override
    public boolean checkDriver() throws OperateException {
        return LibraryFinder.foundMobileLibrary();
    }

    @Override
    public void connect(Mobile machine) throws OperateException {
        this.mobileTarget = machine;
        this.handleDeviceConnect(this.mobileTarget);
    }

    @Override
    public List<Mobile> getMachineList() {
        return null;
    }

    @Override
    public boolean isAppExists(final Apps app) throws OperateException {
        this.isDelete = false;
        if (this.mobileTarget != null && this.mobileTarget.getDevice() != null) {
            if (this.appMap.containsKey(this.mobileTarget) && this.appMap.get(this.mobileTarget) != null) {
                List<ApplicationsInfo> applist = this.appMap.get(this.mobileTarget);
                for (ApplicationsInfo applicationsInfo : applist) {
                    if (applicationsInfo == null || !applicationsInfo.getCFBundleIdentifier().equals(app.getId())) continue;
                    return true;
                }
            }
            deviceLibrary.addLookupApplicationsNotificationHandler(this.mobileTarget.getDevice(), new ILookupApplicationsNotificationHandler(){

                @Override
                public void LookupApplicationsNotificationHandler(IDevice device, PList deviceInfo) {
                    if (deviceInfo == null) {
                        return;
                    }
                    DictionaryElement de = deviceInfo.getValue();
                    Set<String> keySet = de.keySet();
                    ArrayList<ApplicationsInfo> list = new ArrayList<ApplicationsInfo>();
                    for (String key : keySet) {
                        String version;
                        Node node;
                        if (StringUtil.isBlank((String)key)) continue;
                        Document document = DocumentHelper.createDocument();
                        Element element = document.addElement("appinfo");
                        try {
                            IPhoneLauncher.this.getCFTypeValue(element, de.get(key), key);
                        }
                        catch (Throwable e1) {
                            e1.printStackTrace();
                        }
                        ApplicationsInfo applicationsInfo = new ApplicationsInfo();
                        applicationsInfo.setCFBundleIdentifier(key);
                        applicationsInfo.setAppDoc(document);
                        if (key.equals(app.getId()) && (node = document.selectSingleNode("//CFBundleShortVersionString")) != null && StringUtil.isNotBlank((String)(version = node.getText()))) {
                            if (version.equals(AndroidPlugin.IPHONE_BASE_VERSION)) {
                                IPhoneLauncher.this.isExist = true;
                            } else {
                                try {
                                    IPhoneLauncher.this.unInstallPackage(app.getId());
                                }
                                catch (OperateException e) {
                                    IPhoneLauncher.this.printlnToConsole(e.getMessage(), e);
                                }
                            }
                        }
                        if (key.equals("com.dheaven.h5builder")) {
                            try {
                                IPhoneLauncher.this.unInstallPackage("com.dheaven.h5builder");
                            }
                            catch (OperateException e) {
                                IPhoneLauncher.this.printlnToConsole(e.getMessage(), e);
                            }
                        }
                        list.add(applicationsInfo);
                    }
                    IPhoneLauncher.this.appMap.put(IPhoneLauncher.this.mobileTarget, list);
                }
            });
        }
        return this.isExist;
    }

    private void unInstallPackage(String path) throws OperateException {
        try {
            this.isDelete = true;
            this.connect(this.mobileTarget);
            if (this.installServiceConnection == null) {
                this.installServiceConnection = this.startService(SERVICE_NAME_install);
            }
            if (this.installServiceConnection == null || this.installServiceConnection.getAfc_connection() == null) {
                throw new OperateException(Messages.IPhoneLauncher_Open_Install_Service_Failed, true);
            }
            deviceLibrary.addAMDeviceUnInstallApplicationHandler(this.installServiceConnection, path, new IScheduleHandler(){

                @Override
                public void scheduleHandlerHandler(String scheduleMessage) {
                }

                @Override
                public boolean isDelete() {
                    return false;
                }
            });
        }
        catch (OperateException e) {
            if (this.isReRun) {
                this.isReRun = false;
                throw e;
            }
            this.isReRun = true;
            this.unInstallPackage(path);
        }
    }

    @Override
    public void installApplication(Apps app) throws OperateException {
        File tmpFile = null;
        try {
            try {
                this.connect(this.mobileTarget);
                this.uploadServiceConnection = this.startService(SERVICE_NAME_START);
                String path = app.getBasePath();
                File ipaPath = new File(path);
                if (StringUtil.isBlank((String)path) || !ipaPath.exists()) {
                    throw new OperateException("\u5b89\u88c5HBuilder\u57fa\u5ea7App\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u57fa\u5ea7App\u4e22\u5931\uff0c\u8bf7\u91cd\u65b0\u4ece\u5b98\u7f51\u4e0b\u8f7d\u65b0\u7684HBuilder");
                }
                if (pattern.matcher(path).find()) {
                    String newPath = "";
                    if (PlatformUtil.isWindows()) {
                        if (PlatformUtil.isWindowsXP()) {
                            File tmp;
                            newPath = System.getenv("ComSpec");
                            if (StringUtil.isNotBlank((String)newPath) && (tmp = new File(newPath)).exists() && tmp.isFile()) {
                                newPath = tmp.getParent();
                            }
                        } else {
                            newPath = System.getenv("ProgramData");
                            if (StringUtil.isNotBlank((String)newPath)) {
                                newPath = String.valueOf(newPath) + File.separator + "HBuilder";
                            }
                        }
                    } else {
                        URI uri = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
                        File tmpf = new File(uri);
                        if (tmpf.exists() && tmpf.isDirectory()) {
                            newPath = tmpf.getPath();
                        }
                    }
                    if (StringUtil.isNotBlank((String)newPath)) {
                        tmpFile = new File(newPath);
                        if (!tmpFile.exists() || !tmpFile.isDirectory()) {
                            tmpFile.mkdirs();
                        }
                        if ((tmpFile = new File(tmpFile, ipaPath.getName())).exists()) {
                            tmpFile.delete();
                        }
                        FileUtil.copyFile((File)ipaPath, (File)tmpFile);
                        path = tmpFile.getAbsolutePath();
                    }
                }
                this.upLoadPackage(path);
                this.installPackage(path);
            }
            catch (OperateException e) {
                if (this.isReRun) {
                    this.isReRun = false;
                    throw e;
                }
                this.isReRun = true;
                this.installApplication(app);
                if (tmpFile != null && tmpFile.exists()) {
                    tmpFile.delete();
                }
            }
        }
        finally {
            if (tmpFile != null && tmpFile.exists()) {
                tmpFile.delete();
            }
        }
    }

    private void installPackage(String path) throws OperateException {
        if (this.installServiceConnection == null) {
            this.installServiceConnection = this.startService(SERVICE_NAME_install);
        }
        if (this.installServiceConnection == null || this.installServiceConnection.getAfc_connection() == null) {
            throw new OperateException(Messages.IPhoneLauncher_Open_Install_Service_Failed, true);
        }
        deviceLibrary.addAMDeviceInstallApplicationHandler(this.installServiceConnection, path, new IScheduleHandler(){

            @Override
            public void scheduleHandlerHandler(String scheduleMessage) {
            }

            @Override
            public boolean isDelete() {
                return IPhoneLauncher.this.isDelete;
            }
        });
    }

    private AFCConnection startHouseArrestService(IDevice device, String serviceName) {
        if (this.houseArrestService == null) {
            this.houseArrestService = deviceLibrary.addStartHouseArrestServiceHandler(this.mobileTarget.getDevice(), serviceName);
        }
        int t = 0;
        while (this.houseArrestService == null) {
            ++t;
            this.houseArrestService = deviceLibrary.addStartHouseArrestServiceHandler(this.mobileTarget.getDevice(), serviceName);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            if (t > 5) break;
        }
        return this.houseArrestService;
    }

    private void upLoadPackage(String path) throws OperateException {
        if (this.uploadServiceConnection == null) {
            throw new OperateException(Messages.IPhoneLauncher_Select_Phone, true);
        }
        deviceLibrary.addAMDeviceTransferApplicationHandler(this.uploadServiceConnection, path, new IScheduleHandler(){

            @Override
            public void scheduleHandlerHandler(String scheduleMessage) {
            }

            @Override
            public boolean isDelete() {
                return IPhoneLauncher.this.isDelete;
            }
        });
    }

    private void openAFCConnection(AFCConnection connection) throws OperateException {
        if (connection != null && connection.getAfc_connection() != null) {
            if (this.afcConnection != null && this.afcConnection.getAfc_connection() != null) {
                return;
            }
            this.afcConnection = deviceLibrary.addOpenAFCConnectionHandler(connection);
            int t = 0;
            while (this.afcConnection == null) {
                ++t;
                this.afcConnection = deviceLibrary.addOpenAFCConnectionHandler(connection);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                if (t > 5) break;
            }
            if (this.afcConnection == null) {
                throw new OperateException(Messages.IPhoneLauncher_Open_Connection_Failed, true);
            }
        } else {
            throw new OperateException(Messages.IPhoneLauncher_Open_Service_Failed, true);
        }
    }

    private AFCConnection startService(String serviceName) throws OperateException {
        AFCConnection connection = null;
        if (this.mobileTarget != null && this.mobileTarget.getDevice() != null) {
            connection = deviceLibrary.addStartServiceHandler(this.mobileTarget.getDevice(), serviceName);
            int t = 0;
            while (connection == null) {
                ++t;
                connection = deviceLibrary.addStartServiceHandler(this.mobileTarget.getDevice(), serviceName);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                if (t > 5) break;
            }
            if (connection == null) {
                throw new OperateException(Messages.IPhoneLauncher_Open_Phone_Service_Failed, true);
            }
        } else {
            throw new OperateException(Messages.IPhoneLauncher_Select_Phone, true);
        }
        return connection;
    }

    protected void getCFTypeValue(Element element, PElement pElement, String key) {
        PElementType type = pElement.getType();
        switch (type) {
            case PLIST: {
                break;
            }
            case KEY: {
                break;
            }
            case STRING: {
                element.addElement(key).setText(pElement.asString());
                break;
            }
            case REAL: {
                break;
            }
            case INTEGER: {
                element.addElement(key).setText(Long.toString(pElement.asLong()));
                break;
            }
            case DATE: {
                element.addElement(key).setText(pElement.asDate());
                break;
            }
            case BOOLEAN: {
                element.addElement(key).setText(Boolean.toString(pElement.asBoolean()));
                break;
            }
            case DATA: {
                element.addElement(key).setText(pElement.asData());
                break;
            }
            case ARRAY: {
                break;
            }
            case DICTIONARY: {
                Map<String, PElement> map = pElement.asDict();
                Set<String> keySet = map.keySet();
                for (String mapKey : keySet) {
                    PElement pe = map.get(mapKey);
                    this.getCFTypeValue(element, pe, mapKey);
                }
                break;
            }
        }
    }

    @Override
    public void deletePackage(Apps app) throws OperateException {
        try {
            AFCConnection connection;
            this.connect(this.mobileTarget);
            if ((this.afcConnection == null || this.afcConnection.getAfc_connection() == null) && (connection = this.startHouseArrestService(this.mobileTarget.getDevice(), app.getId())) != null && connection.getAfc_connection() != null) {
                this.openAFCConnection(connection);
            }
            if (this.afcConnection != null && this.afcConnection.getAfc_connection() != null) {
                deviceLibrary.addAFCRemovePathHandler(this.afcConnection, "/", app.getAppid(), null);
                deviceLibrary.addAFCRemovePathHandler(this.afcConnection, this.getLogFilePath(app), app.getAppid(), null);
            }
        }
        catch (OperateException e) {
            if (this.isReRun) {
                this.isReRun = false;
                this.printlnToConsole(e.getMessage(), e);
                return;
            }
            this.isReRun = true;
            this.deletePackage(app);
        }
        catch (Exception e) {
            if (this.isReRun) {
                this.isReRun = false;
                e.printStackTrace();
                return;
            }
            this.isReRun = true;
            this.deletePackage(app);
        }
    }

    @Override
    public void pushResource(Apps app, String resourcePath, String targetPath) throws OperateException {
        try {
            Set<String> fs = HMobileDeviceLauncher.getFileReference(app.getProject(), resourcePath);
            if (this.afcConnection != null && this.afcConnection.getAfc_connection() != null) {
                deviceLibrary.addAFCFileWriteHandler(this.afcConnection, app.getAppid(), resourcePath, targetPath, fs);
            }
        }
        catch (OperateException e) {
            if (this.isReRun) {
                this.isReRun = false;
                throw e;
            }
            this.isReRun = true;
            this.connect(this.mobileTarget);
            this.pushResource(app, resourcePath, targetPath);
        }
    }

    @Override
    public void pushPackage(Apps app) throws OperateException {
        try {
            this.connect(this.mobileTarget);
            String appid = app.getAppid();
            String localPath = "";
            localPath = app.getResourcePath() != null && app.getResourcePath().exists() ? app.getResourcePath().getAbsolutePath() : app.getProject().getLocation().toOSString();
            this.createDirAndFile(localPath, app.getId(), appid);
        }
        catch (OperateException e) {
            if (this.isReRun) {
                this.isReRun = false;
                throw e;
            }
            this.isReRun = true;
            this.pushPackage(app);
        }
    }

    private void createDirAndFile(String localPath, String serviceName, String appid) throws OperateException {
        AFCConnection connection;
        if ((this.afcConnection == null || this.afcConnection.getAfc_connection() == null) && (connection = this.startHouseArrestService(this.mobileTarget.getDevice(), serviceName)) != null && connection.getAfc_connection() != null) {
            this.openAFCConnection(connection);
        }
        if (this.afcConnection == null || this.afcConnection.getAfc_connection() == null) {
            throw new OperateException(Messages.IPhoneLauncher_Open_Write_File_Service_Failed, true);
        }
        deviceLibrary.addAFCFileRefWriteHandler(this.afcConnection, appid, localPath);
    }

    @Override
    public void startApplication(Apps app) throws OperateException {
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode(LauncherCoreActivator.PLUGIN_ID);
        boolean isFirstRunIphoe = true;
        try {
            isFirstRunIphoe = prefs.getBoolean("first_launch_iphone", true);
            if (!isFirstRunIphoe) {
                this.printlnToConsole("\u8054\u673a\u8c03\u8bd5\u5e76\u975e\u6253\u5305\uff0c\u8c03\u8bd5\u5305\u662f HBuilder\u9ed8\u8ba4\u7684\u6d4b\u8bd5\u5305\uff0c\u6743\u9650\u3001\u56fe\u6807\u90fd\u4e0d\u53ef\u81ea\u5b9a\u4e49\u3002\u53ea\u6709\u5728\u70b9\u83dc\u5355\"\u53d1\u884c-\u53d1\u884c\u4e3a\u539f\u751f\u5b89\u88c5\u5305\"\u65f6\u624d\u80fd\u81ea\u5b9a\u4e49\u8fd9\u4e9b\u8bbe\u7f6e", new OperateException(null));
                prefs.putBoolean("first_launch_iphone", false);
                prefs.flush();
            }
        }
        catch (Exception e) {
            HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (Throwable)e);
        }
        this.printlnToConsole("iOS\u8bbe\u5907\u53ef\u4f7f\u7528console.log()\u8f93\u51fa\u5185\u5bb9\u5230\u63a7\u5236\u53f0\uff0c\u4f46\u662f\u53ef\u80fd\u53ea\u80fd\u8f93\u51faplusready\u4e4b\u540e\u7684\u8c03\u8bd5\u5185\u5bb9", new OperateException(null));
        String version = this.mobileTarget.getVersion();
        if (StringUtil.isNotBlank((String)version) && version.startsWith("9")) {
            this.printlnToConsole("iOS9.0\u53ca\u4ee5\u4e0a\u7cfb\u7edf\u9700\u8981\u5728\"\u8bbe\u7f6e\"-\"\u901a\u7528\"-\"\u63cf\u8ff0\u6587\u4ef6\"(\u6216\"\u8bbe\u5907\u7ba1\u7406\")\u4e2d\u4fe1\u4efbDCloud\u4f01\u4e1a\u8bc1\u4e66(Digital Heaven\u5f00\u5934\u7684\u8bc1\u4e66)\u624d\u53ef\u4ee5\u6b63\u5e38\u4f7f\u7528", new OperateException(null));
        }
        this.printlnToConsole(Messages.IPhoneLauncher_Initiative_Start_App, new OperateException(null));
    }

    public void printlnToConsole(String message, OperateException exception) {
        if (this.listener instanceof IPrintlnable) {
            IPrintlnable print = (IPrintlnable)((Object)this.listener);
            if (exception == null) {
                print.printlnToConsole(message);
            } else {
                print.printlnToConsole(message, exception);
            }
        }
    }

    @Override
    public void stopApplication(Apps app) throws OperateException {
    }

    @Override
    public void addLauncherListener(IMobileListener listener) {
        this.listener = listener;
    }

    private boolean isExistMobile(Mobile mobile, List<Mobile> mobileList) {
        boolean isExist = false;
        if (mobile == null) {
            return isExist;
        }
        for (Mobile mobi : mobileList) {
            if (!mobi.getUuid().equals(mobile.getUuid())) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    private Mobile coverPListToMobile(PList deviceInfo) {
        if (deviceInfo == null) {
            return null;
        }
        DictionaryElement dictionaryElement = deviceInfo.getValue();
        Mobile mobile = new Mobile(dictionaryElement.get("DeviceName").asString(), this.getIcon());
        mobile.setUuid(dictionaryElement.get("UniqueDeviceID").asString());
        mobile.setVersion(dictionaryElement.get("ProductVersion") == null ? "" : dictionaryElement.get("ProductVersion").asString());
        return mobile;
    }

    private String getIcon() {
        return "/icons/ipad.png";
    }

    @Override
    public Apps getTestApp(IProject project) {
        return new Apps("io.dcloud.HBuilder", "", "HBuilder", project, AndroidPlugin.IPHONE_BASE);
    }

    @Override
    public void listeningDeviceList() {
        HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)Messages.IPhoneLauncher_21);
        Job job = new Job("iPhone device"){

            protected IStatus run(IProgressMonitor monitor) {
                if (deviceLibrary == null) {
                    return Status.CANCEL_STATUS;
                }
                deviceLibrary.addNotificationHandler(new IDeviceNotificationHandler(){

                    @Override
                    public void onDeviceConnected(IDevice device, PList deviceInfo) {
                        List<Mobile> mobileList;
                        if (deviceInfo == null) {
                            return;
                        }
                        Mobile mobile = IPhoneLauncher.this.coverPListToMobile(deviceInfo);
                        HBLog.logTrace((Plugin)LauncherCoreActivator.getDefault(), (String)(String.valueOf(mobile.getName()) + "\u5df2\u8fde\u63a5\u7535\u8111"));
                        mobile.setDevice(device);
                        mobile.setPlatform(Platform.IPHONE);
                        if (IPhoneLauncher.this.listener != null) {
                            IPhoneLauncher.this.listener.connected(mobile);
                        }
                        if (!(mobileList = LauncherCoreActivator.getMobileList()).contains(mobile) && !IPhoneLauncher.this.isExistMobile(mobile, mobileList)) {
                            LauncherCoreActivator.addMobile(mobile);
                            String message = String.valueOf(mobile.getName()) + Messages.IPhoneLauncher_Connected_PC;
                            StatusLineUtils.showStatusMessage((String)message, (long)5000L);
                        }
                    }

                    @Override
                    public void onDeviceDisconnected(IDevice device, PList deviceInfo) {
                        Mobile mobile = null;
                        List<Mobile> list = LauncherCoreActivator.getMachineList(Platform.IPHONE);
                        mobile = list.size() == 1 ? list.get(0) : IPhoneLauncher.this.coverPListToMobile(deviceInfo);
                        if (mobile != null) {
                            System.out.println(String.valueOf(mobile.getName()) + "\u5df2\u65ad\u5f00\u8fde\u63a5");
                            LauncherCoreActivator.removeMobile(mobile.getUuid(), Platform.IPHONE);
                            if (IPhoneLauncher.this.mobileTarget != null && mobile.getUuid().equals(IPhoneLauncher.this.mobileTarget.getUuid())) {
                                IPhoneLauncher.this.mobileTarget = null;
                            }
                            if (IPhoneLauncher.this.listener != null) {
                                IPhoneLauncher.this.listener.disConnected(mobile);
                            }
                            String message = String.valueOf(mobile.getName()) + Messages.IPhoneLauncher_Existed_PC;
                            StatusLineUtils.showStatusMessage((String)message, (long)5000L);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.schedule();
    }

    private void handleDeviceConnect(Mobile mobile) throws OperateException {
        this.deviceDisconnected(mobile);
        this.deviceConnected(mobile);
    }

    private void deviceDisconnected(Mobile mobile) {
        deviceLibrary.handleDisconnect(mobile.getDevice());
    }

    private void deviceConnected(Mobile mobile) throws OperateException {
        deviceLibrary.handleConnect(mobile.getDevice(), true);
    }

    @Override
    public void getApplicationLog(final Apps app) throws OperateException {
        final int[] index = new int[1];
        this.logJob = new Job("\u83b7\u53d6\u65e5\u5fd7"){

            protected IStatus run(final IProgressMonitor monitor) {
                try {
                    if (monitor.isCanceled() || IPhoneLauncher.this.isStoped) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    try {
                        final int wpLength = "/Library/Pandora/apps/HBuilder/www/".length();
                        if (IPhoneLauncher.this.afcConnection != null && IPhoneLauncher.this.afcConnection.getAfc_connection() != null) {
                            deviceLibrary.addAFCFileReadHandler(IPhoneLauncher.this.afcConnection, IPhoneLauncher.this.getLogFilePath(app), new IApplicationLogHandler(){

                                @Override
                                public void readBytes(byte[] logBytes) {
                                    int bl;
                                    int i;
                                    if (logBytes == null) {
                                        return;
                                    }
                                    byte[] pbyte = null;
                                    boolean isCompleted = false;
                                    int length = logBytes.length;
                                    int pl = 0;
                                    boolean needDelete = false;
                                    String newFileName = "";
                                    if (logBytes.length > 9216) {
                                        ArrayList<Byte> fnameByteList = new ArrayList<Byte>();
                                        i = logBytes.length - 1;
                                        while (i > 0) {
                                            if (i > 0 && logBytes[i] == 10 && logBytes[i - 1] == 13) break;
                                            ++pl;
                                            fnameByteList.add(logBytes[i]);
                                            --i;
                                        }
                                        if (monitor.isCanceled() || (this).IPhoneLauncher.this.isStoped) {
                                            return;
                                        }
                                        int size = fnameByteList.size();
                                        if (size > 8 && (Byte)fnameByteList.get(0) == -1 && (Byte)fnameByteList.get(1) == -1 && (Byte)fnameByteList.get(2) == -1 && (Byte)fnameByteList.get(3) == -1 && (Byte)fnameByteList.get(size - 1) == -1 && (Byte)fnameByteList.get(size - 2) == -1 && (Byte)fnameByteList.get(size - 3) == -1 && (Byte)fnameByteList.get(size - 4) == -1) {
                                            byte[] fnameByte = new byte[fnameByteList.size() - 8];
                                            int i2 = 0;
                                            int j = fnameByteList.size() - 5;
                                            while (j > 3) {
                                                fnameByte[i2] = (Byte)fnameByteList.get(j);
                                                ++i2;
                                                --j;
                                            }
                                            if (fnameByte.length > 0) {
                                                newFileName = new String(fnameByte);
                                                needDelete = true;
                                                isCompleted = true;
                                            }
                                        }
                                        if (monitor.isCanceled() || (this).IPhoneLauncher.this.isStoped) {
                                            return;
                                        }
                                    }
                                    int unReadLen = logBytes.length - index[0];
                                    if (index[0] == 0 && pl < 1 || unReadLen < 0) {
                                        pbyte = logBytes;
                                    } else {
                                        pbyte = new byte[unReadLen];
                                        i = index[0];
                                        while (i < length - pl) {
                                            pbyte[i - index[0]] = logBytes[i];
                                            ++i;
                                        }
                                    }
                                    index[0] = isCompleted ? 0 : logBytes.length;
                                    if (monitor.isCanceled() || (this).IPhoneLauncher.this.isStoped) {
                                        return;
                                    }
                                    String logContent = new String(pbyte);
                                    String[] logs = logContent.split("\r\n");
                                    int l = logs.length - 1;
                                    if (l > -1 && !logContent.endsWith("\r\n") && StringUtil.isNotBlank((String)logs[l]) && index[0] > (bl = logs[l].getBytes().length)) {
                                        index[0] = index[0] - bl;
                                        logs[l] = "";
                                    }
                                    if (monitor.isCanceled() || (this).IPhoneLauncher.this.isStoped) {
                                        return;
                                    }
                                    String[] stringArray = logs;
                                    int n = logs.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String log = stringArray[n2];
                                        if (!StringUtil.isBlank((String)log) && !log.contains("\ufffd\ufffd\ufffd\ufffd")) {
                                            if (log.startsWith("[ERROR] :")) {
                                                int findex = log.indexOf("file:///");
                                                int windex = log.indexOf("/Library/Pandora/apps/HBuilder/www/");
                                                if (findex > 0 && windex > 0) {
                                                    String tmp = log.substring(findex, windex + wpLength);
                                                    log = log.replace(tmp, "");
                                                    log = log.replace("filename:", "file name:");
                                                    log = log.replace("lineno:", "line no:");
                                                }
                                                IPhoneLauncher.this.printlnToConsole(log, new OperateException(null));
                                            } else {
                                                IPhoneLauncher.this.printlnToConsole(log, null);
                                            }
                                        }
                                        ++n2;
                                    }
                                    if (needDelete) {
                                        try {
                                            deviceLibrary.addAFCRemovePathHandler(IPhoneLauncher.this.afcConnection, IPhoneLauncher.this.getLogFilePath(app), app.getAppid(), null);
                                            if (StringUtil.isNotBlank((String)newFileName)) {
                                                IPhoneLauncher.this.setLogFileName(newFileName);
                                            }
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    if (monitor.isCanceled() || (this).IPhoneLauncher.this.isStoped) {
                                        return;
                                    }
                                }
                            });
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                finally {
                    if (PlatformUI.isWorkbenchRunning()) {
                        this.schedule(1000L);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        this.logJob.setUser(false);
        this.logJob.setSystem(true);
        this.logJob.schedule();
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void setLogFileName(String logFileName) {
        this.logFileName = logFileName;
    }

    private String getLogFilePath(Apps app) {
        return "/Library/Pandora/apps/" + app.getAppid() + "/log/" + this.getLogFileName();
    }

    @Override
    public void clearApplicationLog(Apps app) throws OperateException {
        if (this.logJob != null) {
            this.logJob.cancel();
        }
        this.isStoped = true;
    }

    @Override
    public void deleteResource(Apps app, String resourcePath, String targetPath) throws OperateException {
        try {
            Set<String> fs = HMobileDeviceLauncher.getFileReference(app.getProject(), resourcePath);
            this.connect(this.mobileTarget);
            if (this.afcConnection != null && this.afcConnection.getAfc_connection() != null) {
                deviceLibrary.addAFCRemovePathHandler(this.afcConnection, targetPath, app.getAppid(), fs);
            }
        }
        catch (OperateException e) {
            if (this.isReRun) {
                this.isReRun = false;
                throw e;
            }
            this.isReRun = true;
            this.deleteResource(app, resourcePath, targetPath);
        }
    }

    public boolean isNeedWarnCache() {
        return this.isNeedWarnCache;
    }

    @Override
    public void setNeedWarnCache(boolean b) {
        this.isNeedWarnCache = b;
    }
}

