/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.core.android.idevice;

import com.pandora.core.log.HBLog;
import com.pandora.core.utils.Environment;
import com.pandora.core.utils.StringUtil;
import com.pandora.launcher.core.LauncherCoreActivator;
import com.pandora.launcher.core.android.idevice.md.AndroidLibrary;
import com.pandora.tools.android.AndroidPlugin;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.File;
import org.eclipse.core.runtime.Plugin;

public class AndroidLibraryFinder {
    public static AndroidLibrary ANDROIDLIBRARY = null;
    public static String path = "";

    static {
        AndroidLibraryFinder.loadPath();
        AndroidLibraryFinder.getAndroidLibrary();
    }

    private static void loadPath() {
        if (Platform.isWindows()) {
            String path = AndroidLibraryFinder.getPath();
            if (StringUtil.isNotBlank((String)path)) {
                File file = new File(path);
                if (!file.exists()) {
                    HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (String)"AndroidLibrary file can not find.");
                    return;
                }
                String ppp = System.getenv("Path");
                ppp = String.valueOf(ppp) + file.getParent();
                Environment.setEnv((String)"Path", (String)ppp);
                System.setProperty("LD_LIBRARY_PATH", file.getParent());
                System.setProperty("java.library.path", file.getParent());
            } else {
                HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (String)"AndroidLibrary can not find.");
            }
        }
    }

    private static String getPath() {
        if (StringUtil.isNotBlank((String)path)) {
            return path;
        }
        path = AndroidPlugin.LIBRARY_PATH;
        return path;
    }

    private static boolean loadAndroidLibrary() {
        String path = AndroidLibraryFinder.getPath();
        boolean b = StringUtil.isNotBlank((String)path);
        if (b) {
            File file = new File(path);
            b = file.exists();
            if (b) {
                try {
                    System.load(path);
                }
                catch (Throwable e) {
                    HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (String)"load path error", (Throwable)e);
                    b = false;
                }
            } else {
                HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (String)(String.valueOf(path) + " is not exits!"));
            }
        }
        return b;
    }

    public static AndroidLibrary getAndroidLibrary() {
        if (ANDROIDLIBRARY != null) {
            return ANDROIDLIBRARY;
        }
        if (AndroidLibraryFinder.loadAndroidLibrary()) {
            ANDROIDLIBRARY = (AndroidLibrary)Native.loadLibrary(AndroidLibrary.class);
            return ANDROIDLIBRARY;
        }
        return null;
    }
}

