/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter.ui.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class Util {
    private static char[] NO_CHAR = new char[0];
    private static final int DEFAULT_READING_SIZE = 8192;

    public static String concatenate(String[] lines, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < lines.length) {
            if (i > 0) {
                buffer.append(delimiter);
            }
            buffer.append(lines[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static char[] getInputStreamAsCharArray(InputStream stream, int length, String encoding) throws IOException {
        InputStreamReader reader = null;
        try {
            try {
                reader = encoding == null ? new InputStreamReader(Util.toBufferedInputStream(stream)) : new InputStreamReader(stream, encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                reader = new InputStreamReader(Util.toBufferedInputStream(stream));
            }
            int totalRead = 0;
            char[] contents = length == -1 ? NO_CHAR : new char[length];
            while (true) {
                int amountRequested;
                if (totalRead < length) {
                    amountRequested = length - totalRead;
                } else {
                    int current = reader.read();
                    if (current < 0) break;
                    amountRequested = Math.max(stream.available(), 8192);
                    if (totalRead + 1 + amountRequested > contents.length) {
                        char[] cArray = contents;
                        contents = new char[totalRead + 1 + amountRequested];
                        System.arraycopy(cArray, 0, contents, 0, totalRead);
                    }
                    contents[totalRead++] = (char)current;
                }
                int amountRead = reader.read(contents, totalRead, amountRequested);
                if (amountRead < 0) break;
                totalRead += amountRead;
            }
            int start = 0;
            if (totalRead > 0 && "UTF-8".equals(encoding) && contents[0] == '\ufeff') {
                --totalRead;
                start = 1;
            }
            if (totalRead < contents.length) {
                char[] cArray = contents;
                contents = new char[totalRead];
                System.arraycopy(cArray, start, contents, 0, totalRead);
            }
            char[] cArray = contents;
            return cArray;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private static InputStream toBufferedInputStream(InputStream stream) {
        if (stream instanceof BufferedInputStream) {
            return stream;
        }
        return new BufferedInputStream(stream, 8192);
    }

    public static String[] splitLines(CharSequence content) {
        if (content == null) {
            return null;
        }
        LineSplitter splitter = new LineSplitter(content);
        return splitter.split();
    }

    public static String[] splitLines(CharSequence content, int limit) {
        if (content == null) {
            return null;
        }
        LineSplitter splitter = new LineSplitter(content);
        return splitter.split(limit);
    }

    static class LineSplitter {
        private final CharSequence content;
        protected final int contentEnd;
        protected int contentPos;
        protected String lastLineDelimiter = null;
        private static final String DELIMITER_WINDOWS = "\r\n";
        private static final String DELIMITER_UNIX = "\n";
        private static final String DELIMITER_MAC = "\r";

        public LineSplitter(CharSequence content) {
            this.content = content;
            this.contentEnd = content.length();
        }

        public CharSequence selectHeadLines(int lines) {
            this.contentPos = 0;
            while (lines > 0 && this.contentPos < this.contentEnd) {
                this.findEndOfLine();
                --lines;
            }
            return this.content.subSequence(0, this.contentPos);
        }

        public String[] split() {
            ArrayList<String> result = new ArrayList<String>();
            this.contentPos = 0;
            while (this.contentPos < this.contentEnd) {
                int begin = this.contentPos;
                int end = this.findEndOfLine();
                result.add(this.content.subSequence(begin, end).toString());
            }
            return result.toArray(new String[result.size()]);
        }

        public String[] split(int lines) {
            ArrayList<String> result = new ArrayList<String>(lines);
            this.contentPos = 0;
            while (lines > 0 && this.contentPos < this.contentEnd) {
                int begin = this.contentPos;
                int end = this.findEndOfLine();
                result.add(this.content.subSequence(begin, end).toString());
                --lines;
            }
            return result.toArray(new String[result.size()]);
        }

        public int countLines() {
            this.contentPos = 0;
            int count = 0;
            while (this.contentPos < this.contentEnd) {
                this.findEndOfLine();
                ++count;
            }
            return count;
        }

        protected final int findEndOfLine() {
            while (this.contentPos < this.contentEnd) {
                char charAt1 = this.content.charAt(this.contentPos);
                if (charAt1 == '\r') {
                    int endLine = this.contentPos++;
                    if (this.contentPos < this.contentEnd && this.content.charAt(this.contentPos) == '\n') {
                        ++this.contentPos;
                        this.lastLineDelimiter = DELIMITER_WINDOWS;
                    } else {
                        this.lastLineDelimiter = DELIMITER_MAC;
                    }
                    return endLine;
                }
                if (charAt1 == '\n') {
                    int endLine = this.contentPos++;
                    this.lastLineDelimiter = DELIMITER_UNIX;
                    return endLine;
                }
                ++this.contentPos;
            }
            this.lastLineDelimiter = null;
            return this.contentPos;
        }
    }
}

