/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter.ui.preferences;

import com.aptana.core.logging.IdeLog;
import com.aptana.formatter.IScriptFormatter;
import com.aptana.formatter.IScriptFormatterFactory;
import com.aptana.formatter.ui.FormatterException;
import com.aptana.formatter.ui.FormatterSyntaxProblemException;
import com.aptana.formatter.ui.epl.FormatterUIEplPlugin;
import com.aptana.formatter.ui.util.Util;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class FormatterPreviewUtils {
    private static final Pattern SUBSTITUTION_PATTERN = Pattern.compile("\\{\\s*\\d+\\s*\\}");
    private static final String LINE_SEPARATOR = "\n";
    private static final String ENCODING = "ISO-8859-1";

    public static void updatePreview(ISourceViewer viewer, URL previewContent, String[] substitutions, IScriptFormatterFactory factory, Map<String, String> preferences) {
        String content = null;
        if (previewContent != null) {
            try {
                String c = new String(Util.getInputStreamAsCharArray(previewContent.openConnection().getInputStream(), -1, ENCODING));
                content = Util.concatenate(Util.splitLines(c), LINE_SEPARATOR);
                if (content != null && substitutions != null && substitutions.length > 0) {
                    content = FormatterPreviewUtils.substitute(content, substitutions);
                }
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)FormatterUIEplPlugin.getDefault(), (Throwable)e, (String)"com.aptana.formatter.epl/debug");
                FormatterPreviewUtils.disablePreview(viewer);
                return;
            }
        }
        FormatterPreviewUtils.updatePreview(viewer, content, substitutions, factory, preferences);
    }

    public static void updatePreview(ISourceViewer viewer, String previewContent, String[] substitutions, IScriptFormatterFactory factory, Map<String, String> preferences) {
        if (previewContent != null) {
            String content = FormatterPreviewUtils.substitute(previewContent, substitutions);
            IScriptFormatter formatter = factory.createFormatter(LINE_SEPARATOR, preferences);
            int tabSize = formatter.getTabSize();
            String indentType = formatter.getIndentType();
            if ("editor".equals(indentType)) {
                tabSize = formatter.getEditorSpecificTabWidth();
            }
            if (tabSize != viewer.getTextWidget().getTabs()) {
                viewer.getTextWidget().setTabs(tabSize);
            }
            viewer.getTextWidget().setEnabled(true);
            try {
                TextEdit textEdit = formatter.format(content, 0, content.length(), 0, false, null, "");
                if (textEdit != null) {
                    Document document = new Document(content);
                    textEdit.apply((IDocument)document);
                    viewer.getDocument().set(document.get());
                    return;
                }
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)FormatterUIEplPlugin.getDefault(), (Throwable)e, (String)"com.aptana.formatter.epl/debug");
            }
            catch (MalformedTreeException e) {
                IdeLog.logError((Plugin)FormatterUIEplPlugin.getDefault(), (Throwable)e, (String)"com.aptana.formatter.epl/debug");
            }
            catch (FormatterSyntaxProblemException formatterSyntaxProblemException) {
            }
            catch (FormatterException e) {
                IdeLog.logError((Plugin)FormatterUIEplPlugin.getDefault(), (Throwable)e, (String)"com.aptana.formatter.epl/debug");
            }
            viewer.getDocument().set(content);
        } else {
            FormatterPreviewUtils.disablePreview(viewer);
        }
    }

    private static void disablePreview(ISourceViewer viewer) {
        viewer.getTextWidget().setEnabled(false);
        viewer.getDocument().set("");
    }

    private static String substitute(String content, String[] substitutions) {
        StringBuilder buffer = new StringBuilder(content);
        Matcher matcher = SUBSTITUTION_PATTERN.matcher(content);
        int offset = 0;
        while (matcher.find()) {
            int endIndex;
            MatchResult matchResult = matcher.toMatchResult();
            int beginIndex = matchResult.start();
            int index = Integer.parseInt(content.substring(beginIndex + 1, (endIndex = matchResult.end()) - 1));
            if (index < 0 || index >= substitutions.length) continue;
            String replacement = substitutions[index];
            int matchLength = endIndex - beginIndex;
            buffer.replace(offset + beginIndex, offset + endIndex, replacement);
            offset += replacement.length() - matchLength;
        }
        return buffer.toString();
    }
}

