/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter.ui.preferences;

import com.aptana.editor.dtd.text.rules.DTDNameDetector;
import com.aptana.formatter.ui.preferences.Messages;
import com.aptana.formatter.ui.widgets.CListViewer;
import java.util.HashSet;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class AddRemoveList
implements Listener {
    private CListViewer listViewer;
    private Composite control;
    private Button addButton;
    private Button removeButton;
    private ListContentProvider contentProvider;

    public AddRemoveList(Composite parent) {
        this.createContents(parent);
    }

    public Control getControl() {
        return this.control;
    }

    public CListViewer getList() {
        return this.listViewer;
    }

    protected void createContents(Composite parent) {
        this.control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.control.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        this.control.setLayoutData((Object)data);
        this.listViewer = new CListViewer(this.control, 68098);
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddRemoveList.this.updateButtonsState();
            }
        });
        this.contentProvider = new ListContentProvider();
        this.listViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.listViewer.setComparator(new ViewerComparator());
        data = new GridData(1808);
        data.heightHint = 300;
        this.listViewer.getControl().setLayoutData((Object)data);
        Composite groupComponent = new Composite(this.control, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.marginWidth = 0;
        groupLayout.marginHeight = 0;
        groupComponent.setLayout((Layout)groupLayout);
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        groupComponent.setLayoutData((Object)data);
        this.addButton = new Button(groupComponent, 8);
        this.addButton.setText(Messages.AddRemoveList_add);
        this.addButton.addListener(13, (Listener)this);
        this.addButton.setLayoutData((Object)data);
        this.setButtonLayoutData(this.addButton);
        this.removeButton = new Button(groupComponent, 8);
        this.removeButton.setText(Messages.AddRemoveList_remove);
        this.removeButton.addListener(13, (Listener)this);
        this.setButtonLayoutData(this.removeButton);
        Label label = new Label(this.control, 16384);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.updateButtonsState();
    }

    public void handleEvent(Event event) {
        if (event.widget == this.addButton) {
            this.promptForNewElements();
        } else if (event.widget == this.removeButton) {
            this.removeSelectedElements();
        }
        this.updateButtonsState();
    }

    protected void updateButtonsState() {
        boolean elementSelected = this.listViewer.getList().getSelectionIndex() != -1;
        this.removeButton.setEnabled(elementSelected);
    }

    protected void promptForNewElements() {
        IInputValidator inputValidator = new IInputValidator(){

            public String isValid(String newText) {
                String[] inputWords;
                DTDNameDetector dtdDetector = new DTDNameDetector();
                String[] stringArray = inputWords = newText.split(" |,");
                int n = inputWords.length;
                int n2 = 0;
                while (n2 < n) {
                    String word = stringArray[n2];
                    int length = word.length();
                    int i = 0;
                    while (i < length) {
                        char c = word.charAt(i);
                        if (i == 0) {
                            if (!dtdDetector.isWordStart(c)) {
                                return NLS.bind((String)Messages.AddRemoveList_invalidBeginTagChar, (Object)word);
                            }
                        } else if (!dtdDetector.isWordPart(c)) {
                            return NLS.bind((String)Messages.AddRemoveList_invalidCharInTag, (Object)word);
                        }
                        ++i;
                    }
                    ++n2;
                }
                return null;
            }
        };
        InputDialog dialog = new InputDialog(this.listViewer.getList().getShell(), Messages.AddRemoveList_inputMessageTitle, Messages.AddRemoveList_inputMessageText, "", inputValidator);
        if (dialog.open() == 0) {
            Object[] existingElements;
            String value = dialog.getValue().trim();
            if (value.length() == 0) {
                return;
            }
            value = value.replaceAll(",", " ");
            String[] values = value.split(" ");
            TreeSet<Object> elementsSet = new TreeSet<Object>();
            Object[] objectArray = existingElements = this.contentProvider.getElements(null);
            int n = existingElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                elementsSet.add(o);
                ++n2;
            }
            objectArray = values;
            n = values.length;
            n2 = 0;
            while (n2 < n) {
                Object v = objectArray[n2];
                if (((String)v).trim().length() != 0) {
                    elementsSet.add(((String)v).toLowerCase());
                }
                ++n2;
            }
            this.listViewer.setInput(elementsSet.toArray(new Object[elementsSet.size()]));
        }
    }

    protected void removeSelectedElements() {
        Object[] removedElements;
        Object[] existingElements;
        HashSet<Object> elementsSet = new HashSet<Object>();
        Object[] objectArray = existingElements = this.contentProvider.getElements(null);
        int n = existingElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            elementsSet.add(o);
            ++n2;
        }
        Object[] objectArray2 = removedElements = ((IStructuredSelection)this.listViewer.getSelection()).toArray();
        int n3 = removedElements.length;
        n = 0;
        while (n < n3) {
            Object o = objectArray2[n];
            elementsSet.remove(o);
            ++n;
        }
        if (elementsSet.size() != existingElements.length) {
            this.listViewer.setInput(elementsSet.toArray(new Object[elementsSet.size()]));
        }
    }

    protected GridData setButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)data);
        return data;
    }

    private class ListContentProvider
    implements IStructuredContentProvider {
        private String[] elements = new String[0];

        private ListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.elements;
        }

        public void dispose() {
            this.elements = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof Object[]) {
                Object[] in = (Object[])newInput;
                this.elements = new String[in.length];
                int i = 0;
                while (i < in.length) {
                    String value;
                    this.elements[i] = value = in[i].toString().toLowerCase();
                    ++i;
                }
            } else if (newInput != null) {
                String str = newInput.toString().toLowerCase();
                this.elements = str.split("!");
            } else {
                this.elements = new String[0];
            }
        }
    }
}

