/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter.ui.preferences;

import com.aptana.formatter.preferences.IFieldValidator;
import com.aptana.formatter.ui.IFormatterControlManager;
import com.aptana.formatter.ui.IFormatterModifyDialog;
import com.aptana.formatter.ui.preferences.FormatterModifyTabPage;
import com.aptana.formatter.ui.preferences.Messages;
import com.aptana.formatter.ui.util.SWTFactory;
import com.aptana.formatter.ui.util.StatusInfo;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractFormatterOffOnPage
extends FormatterModifyTabPage {
    private Button onOffButton;
    private Text onText;
    private Text offText;

    public AbstractFormatterOffOnPage(IFormatterModifyDialog dialog) {
        super(dialog);
    }

    @Override
    protected void createOptions(IFormatterControlManager manager, Composite parent) {
        Composite composite = SWTFactory.createComposite(parent, parent.getFont(), 1, 1, 768);
        Label infoLabel = new Label(composite, 64);
        infoLabel.setText(Messages.FormatterOnOffPage_formatterOffOnInfo);
        new Label(composite, 0);
        this.onOffButton = manager.createCheckbox(composite, (Object)this.getOffOnEnablementKey(), Messages.FormatterOnOffPage_formatterEnableOffOn);
        Composite indentedComposite = SWTFactory.createComposite(composite, parent.getFont(), 2, 1, 768, 20, 5);
        EmptyTextValidator validator = new EmptyTextValidator();
        this.offText = manager.createText(indentedComposite, (Object)this.getOffTextIdentifierKey(), Messages.FormatterOnOffPage_formatterOffTag, (IFieldValidator)validator);
        this.onText = manager.createText(indentedComposite, (Object)this.getOnTextIdentifierKey(), Messages.FormatterOnOffPage_formatterOnTag, (IFieldValidator)validator);
        new OnOffOptionHandler(manager);
    }

    protected abstract String getOffOnEnablementKey();

    protected abstract String getOffTextIdentifierKey();

    protected abstract String getOnTextIdentifierKey();

    @Override
    protected String[] getSubstitutionStrings() {
        return new String[]{this.offText.getText(), this.onText.getText()};
    }

    private class EmptyTextValidator
    implements IFieldValidator {
        private EmptyTextValidator() {
        }

        public IStatus validate(String text) {
            StatusInfo status = new StatusInfo();
            if (AbstractFormatterOffOnPage.this.onOffButton.getSelection() && text.trim().length() == 0) {
                status.setError(Messages.FieldIsEmpty);
            }
            return status;
        }
    }

    private class OnOffOptionHandler
    extends SelectionAdapter
    implements IFormatterControlManager.IInitializeListener {
        private IFormatterControlManager manager;

        public OnOffOptionHandler(IFormatterControlManager controlManager) {
            this.manager = controlManager;
            AbstractFormatterOffOnPage.this.onOffButton.addSelectionListener((SelectionListener)this);
            this.manager.addInitializeListener((IFormatterControlManager.IInitializeListener)this);
        }

        public void widgetSelected(SelectionEvent e) {
            this.update();
        }

        public void initialize() {
            this.update();
        }

        private void update() {
            boolean selection = AbstractFormatterOffOnPage.this.onOffButton.getSelection();
            this.manager.enableControl((Control)AbstractFormatterOffOnPage.this.onText, selection);
            this.manager.enableControl((Control)AbstractFormatterOffOnPage.this.offText, selection);
        }
    }
}

