/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.stats.core.api;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.pandora.stats.core.Activator;
import com.pandora.stats.core.api.Messages;
import com.pandora.stats.core.dto.ExceptionInfo;
import com.pandora.stats.core.dto.LoginInfo;
import com.pandora.stats.core.dto.OperateInfo;
import com.pandora.stats.core.exception.UploadFailedException;
import com.pandora.stats.core.manage.StatsInfoManage;
import org.eclipse.core.runtime.Plugin;

public class Stats {
    public static final String CATEGORY_PROJECT = "project";
    public static final String CATEGORY_FILE = "file";
    public static final String CATEGORY_TEMPLATE = "template";
    public static final String CATEGORY_MENU = "menu";

    public static void addOperateInfo(String category, String target, String desc) {
        if (StringUtil.isEmpty((String)category) || StringUtil.isEmpty((String)target)) {
            return;
        }
        OperateInfo info = new OperateInfo(category, target, desc);
        StatsInfoManage.instance().recordOperate(info);
        IdeLog.logInfo((Plugin)Activator.getDefault(), (String)(String.valueOf(Messages.Stats_4) + info.toString()));
    }

    @Deprecated
    public static void addOperateInfo(String category, String action, String target, String desc) {
        Stats.addOperateInfo(category, target, desc);
    }

    public static void addLoginInfo(String username) {
        LoginInfo loginInfo = new LoginInfo(username);
        StatsInfoManage.instance().recordLoginInfo(loginInfo);
    }

    public static void addExceptionInfo(String exceptionName, String className, String lineNum, String detail) {
        if (StringUtil.isEmpty((String)exceptionName) || StringUtil.isEmail((String)detail)) {
            return;
        }
        ExceptionInfo info = new ExceptionInfo(exceptionName, className, lineNum, detail);
        StatsInfoManage.instance().recordException(info);
        IdeLog.logInfo((Plugin)Activator.getDefault(), (String)(String.valueOf(Messages.Stats_5) + info.toString()));
    }

    public static void addExceptionInfo(Throwable e) {
        if (e == null || e instanceof UploadFailedException) {
            return;
        }
        String exceptionName = e.getClass().getName();
        StackTraceElement[] elements = e.getStackTrace();
        StringBuffer excetionDetail = new StringBuffer();
        if (elements.length == 0) {
            return;
        }
        StackTraceElement occurElement = elements[0];
        String className = occurElement.getClassName();
        String lineNum = String.valueOf(occurElement.getLineNumber());
        excetionDetail.append(String.valueOf(exceptionName) + ":" + e.getMessage());
        StackTraceElement[] stackTraceElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement el = stackTraceElementArray[n2];
            excetionDetail.append("\n\r\tat " + el.toString());
            ++n2;
        }
        Stats.addExceptionInfo(exceptionName, className, lineNum, excetionDetail.toString());
    }
}

