/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.stats.core;

import com.pandora.stats.core.api.Stats;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DefaultIDEListenter
implements IStartup,
IResourceChangeListener,
IResourceDeltaVisitor {
    private Map<String, String> projectMap = new HashMap<String, String>();
    private final IPartListener fPartListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };

    public DefaultIDEListenter() {
        this.projectMap.put("org.eclipse.jdt.core.javanature", "NPJ");
        this.projectMap.put("com.pandora.projects.ui.MKeyNature", "NPH");
        this.projectMap.put("com.aptana.editor.php.phpNature", "NPP");
        this.projectMap.put("com.aptana.projects.webnature", "NPW");
    }

    public void earlyStartup() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DefaultIDEListenter.this.addIDEListener();
            }
        });
    }

    public void addIDEListener() {
        try {
            this.addResourceListener();
            this.addPartListener();
        }
        catch (Exception e) {
            Stats.addExceptionInfo(e);
        }
    }

    protected void addResourceListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 7);
    }

    private void addPartListener() {
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null) {
                IWorkbenchWindow[] windows;
                IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
                int n = windows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IPartService partService = window.getPartService();
                    if (partService != null) {
                        partService.addPartListener(this.fPartListener);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {}
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            if (event.getDelta() != null) {
                event.getDelta().accept((IResourceDeltaVisitor)this);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        switch (delta.getKind()) {
            case 1: {
                this.handleResourceAdded(delta.getResource());
                break;
            }
        }
        return true;
    }

    private void handleResourceAdded(IResource res) throws CoreException {
        if (res == null) {
            return;
        }
        if (res instanceof IProject) {
            String[] natureIds;
            IProject p = (IProject)res;
            IProjectDescription desc = p.getDescription();
            String natureId = null;
            if (desc != null && (natureIds = p.getDescription().getNatureIds()).length > 0) {
                natureId = natureIds[0];
            }
            if (natureId != null) {
                Stats.addOperateInfo("project", this.projectMap.get(natureId) == null ? "NPA" : this.projectMap.get(natureId), natureId);
            } else {
                Stats.addOperateInfo("project", "NPA", natureId);
            }
        } else {
            boolean cfr_ignored_0 = res instanceof IFile;
        }
    }
}

