/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.view.browser.views;

import com.pandora.cef3.CEF3Browser;
import com.pandora.cef3.listener.ConsoleMessageEvent;
import com.pandora.cef3.listener.ConsoleMessageListener;
import com.pandora.core.log.HBLog;
import com.pandora.core.utils.Activator;
import com.pandora.core.utils.ResourceUtil;
import com.pandora.view.browser.console.WebConsole;
import com.pandora.view.browser.console.WebConsoleFactory;
import com.pandora.view.browser.views.BrowserComposite;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.part.ViewPart;

public class WebBrowserView
extends ViewPart {
    public static final String VIEW_ID = "com.pandora.view.browser.view.WebBrowserView";
    private BrowserComposite browserComposite;

    public void createPartControl(Composite parent) {
        this.browserComposite = new BrowserComposite(parent, 0);
        Control browser = this.browserComposite.getBrowser();
        this.browserComposite.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event) {
                WebBrowserView.this.setTitleToolTip(event.title);
            }
        });
        this.browserComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IPerspectiveDescriptor web;
                IPerspectiveDescriptor pd;
                IWorkbenchPage page;
                IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (win != null && (page = win.getActivePage()) != null && (pd = page.getPerspective()) != null && "com.aptana.ui.RealTimePerspective".equals(pd.getId()) && (web = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId("com.aptana.ui.WebPerspective")) != null) {
                    page.setPerspective(web);
                }
            }
        });
        if (browser instanceof CEF3Browser) {
            ((CEF3Browser)browser).addConsoleMessageListener(new ConsoleMessageListener(){

                public void onConsoleMessage(ConsoleMessageEvent event) {
                    try {
                        WebConsole messageConsole;
                        boolean isApplicationConsoleShow = false;
                        IConsole[] consles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
                        if (consles != null && consles.length > 0) {
                            IConsole[] iConsoleArray = consles;
                            int n = consles.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IConsole console = iConsoleArray[n2];
                                if (console.getName().contains(" [HBuilder Application] ")) {
                                    isApplicationConsoleShow = true;
                                    break;
                                }
                                ++n2;
                            }
                        }
                        WebConsoleFactory webConsoleFactory = new WebConsoleFactory();
                        if (!isApplicationConsoleShow) {
                            webConsoleFactory.openConsole();
                        }
                        if ((messageConsole = webConsoleFactory.getConsole(true, !isApplicationConsoleShow)) != null) {
                            URI source = new URI(event.source);
                            IFile file = ResourceUtil.getIFileFromURL((URI)source);
                            String path = file != null && file.exists() ? source.getPath() : event.source;
                            String format = "[%s] \"%s\"\t%s (%d)";
                            String msg = String.format(format, WebBrowserView.this.getPartName(), event.message, path, event.line);
                            if (event.message.startsWith("Uncaught ") && !messageConsole.getErrorConsoleStream().isClosed()) {
                                messageConsole.getErrorConsoleStream().println(msg);
                            } else if (!messageConsole.getOutputConsoleStream().isClosed()) {
                                messageConsole.getOutputConsoleStream().println(msg);
                            }
                        }
                    }
                    catch (Throwable e) {
                        HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
                    }
                }
            });
        }
    }

    public void setFocus() {
        this.browserComposite.setFocus();
    }

    private IProgressMonitor getProgressMonitor() {
        IStatusLineManager statusManager = this.getViewSite().getActionBars().getStatusLineManager();
        return statusManager.getProgressMonitor();
    }

    public BrowserComposite getWebBrowserViewer() {
        return this.browserComposite;
    }

    public void setURL(String url) {
        this.browserComposite.setURL(url);
    }

    public void dispose() {
        this.getProgressMonitor().done();
        super.dispose();
    }
}

