/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.view.browser.preferences;

import com.pandora.view.browser.BrowserActivator;
import com.pandora.view.browser.preferences.BrowserScreenSize;
import com.pandora.view.browser.preferences.BrowserScreenSizeDialog;
import com.pandora.view.browser.preferences.BrowserScreenSizeManager;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public final class BrowserSizePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "com.pandora.view.browser.preferences.BrowserSizePreferencePage";
    private ListViewer viewer;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        this.viewer = new ListViewer(composite, 2052);
        this.viewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof BrowserScreenSizeManager) {
                    List<BrowserScreenSize> all = ((BrowserScreenSizeManager)((Object)inputElement)).getAllBrowserScreenSize();
                    Collections.sort(all);
                    inputElement = all;
                }
                return super.getElements((Object)inputElement);
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof BrowserScreenSize) {
                    return ((BrowserScreenSize)element).toString();
                }
                return super.getText(element);
            }
        });
        this.viewer.setInput((Object)BrowserScreenSizeManager.getInstance());
        Composite buttonContainer = new Composite(composite, 0);
        buttonContainer.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
        buttonContainer.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        Button newButton = new Button(buttonContainer, 8);
        newButton.setText("\u65b0\u5efa(&N)");
        newButton.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).hint(Math.max(newButton.computeSize((int)-1, (int)-1, (boolean)true).x, this.convertHorizontalDLUsToPixels(61)), -1).create());
        final Button editButton = new Button(buttonContainer, 8);
        editButton.setText("\u7f16\u8f91(&E)");
        editButton.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).create());
        final Button deleteButton = new Button(buttonContainer, 8);
        deleteButton.setText("\u5220\u9664(&D)");
        deleteButton.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).create());
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BrowserScreenSize browserScreenSize = BrowserSizePreferencePage.this.editServerConfiguration(null);
                if (browserScreenSize != null) {
                    BrowserScreenSizeManager.getInstance().addBrowserScreenSize(browserScreenSize);
                    BrowserSizePreferencePage.this.viewer.refresh();
                }
            }
        });
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserScreenSize selection = (BrowserScreenSize)((IStructuredSelection)BrowserSizePreferencePage.this.viewer.getSelection()).getFirstElement();
                if (selection != null && BrowserSizePreferencePage.this.editServerConfiguration(selection) != null) {
                    BrowserSizePreferencePage.this.viewer.refresh();
                }
            }
        });
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserScreenSize selection = (BrowserScreenSize)((IStructuredSelection)BrowserSizePreferencePage.this.viewer.getSelection()).getFirstElement();
                if (selection != null && MessageDialog.openQuestion((Shell)BrowserSizePreferencePage.this.getShell(), (String)"\u5220\u9664\u786e\u8ba4", (String)"\u5c06\u6c38\u4e45\u5220\u9664\u6240\u9009\u7684\u914d\u7f6e\uff0c\u786e\u8ba4\u8981\u7ee7\u7eed\u5417\uff1f")) {
                    BrowserScreenSizeManager.getInstance().removeBrowserScreenSize(selection);
                    BrowserSizePreferencePage.this.viewer.refresh();
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                BrowserScreenSize selection = (BrowserScreenSize)((IStructuredSelection)BrowserSizePreferencePage.this.viewer.getSelection()).getFirstElement();
                if (selection != null && BrowserSizePreferencePage.this.editServerConfiguration(selection) != null) {
                    BrowserSizePreferencePage.this.viewer.refresh();
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    BrowserScreenSize selection = (BrowserScreenSize)((IStructuredSelection)BrowserSizePreferencePage.this.viewer.getSelection()).getFirstElement();
                    editButton.setEnabled(true);
                    deleteButton.setEnabled(selection.getPriority() <= 0);
                } else {
                    editButton.setEnabled(false);
                    deleteButton.setEnabled(false);
                }
            }
        });
        this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        return composite;
    }

    private BrowserScreenSize editServerConfiguration(BrowserScreenSize serverConfiguration) {
        BrowserScreenSizeDialog dialog = new BrowserScreenSizeDialog(this.getShell(), serverConfiguration);
        if (dialog.open() == 0) {
            return dialog.getResult();
        }
        return null;
    }

    public void init(IWorkbench workbench) {
        this.setDescription(this.getTitleDescription());
        this.noDefaultAndApplyButton();
    }

    public boolean performOk() {
        return super.performOk();
    }

    protected String getTitleDescription() {
        return "\u914d\u7f6e\u8fb9\u6539\u8fb9\u770b\u6d4f\u89c8\u5668\u5bbd\u9ad8\u3002";
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return BrowserActivator.getDefault().getPreferenceStore();
    }
}

