/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.view.browser.preferences;

import com.pandora.core.log.HBLog;
import com.pandora.view.browser.BrowserActivator;
import com.pandora.view.browser.preferences.BrowserScreenSize;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.osgi.framework.Bundle;

public class BrowserScreenSizeManager {
    public static final String STATE_FILENAME = "screensizes";
    public static final String DEFAULT_FILENAME = "config/default_screensizes.xml";
    private static final String ELEMENT_ROOT = "screensizes";
    private static final String ELEMENT_SIZE = "screensize";
    private static BrowserScreenSizeManager instance;
    private List<BrowserScreenSize> allScrrenSizeCommands = new ArrayList<BrowserScreenSize>();

    private BrowserScreenSizeManager() {
    }

    public static BrowserScreenSizeManager getInstance() {
        if (instance == null) {
            instance = new BrowserScreenSizeManager();
        }
        return instance;
    }

    public List<BrowserScreenSize> getAllBrowserScreenSize() {
        return this.allScrrenSizeCommands;
    }

    public void addBrowserScreenSize(BrowserScreenSize browserScreenSize) {
        if (!this.allScrrenSizeCommands.contains(browserScreenSize)) {
            this.allScrrenSizeCommands.remove(browserScreenSize);
        }
        this.allScrrenSizeCommands.add(browserScreenSize);
    }

    public void removeBrowserScreenSize(BrowserScreenSize browserScreenSize) {
        this.allScrrenSizeCommands.remove(browserScreenSize);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadState(IPath path) {
        File file = path.toFile();
        if (!file.exists()) return;
        FileReader reader = null;
        try {
            try {
                reader = new FileReader(file);
                XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                IMemento[] iMementoArray = memento.getChildren(ELEMENT_SIZE);
                int n = iMementoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento child = iMementoArray[n2];
                    this.allScrrenSizeCommands.add(new BrowserScreenSize(child));
                    ++n2;
                }
                return;
            }
            catch (IOException e) {
                HBLog.logError((Plugin)BrowserActivator.getDefault(), (Throwable)e);
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException e2) {
                    HBLog.logError((Plugin)BrowserActivator.getDefault(), (Throwable)e2);
                }
                return;
            }
            catch (CoreException e) {
                HBLog.logError((Plugin)BrowserActivator.getDefault(), (Throwable)e);
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException e3) {
                    HBLog.logError((Plugin)BrowserActivator.getDefault(), (Throwable)e3);
                }
                return;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    HBLog.logError((Plugin)BrowserActivator.getDefault(), (Throwable)e);
                }
            }
        }
    }

    public void saveState(IPath path) {
        block13: {
            XMLMemento memento = XMLMemento.createWriteRoot((String)"screensizes");
            for (BrowserScreenSize externalCommand : this.allScrrenSizeCommands) {
                IMemento child = memento.createChild(ELEMENT_SIZE);
                externalCommand.saveState(child);
            }
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(path.toFile());
                    memento.save((Writer)writer);
                }
                catch (IOException e) {
                    HBLog.logError((Plugin)BrowserActivator.getDefault(), (Throwable)e);
                    if (writer == null) break block13;
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        HBLog.logError((Plugin)BrowserActivator.getDefault(), (Throwable)e2);
                    }
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        HBLog.logError((Plugin)BrowserActivator.getDefault(), (Throwable)e);
                    }
                }
            }
        }
    }

    public void resetToDefault() {
        try {
            this.allScrrenSizeCommands.clear();
            URL url = FileLocator.find((Bundle)BrowserActivator.getDefault().getBundle(), (IPath)new Path(DEFAULT_FILENAME), null);
            this.loadState((IPath)new Path(FileLocator.toFileURL((URL)url).getFile()));
        }
        catch (IOException e) {
            HBLog.logError((Plugin)BrowserActivator.getDefault(), (Throwable)e);
        }
    }
}

