/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.view.browser.preferences;

import com.pandora.core.utils.StringUtil;
import com.pandora.view.browser.preferences.BrowserScreenSize;
import com.pandora.view.browser.preferences.BrowserScreenSizeManager;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class BrowserScreenSizeDialog
extends TitleAreaDialog {
    private Text scrrenNameText;
    private Text scrrenWidthText;
    private Text scrrenHeightText;
    private BrowserScreenSize size;
    private boolean showLink;

    public BrowserScreenSizeDialog(Shell parentShell, boolean showLink) {
        super(parentShell);
        this.setHelpAvailable(false);
        this.showLink = showLink;
    }

    protected BrowserScreenSizeDialog(Shell parentShell, BrowserScreenSize size) {
        super(parentShell);
        this.setHelpAvailable(false);
        this.size = size;
    }

    private void check() {
        String message = null;
        String nameText = this.scrrenNameText.getText();
        String widthText = this.scrrenWidthText.getText();
        String heightText = this.scrrenHeightText.getText();
        if (StringUtil.isBlank((String)nameText)) {
            message = "\u8bf7\u586b\u5199\u540d\u79f0";
        }
        if (message == null) {
            if (widthText.trim().length() == 0) {
                message = "\u8bf7\u6307\u5b9a\u4e00\u4e2a\u6b63\u6574\u6570\u7684\u6d4f\u89c8\u5668\u7684\u5bbd\u5ea6";
            } else {
                try {
                    int width = Integer.parseInt(widthText);
                    if (width <= 0) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    message = "\u8bf7\u6307\u5b9a\u4e00\u4e2a\u6b63\u6574\u6570\u7684\u6d4f\u89c8\u5668\u7684\u5bbd\u5ea6";
                }
            }
        }
        if (message == null) {
            if (heightText.trim().length() == 0) {
                message = "\u8bf7\u6307\u5b9a\u4e00\u4e2a\u6b63\u6574\u6570\u7684\u9ad8\u5ea6";
            } else {
                try {
                    int height = Integer.parseInt(heightText);
                    if (height <= 0) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    message = "\u8bf7\u6307\u5b9a\u4e00\u4e2a\u6b63\u6574\u6570\u7684\u9ad8\u5ea6";
                }
            }
        }
        if (message == null) {
            List<BrowserScreenSize> all = BrowserScreenSizeManager.getInstance().getAllBrowserScreenSize();
            for (BrowserScreenSize browserScreenSize : all) {
                if (this.size == browserScreenSize) continue;
                if (browserScreenSize.getName().equals(nameText)) {
                    message = "\u5df2\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u81ea\u5b9a\u4e49\u5bbd\u9ad8\u914d\u7f6e\uff0c\u8bf7\u66f4\u6362\u540d\u79f0";
                    break;
                }
                if (browserScreenSize.getSize().x != Integer.parseInt(widthText) || browserScreenSize.getSize().y != Integer.parseInt(heightText)) continue;
                message = "\u5df2\u5b58\u5728\u76f8\u540c\u5bbd\u9ad8\u7684\u81ea\u5b9a\u4e49\u5bbd\u9ad8\u914d\u7f6e\uff0c\u8bf7\u66f4\u6362\u5bbd\u5ea6\u6216\u9ad8\u5ea6";
                break;
            }
        }
        this.setErrorMessage(message);
        this.getButton(0).setEnabled(message == null);
    }

    protected void okPressed() {
        if (this.size == null) {
            this.size = new BrowserScreenSize(this.scrrenNameText.getText(), new Point(Integer.parseInt(this.scrrenWidthText.getText()), Integer.parseInt(this.scrrenHeightText.getText())));
        } else {
            this.size.setName(this.scrrenNameText.getText());
            this.size.getSize().x = Integer.parseInt(this.scrrenWidthText.getText());
            this.size.getSize().y = Integer.parseInt(this.scrrenHeightText.getText());
        }
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("\u81ea\u5b9a\u4e49\u5bbd\u9ad8");
        this.setMessage("\u8bbe\u7f6e\u8fb9\u6539\u8fb9\u770b\u6d4f\u89c8\u5668\u81ea\u5b9a\u4e49\u5bbd\u9ad8");
        Composite composite = new Composite(parent, 2048);
        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(10, 10).spacing(5, 10).numColumns(2).create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("\u540d\u79f0: ");
        this.scrrenNameText = new Text(composite, 2052);
        this.scrrenNameText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Label widthLabel = new Label(composite, 0);
        widthLabel.setText("\u5bbd\u5ea6: ");
        this.scrrenWidthText = new Text(composite, 2052);
        this.scrrenWidthText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Label heightLabel = new Label(composite, 0);
        heightLabel.setText("\u9ad8\u5ea6: ");
        this.scrrenHeightText = new Text(composite, 2052);
        this.scrrenHeightText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        if (this.showLink) {
            new Label(composite, 0).setLayoutData((Object)GridDataFactory.fillDefaults().hint(-1, 0).span(2, 1).create());
            Link link = new Link(composite, 0);
            link.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).align(0x1000008, 0x1000000).grab(true, false).create());
            link.setText("<a>\u7ba1\u7406\u6d4f\u89c8\u5668\u5bbd\u9ad8\u8bbe\u7f6e</a>");
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BrowserScreenSizeDialog.this.close();
                    PreferenceDialog p = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"com.pandora.view.browser.preferences.BrowserSizePreferencePage", (String[])new String[]{"com.pandora.view.browser.preferences.BrowserSizePreferencePage"}, null);
                    p.open();
                }
            });
        }
        if (this.size != null) {
            this.scrrenNameText.setText(this.size.getName());
            if (this.size.getPriority() > 0) {
                this.scrrenNameText.setEnabled(false);
            }
            this.scrrenWidthText.setText(String.valueOf(this.size.getSize().x));
            this.scrrenHeightText.setText(String.valueOf(this.size.getSize().y));
        }
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BrowserScreenSizeDialog.this.check();
            }
        };
        this.scrrenNameText.addModifyListener(modifyListener);
        this.scrrenWidthText.addModifyListener(modifyListener);
        this.scrrenHeightText.addModifyListener(modifyListener);
        return composite;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.check();
        return control;
    }

    public BrowserScreenSize getResult() {
        return this.size;
    }
}

