/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.view.browser.preferences;

import com.pandora.core.utils.StringUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IMemento;

public class BrowserScreenSize
implements Comparable<BrowserScreenSize> {
    protected static final String ELEMENT_ID = "id";
    protected static final String ELEMENT_WIDTH = "width";
    protected static final String ELEMENT_HEIGHT = "height";
    protected static final String ELEMENT_PRIORITY = "priority";
    private String name;
    private Point size;
    private int priority;

    public BrowserScreenSize(String name, Point sieze) {
        this.name = name;
        this.size = sieze;
    }

    public BrowserScreenSize(IMemento child) {
        this.loadState(child);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Point getSize() {
        return this.size;
    }

    public void setSize(Point size) {
        this.size = size;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void loadState(IMemento memento) {
        if (memento != null) {
            this.name = this.getValue(memento, ELEMENT_ID);
            this.size = new Point(0, 0);
            this.size.x = Integer.parseInt(this.getValue(memento, ELEMENT_WIDTH));
            this.size.y = Integer.parseInt(this.getValue(memento, ELEMENT_HEIGHT));
            this.priority = Integer.parseInt(this.getValue(memento, ELEMENT_PRIORITY));
        }
    }

    protected String getValue(IMemento memento, String name) {
        return memento.getString(name);
    }

    public void saveState(IMemento memento) {
        if (memento != null) {
            memento.putString(ELEMENT_ID, this.name);
            memento.putInteger(ELEMENT_WIDTH, this.size.x);
            memento.putInteger(ELEMENT_HEIGHT, this.size.y);
            memento.putInteger(ELEMENT_PRIORITY, this.priority);
        }
    }

    public String toString() {
        if (StringUtil.isBlank((String)this.name)) {
            return String.valueOf(this.size.x) + "x" + this.size.y;
        }
        return String.valueOf(this.size.x) + "x" + this.size.y + "(" + this.name + ")";
    }

    @Override
    public int compareTo(BrowserScreenSize o) {
        if (o == null) {
            return -1;
        }
        if (this.priority > 0 || o.priority > 0) {
            return o.priority - this.priority;
        }
        return this.toString().compareTo(o.toString());
    }
}

