/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.view.browser.console;

import com.pandora.core.log.HBLog;
import com.pandora.core.utils.LocalFileLink;
import com.pandora.core.utils.ResourceUtil;
import com.pandora.view.browser.BrowserActivator;
import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListenerDelegate;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public class WebConsoleTracker
implements IPatternMatchListenerDelegate {
    private TextConsole console;

    public void connect(TextConsole console) {
        this.console = console;
    }

    public void disconnect() {
        this.console = null;
    }

    public void matchFound(PatternMatchEvent event) {
        if (this.console != null) {
            try {
                File file;
                String text = this.console.getDocument().get(event.getOffset(), event.getLength());
                int numIndex = text.lastIndexOf(" (");
                String urlText = text.substring(0, numIndex);
                URI uri = URIUtil.fromString((String)urlText);
                String scheme = uri.getScheme();
                if (scheme == null) {
                    IFile file2 = ResourceUtil.getIFileFromURL((URI)uri);
                    if (file2 != null && file2.exists()) {
                        int line = Integer.parseInt(text.substring(numIndex + 2, text.length() - 1));
                        this.console.addHyperlink((IHyperlink)new FileLink(file2, null, -1, -1, line), event.getOffset(), event.getLength());
                    }
                } else if (scheme.equalsIgnoreCase("file") && (file = new File(uri)).exists()) {
                    int line = Integer.parseInt(text.substring(numIndex + 2, text.length() - 1));
                    this.console.addHyperlink((IHyperlink)new LocalFileLink(file, null, -1, -1, line), event.getOffset(), event.getLength());
                }
            }
            catch (Throwable e) {
                HBLog.logError((Plugin)BrowserActivator.getDefault(), (Throwable)e);
            }
        }
    }
}

