/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.view.browser.console;

import com.pandora.view.browser.BrowserActivator;
import com.pandora.view.browser.console.WebConsoleFactory;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class WebConsole
extends MessageConsole {
    public static final String THEME_CONSOLE_STREAM_TO_COLOR_ATTRIBUTE = "themeConsoleStreamToColor";
    public static final String CONSOLE_ERROR = "console.error";
    public static final String CONSOLE_OUTPUT = "console.output";
    public static final String CONSOLE_INPUT = "console.input";
    public static final String CONSOLE_PROMPT = "console.prompt";
    public static final String CONSOLE_WARNING = "console.warning";
    public static final String CONSOLE_TRACE = "console.prompt";
    public static final String CONSOLE_INFO = "console.input";
    public static final String TYPE = "webConsole";
    private boolean dispose;
    private Map<MessageConsoleStream, String> streamColorMap;
    private MessageConsoleStream outputConsoleStream;
    private MessageConsoleStream errorConsoleStream;
    private MessageConsoleStream infoConsoleStream;
    private MessageConsoleStream warningConsoleStream;
    private MessageConsoleStream traceConsoleStream;

    public WebConsole(WebConsoleFactory factory) {
        super("\u8fb9\u6539\u8fb9\u770b\u63a7\u5236\u53f0", TYPE, BrowserActivator.imageDescriptorFromPlugin((String)"com.pandora.view.browser", (String)"/icons/browser.png"), true);
        this.setAttribute("ATTRIBUTE_NEED_REFLUSH", "true");
        this.setWaterMarks(40000, 80000);
        this.streamColorMap = new HashMap<MessageConsoleStream, String>();
        this.getOutputConsoleStream();
        this.getErrorConsoleStream();
        this.getInfoConsoleStream();
        this.getWarningConsoleStream();
        this.getTraceConsoleStream();
        this.setAttribute(THEME_CONSOLE_STREAM_TO_COLOR_ATTRIBUTE, this.streamColorMap);
    }

    protected void init() {
        super.init();
    }

    protected void dispose() {
        super.dispose();
        this.dispose = true;
    }

    public MessageConsoleStream getErrorConsoleStream() {
        this.errorConsoleStream = this.getConsoleStream(this.errorConsoleStream, CONSOLE_ERROR);
        return this.errorConsoleStream;
    }

    public MessageConsoleStream getInfoConsoleStream() {
        this.infoConsoleStream = this.getConsoleStream(this.infoConsoleStream, "console.input");
        return this.infoConsoleStream;
    }

    public MessageConsoleStream getOutputConsoleStream() {
        this.outputConsoleStream = this.getConsoleStream(this.outputConsoleStream, CONSOLE_OUTPUT);
        return this.outputConsoleStream;
    }

    public MessageConsoleStream getTraceConsoleStream() {
        this.traceConsoleStream = this.getConsoleStream(this.traceConsoleStream, "console.prompt");
        return this.traceConsoleStream;
    }

    public MessageConsoleStream getWarningConsoleStream() {
        this.warningConsoleStream = this.getConsoleStream(this.warningConsoleStream, CONSOLE_WARNING);
        return this.warningConsoleStream;
    }

    public MessageConsoleStream getConsoleStream(final MessageConsoleStream currentStream, String colorKey) {
        if (currentStream == null || currentStream.isClosed()) {
            if (currentStream != null) {
                this.streamColorMap.remove(currentStream);
            }
            final MessageConsoleStream newStream = this.newMessageStream();
            this.streamColorMap.put(newStream, colorKey);
            if (currentStream != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        newStream.setColor(currentStream.getColor());
                        newStream.setFontStyle(currentStream.getFontStyle());
                    }
                });
            }
            return newStream;
        }
        return currentStream;
    }

    public boolean isDispose() {
        return this.dispose;
    }
}

