/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.view.browser;

import com.pandora.core.log.HBLog;
import com.pandora.core.utils.EclipseUtil;
import com.pandora.view.browser.BrowserActivator;
import com.pandora.view.browser.preferences.BrowserScreenSizeManager;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ui.IStartup;
import org.osgi.service.prefs.BackingStoreException;

public class Startup
implements IStartup {
    public void earlyStartup() {
        try {
            IPath location;
            ISavedState lastState;
            IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("com.pandora.view.browser");
            boolean added = prefs.getBoolean("addDefaultBrowserScreenSize", false);
            if (!added) {
                BrowserScreenSizeManager.getInstance().resetToDefault();
                prefs.putBoolean("addDefaultBrowserScreenSize", true);
                try {
                    prefs.flush();
                }
                catch (BackingStoreException e) {
                    HBLog.logError((Plugin)BrowserActivator.getDefault(), (Throwable)e);
                }
            }
            if ((lastState = ResourcesPlugin.getWorkspace().addSaveParticipant("com.pandora.view.browser", (ISaveParticipant)new WorkspaceSaveParticipant())) != null && (location = lastState.lookup((IPath)new Path("screensizes"))) != null) {
                BrowserScreenSizeManager.getInstance().loadState(BrowserActivator.getDefault().getStateLocation().append(location));
            }
        }
        catch (Throwable e) {
            HBLog.logError((Plugin)BrowserActivator.getDefault(), (Throwable)e);
        }
    }

    private class WorkspaceSaveParticipant
    implements ISaveParticipant {
        private WorkspaceSaveParticipant() {
        }

        public void doneSaving(ISaveContext context) {
            IPath prevSavePath = new Path("screensizes").addFileExtension(Integer.toString(context.getPreviousSaveNumber()));
            BrowserActivator.getDefault().getStateLocation().append(prevSavePath).toFile().delete();
        }

        public void prepareToSave(ISaveContext context) throws CoreException {
        }

        public void rollback(ISaveContext context) {
            IPath savePath = new Path("screensizes").addFileExtension(Integer.toString(context.getSaveNumber()));
            BrowserActivator.getDefault().getStateLocation().append(savePath).toFile().delete();
        }

        public void saving(ISaveContext context) throws CoreException {
            IPath savePath = new Path("screensizes").addFileExtension(Integer.toString(context.getSaveNumber()));
            BrowserScreenSizeManager.getInstance().saveState(BrowserActivator.getDefault().getStateLocation().append(savePath));
            context.map((IPath)new Path("screensizes"), savePath);
            context.needSaveNumber();
        }
    }
}

