/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.dynamicpage.jsp.parsing;

import beaver.Scanner;
import beaver.Symbol;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.pandora.editor.dynamicpage.Bundle;
import com.pandora.editor.dynamicpage.DynamicPagesEditorPlugin;
import com.pandora.editor.dynamicpage.jsp.parsing.JSPFlexScanner;
import com.pandora.editor.dynamicpage.sp.parsing.SPCodeScanner;
import java.io.IOException;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class JSPCodeScanner
extends SPCodeScanner {
    public JSPCodeScanner() {
        super(new JSPFlexScanner());
    }

    protected void setSource(String source) {
        ((JSPFlexScanner)this.fScanner).setSource(source);
    }

    protected IToken mapToken(Symbol token) throws IOException, Scanner.Exception {
        switch (token.getId()) {
            case 17: {
                return NULL_TOKEN;
            }
            case 11: 
            case 22: {
                return BOOLEAN_TOKEN;
            }
            case 26: {
                return SEMICOLON_TOKEN;
            }
            case 1024: 
            case 1025: {
                return COMMENT_BLOCK_TOKEN;
            }
            case 1026: {
                return COMMENT_LINE_TOKEN;
            }
            case 44: 
            case 53: 
            case 69: 
            case 77: {
                return STORAGE_MODIFIER_TOKEN;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 25: {
                return CONTROL_KEYWORD_TOKEN;
            }
            case 36: 
            case 38: 
            case 39: 
            case 46: 
            case 49: 
            case 52: 
            case 55: 
            case 58: 
            case 62: 
            case 70: 
            case 71: 
            case 75: 
            case 78: 
            case 85: 
            case 92: {
                return OTHER_KEYWORD_TOKEN;
            }
            case 20: 
            case 24: 
            case 37: 
            case 42: 
            case 45: 
            case 47: 
            case 76: 
            case 79: 
            case 86: 
            case 103: {
                return STORAGE_TYPE_TOKEN;
            }
            case 35: {
                return OPERATOR_KEYWORD_TOKEN;
            }
            case 15: 
            case 16: 
            case 34: 
            case 40: 
            case 41: 
            case 43: 
            case 48: 
            case 50: 
            case 51: 
            case 54: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 72: 
            case 73: 
            case 74: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                return OPERATOR_KEYWORD_TOKEN;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return BRACE_TOKEN;
            }
            case 1: {
                Set<String> completions = Bundle.getCompletions("source.jsp");
                String text = ((JSPFlexScanner)this.fScanner).yytext();
                if (completions != null && completions.contains(text)) {
                    return STORAGE_TYPE_TOKEN;
                }
                if (StringUtil.isNotEmpty((String)text) && Character.isUpperCase(text.charAt(0))) {
                    int length = text.length();
                    int i = 1;
                    while (i < length) {
                        if (Character.isLowerCase(text.charAt(i))) {
                            return STORAGE_TYPE_TOKEN;
                        }
                        ++i;
                    }
                    return CONSTANT_LANGUAGE_TOKEN;
                }
                return IDENTIFIER_TOKEN;
            }
            case 2: {
                return NUMBER_TOKEN;
            }
            case 3: {
                return STRING_TOKEN;
            }
            case 100: {
                return SECTION_BEGIN_TOKEN;
            }
            case 102: {
                return SECTION_END_TOKEN;
            }
            case 0: {
                return Token.EOF;
            }
        }
        String msg = "JSCodeScanner: Token not mapped: " + token.getId() + ">>" + token.value + "<<";
        IdeLog.logWarning((Plugin)DynamicPagesEditorPlugin.getDefault(), (String)msg);
        return UNDEFINED_TOKEN;
    }
}

