/*
 * Decompiled with CFR 0.152.
 */
package org.cef;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import org.cef.OS;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowserFactory;
import org.cef.browser.CefMessageRouter;
import org.cef.browser.CefRequestContext;
import org.cef.callback.CefAllowCertificateErrorCallback;
import org.cef.callback.CefAuthCallback;
import org.cef.callback.CefBeforeDownloadCallback;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefDownloadItem;
import org.cef.callback.CefDownloadItemCallback;
import org.cef.callback.CefDragData;
import org.cef.callback.CefFileDialogCallback;
import org.cef.callback.CefGeolocationCallback;
import org.cef.callback.CefJSDialogCallback;
import org.cef.callback.CefMenuModel;
import org.cef.callback.CefQuotaCallback;
import org.cef.handler.CefClientHandler;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefDialogHandler;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDownloadHandler;
import org.cef.handler.CefDragHandler;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefGeolocationHandler;
import org.cef.handler.CefJSDialogHandler;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefRenderHandler;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefResourceHandler;
import org.cef.misc.BoolRef;
import org.cef.misc.StringRef;
import org.cef.network.CefRequest;
import org.cef.network.CefWebPluginInfo;

public class CefClient
extends CefClientHandler
implements CefContextMenuHandler,
CefDialogHandler,
CefDisplayHandler,
CefDownloadHandler,
CefDragHandler,
CefFocusHandler,
CefGeolocationHandler,
CefJSDialogHandler,
CefKeyboardHandler,
CefLifeSpanHandler,
CefLoadHandler,
CefRenderHandler,
CefRequestHandler {
    private HashMap<Integer, CefBrowser> browser_ = new HashMap();
    private CefContextMenuHandler contextMenuHandler_ = null;
    private CefDialogHandler dialogHandler_ = null;
    private CefDisplayHandler displayHandler_ = null;
    private CefDownloadHandler downloadHandler_ = null;
    private CefDragHandler dragHandler_ = null;
    private CefFocusHandler focusHandler_ = null;
    private CefGeolocationHandler geolocationHandler_ = null;
    private CefJSDialogHandler jsDialogHandler_ = null;
    private CefKeyboardHandler keyboardHandler_ = null;
    private CefLifeSpanHandler lifeSpanHandler_ = null;
    private CefLoadHandler loadHandler_ = null;
    private CefRequestHandler requestHandler_ = null;

    CefClient() throws UnsatisfiedLinkError {
    }

    @Override
    public void dispose() {
        this.destroyAllBrowser();
        this.removeContextMenuHandler(this);
        this.removeDialogHandler(this);
        this.removeDisplayHandler(this);
        this.removeDownloadHandler(this);
        this.removeDragHandler(this);
        this.removeFocusHandler(this);
        this.removeGeolocationHandler(this);
        this.removeJSDialogHandler(this);
        this.removeKeyboardHandler(this);
        this.removeLifeSpanHandler(this);
        this.removeLoadHandler(this);
        this.removeRenderHandler(this);
        this.removeRequestHandler(this);
        super.dispose();
    }

    public CefBrowser createBrowser(String url, boolean isOffscreenRendered, boolean isTransparent) {
        return this.createBrowser(url, isOffscreenRendered, isTransparent, null);
    }

    public CefBrowser createBrowser(String url, boolean isOffscreenRendered, boolean isTransparent, CefRequestContext context) {
        return CefBrowserFactory.create(this, url, isOffscreenRendered, isTransparent, context);
    }

    public void destroyBrowser(CefBrowser browser) {
        Integer browserId = new Integer(browser.getIdentifier());
        if (this.browser_.remove(browserId) != null) {
            browser.close();
        }
    }

    public void destroyAllBrowser() {
        Collection<CefBrowser> browserList = this.browser_.values();
        for (CefBrowser browser : browserList) {
            browser.close();
        }
        this.browser_.clear();
    }

    @Override
    protected CefBrowser getBrowser(int identifier) {
        return this.browser_.get(new Integer(identifier));
    }

    @Override
    protected Object[] getAllBrowser() {
        return this.browser_.values().toArray();
    }

    @Override
    protected CefContextMenuHandler getContextMenuHandler() {
        return this;
    }

    @Override
    protected CefDialogHandler getDialogHandler() {
        return this;
    }

    @Override
    protected CefDisplayHandler getDisplayHandler() {
        return this;
    }

    @Override
    protected CefDownloadHandler getDownloadHandler() {
        return this;
    }

    @Override
    protected CefDragHandler getDragHandler() {
        return this;
    }

    @Override
    protected CefFocusHandler getFocusHandler() {
        return this;
    }

    @Override
    protected CefGeolocationHandler getGeolocationHandler() {
        return this;
    }

    @Override
    protected CefJSDialogHandler getJSDialogHandler() {
        return this;
    }

    @Override
    protected CefKeyboardHandler getKeyboardHandler() {
        return this;
    }

    @Override
    protected CefLifeSpanHandler getLifeSpanHandler() {
        return this;
    }

    @Override
    protected CefLoadHandler getLoadHandler() {
        return this;
    }

    @Override
    protected CefRenderHandler getRenderHandler() {
        return this;
    }

    @Override
    protected CefRequestHandler getRequestHandler() {
        return this;
    }

    public CefClient addContextMenuHandler(CefContextMenuHandler handler) {
        if (this.contextMenuHandler_ == null) {
            this.contextMenuHandler_ = handler;
        }
        return this;
    }

    public void removeContextMenuHandler() {
        this.contextMenuHandler_ = null;
    }

    @Override
    public void onBeforeContextMenu(CefBrowser browser, CefContextMenuParams params, CefMenuModel model) {
        if (this.contextMenuHandler_ != null && browser != null) {
            this.contextMenuHandler_.onBeforeContextMenu(browser, params, model);
        }
    }

    @Override
    public boolean onContextMenuCommand(CefBrowser browser, CefContextMenuParams params, int commandId, int eventFlags) {
        if (this.contextMenuHandler_ != null && browser != null) {
            return this.contextMenuHandler_.onContextMenuCommand(browser, params, commandId, eventFlags);
        }
        return false;
    }

    @Override
    public void onContextMenuDismissed(CefBrowser browser) {
        if (this.contextMenuHandler_ != null && browser != null) {
            this.contextMenuHandler_.onContextMenuDismissed(browser);
        }
    }

    public CefClient addDialogHandler(CefDialogHandler handler) {
        if (this.dialogHandler_ == null) {
            this.dialogHandler_ = handler;
        }
        return this;
    }

    public void removeDialogHandler() {
        this.dialogHandler_ = null;
    }

    @Override
    public boolean onFileDialog(CefBrowser browser, CefDialogHandler.FileDialogMode mode, String title, String defaultFileName, Vector<String> acceptTypes, CefFileDialogCallback callback) {
        if (this.dialogHandler_ != null && browser != null) {
            return this.dialogHandler_.onFileDialog(browser, mode, title, defaultFileName, acceptTypes, callback);
        }
        return false;
    }

    public CefClient addDisplayHandler(CefDisplayHandler handler) {
        if (this.displayHandler_ == null) {
            this.displayHandler_ = handler;
        }
        return this;
    }

    public void removeDisplayHandler() {
        this.displayHandler_ = null;
    }

    @Override
    public void onAddressChange(CefBrowser browser, String url) {
        if (this.displayHandler_ != null && browser != null) {
            this.displayHandler_.onAddressChange(browser, url);
        }
    }

    @Override
    public void onTitleChange(CefBrowser browser, String title) {
        if (this.displayHandler_ != null && browser != null) {
            this.displayHandler_.onTitleChange(browser, title);
        }
    }

    @Override
    public boolean onTooltip(CefBrowser browser, String text) {
        if (this.displayHandler_ != null && browser != null) {
            return this.displayHandler_.onTooltip(browser, text);
        }
        return false;
    }

    @Override
    public void onStatusMessage(CefBrowser browser, String value) {
        if (this.displayHandler_ != null && browser != null) {
            this.displayHandler_.onStatusMessage(browser, value);
        }
    }

    @Override
    public boolean onConsoleMessage(CefBrowser browser, String message, String source, int line) {
        if (this.displayHandler_ != null && browser != null) {
            return this.displayHandler_.onConsoleMessage(browser, message, source, line);
        }
        return false;
    }

    public CefClient addDownloadHandler(CefDownloadHandler handler) {
        if (this.downloadHandler_ == null) {
            this.downloadHandler_ = handler;
        }
        return this;
    }

    public void removeDownloadHandler() {
        this.downloadHandler_ = null;
    }

    @Override
    public void onBeforeDownload(CefBrowser browser, CefDownloadItem downloadItem, String suggestedName, CefBeforeDownloadCallback callback) {
        if (this.downloadHandler_ != null && browser != null) {
            this.downloadHandler_.onBeforeDownload(browser, downloadItem, suggestedName, callback);
        }
    }

    @Override
    public void onDownloadUpdated(CefBrowser browser, CefDownloadItem downloadItem, CefDownloadItemCallback callback) {
        if (this.downloadHandler_ != null && browser != null) {
            this.downloadHandler_.onDownloadUpdated(browser, downloadItem, callback);
        }
    }

    public CefClient addDragHandler(CefDragHandler handler) {
        if (this.dragHandler_ == null) {
            this.dragHandler_ = handler;
        }
        return this;
    }

    public void removeDragHandler() {
        this.dragHandler_ = null;
    }

    @Override
    public boolean onDragEnter(CefBrowser browser, CefDragData dragData, int mask) {
        if (this.dragHandler_ != null && browser != null) {
            return this.dragHandler_.onDragEnter(browser, dragData, mask);
        }
        return false;
    }

    public CefClient addFocusHandler(CefFocusHandler handler) {
        if (this.focusHandler_ == null) {
            this.focusHandler_ = handler;
        }
        return this;
    }

    public void removeFocusHandler() {
        this.focusHandler_ = null;
    }

    @Override
    public void onTakeFocus(CefBrowser browser, boolean next) {
        if (browser == null) {
            return;
        }
        browser.setFocus(false);
        Container parent = browser.getUIComponent().getParent();
        if (parent != null) {
            FocusTraversalPolicy policy = null;
            while (parent != null) {
                policy = parent.getFocusTraversalPolicy();
                if (policy != null) break;
                parent = parent.getParent();
            }
            if (policy != null) {
                Component nextComp;
                Component component = nextComp = next ? policy.getComponentAfter(parent, browser.getUIComponent()) : policy.getComponentBefore(parent, browser.getUIComponent());
                if (nextComp == null) {
                    policy.getDefaultComponent(parent).requestFocus();
                } else {
                    nextComp.requestFocus();
                }
            }
        }
        if (this.focusHandler_ != null) {
            this.focusHandler_.onTakeFocus(browser, next);
        }
    }

    @Override
    public boolean onSetFocus(CefBrowser browser, CefFocusHandler.FocusSource source) {
        if (browser == null) {
            return false;
        }
        boolean alreadyHandled = false;
        if (this.focusHandler_ != null) {
            alreadyHandled = this.focusHandler_.onSetFocus(browser, source);
        }
        if (!alreadyHandled) {
            browser.getUIComponent().requestFocus();
        }
        return alreadyHandled;
    }

    @Override
    public void onGotFocus(CefBrowser browser) {
        if (browser == null) {
            return;
        }
    }

    public CefClient addGeolocationHandler(CefGeolocationHandler handler) {
        if (this.geolocationHandler_ == null) {
            this.geolocationHandler_ = handler;
        }
        return this;
    }

    public void removeGeolocationHandler() {
        this.geolocationHandler_ = null;
    }

    @Override
    public void onRequestGeolocationPermission(CefBrowser browser, String requesting_url, int request_id, CefGeolocationCallback callback) {
        if (this.geolocationHandler_ != null && browser != null) {
            this.geolocationHandler_.onRequestGeolocationPermission(browser, requesting_url, request_id, callback);
        }
    }

    @Override
    public void onCancelGeolocationPermission(CefBrowser browser, String requesting_url, int request_id) {
        if (this.geolocationHandler_ != null && browser != null) {
            this.geolocationHandler_.onCancelGeolocationPermission(browser, requesting_url, request_id);
        }
    }

    public CefClient addJSDialogHandler(CefJSDialogHandler handler) {
        if (this.jsDialogHandler_ == null) {
            this.jsDialogHandler_ = handler;
        }
        return this;
    }

    public void removeJSDialogHandler() {
        this.jsDialogHandler_ = null;
    }

    @Override
    public boolean onJSDialog(CefBrowser browser, String origin_url, String accept_lang, CefJSDialogHandler.JSDialogType dialog_type, String message_text, String default_prompt_text, CefJSDialogCallback callback, BoolRef suppress_message) {
        if (this.jsDialogHandler_ != null && browser != null) {
            return this.jsDialogHandler_.onJSDialog(browser, origin_url, accept_lang, dialog_type, message_text, default_prompt_text, callback, suppress_message);
        }
        return false;
    }

    @Override
    public boolean onBeforeUnloadDialog(CefBrowser browser, String message_text, boolean is_reload, CefJSDialogCallback callback) {
        if (this.jsDialogHandler_ != null && browser != null) {
            return this.jsDialogHandler_.onBeforeUnloadDialog(browser, message_text, is_reload, callback);
        }
        return false;
    }

    @Override
    public void onResetDialogState(CefBrowser browser) {
        if (this.jsDialogHandler_ != null && browser != null) {
            this.jsDialogHandler_.onResetDialogState(browser);
        }
    }

    @Override
    public void onDialogClosed(CefBrowser browser) {
        if (this.jsDialogHandler_ != null && browser != null) {
            this.jsDialogHandler_.onDialogClosed(browser);
        }
    }

    public CefClient addKeyboardHandler(CefKeyboardHandler handler) {
        if (this.keyboardHandler_ == null) {
            this.keyboardHandler_ = handler;
        }
        return this;
    }

    public void removeKeyboardHandler() {
        this.keyboardHandler_ = null;
    }

    @Override
    public boolean onPreKeyEvent(CefBrowser browser, CefKeyboardHandler.CefKeyEvent event, BoolRef is_keyboard_shortcut) {
        if (this.keyboardHandler_ != null && browser != null) {
            return this.keyboardHandler_.onPreKeyEvent(browser, event, is_keyboard_shortcut);
        }
        return false;
    }

    @Override
    public boolean onKeyEvent(CefBrowser browser, CefKeyboardHandler.CefKeyEvent event) {
        if (this.keyboardHandler_ != null && browser != null) {
            return this.keyboardHandler_.onKeyEvent(browser, event);
        }
        return false;
    }

    public CefClient addLifeSpanHandler(CefLifeSpanHandler handler) {
        if (this.lifeSpanHandler_ == null) {
            this.lifeSpanHandler_ = handler;
        }
        return this;
    }

    public void removeLifeSpanHandler() {
        this.lifeSpanHandler_ = null;
    }

    @Override
    public boolean onBeforePopup(CefBrowser browser, String target_url, String target_frame_name) {
        if (this.lifeSpanHandler_ != null && browser != null) {
            return this.lifeSpanHandler_.onBeforePopup(browser, target_url, target_frame_name);
        }
        return false;
    }

    @Override
    public void onAfterCreated(CefBrowser browser) {
        if (browser == null) {
            return;
        }
        Integer identifier = browser.getIdentifier();
        this.browser_.put(identifier, browser);
        if (this.lifeSpanHandler_ != null) {
            this.lifeSpanHandler_.onAfterCreated(browser);
        }
    }

    @Override
    public boolean runModal(CefBrowser browser) {
        if (this.lifeSpanHandler_ != null && browser != null) {
            return this.lifeSpanHandler_.runModal(browser);
        }
        return false;
    }

    @Override
    public boolean doClose(CefBrowser browser) {
        if (this.lifeSpanHandler_ != null && browser != null) {
            return this.lifeSpanHandler_.doClose(browser);
        }
        return false;
    }

    @Override
    public void onBeforeClose(CefBrowser browser) {
        if (this.lifeSpanHandler_ != null && browser != null) {
            this.lifeSpanHandler_.onBeforeClose(browser);
        }
    }

    public CefClient addLoadHandler(CefLoadHandler handler) {
        if (this.loadHandler_ == null) {
            this.loadHandler_ = handler;
        }
        return this;
    }

    public void removeLoadHandler() {
        this.loadHandler_ = null;
    }

    @Override
    public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
        if (this.loadHandler_ != null && browser != null) {
            this.loadHandler_.onLoadingStateChange(browser, isLoading, canGoBack, canGoForward);
        }
    }

    @Override
    public void onLoadStart(CefBrowser browser, int frameIdentifer) {
        if (this.loadHandler_ != null && browser != null) {
            this.loadHandler_.onLoadStart(browser, frameIdentifer);
        }
    }

    @Override
    public void onLoadEnd(CefBrowser browser, int frameIdentifier, int httpStatusCode) {
        if (this.loadHandler_ != null && browser != null) {
            this.loadHandler_.onLoadEnd(browser, frameIdentifier, httpStatusCode);
        }
    }

    @Override
    public void onLoadError(CefBrowser browser, int frameIdentifer, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
        if (this.loadHandler_ != null && browser != null) {
            this.loadHandler_.onLoadError(browser, frameIdentifer, errorCode, errorText, failedUrl);
        }
    }

    @Override
    public synchronized void addMessageRouter(CefMessageRouter messageRouter) {
        super.addMessageRouter(messageRouter);
    }

    @Override
    public synchronized void removeMessageRouter(CefMessageRouter messageRouter) {
        super.removeMessageRouter(messageRouter);
    }

    @Override
    public Rectangle getViewRect(CefBrowser browser) {
        if (browser == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            return realHandler.getViewRect(browser);
        }
        Rectangle tmp = browser.getUIComponent().getBounds();
        if (OS.isMacintosh()) {
            Container parent = browser.getUIComponent().getParent();
            while (parent != null) {
                Container next = parent.getParent();
                if (next != null && next instanceof Window) break;
                Rectangle parentRect = parent.getBounds();
                tmp.x += parentRect.x;
                tmp.y += parentRect.y;
                parent = next;
            }
        }
        return tmp;
    }

    @Override
    public Point getScreenPoint(CefBrowser browser, Point viewPoint) {
        if (browser == null) {
            return new Point(0, 0);
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            return realHandler.getScreenPoint(browser, viewPoint);
        }
        Point screenPoint = browser.getUIComponent().getLocationOnScreen();
        screenPoint.translate(viewPoint.x, viewPoint.y);
        return screenPoint;
    }

    @Override
    public void onPopupShow(CefBrowser browser, boolean show) {
        if (browser == null) {
            return;
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            realHandler.onPopupShow(browser, show);
        }
    }

    @Override
    public void onPopupSize(CefBrowser browser, Rectangle size) {
        if (browser == null) {
            return;
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            realHandler.onPopupSize(browser, size);
        }
    }

    @Override
    public void onPaint(CefBrowser browser, boolean popup, Rectangle[] dirtyRects, ByteBuffer buffer, int width, int height) {
        if (browser == null) {
            return;
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            realHandler.onPaint(browser, popup, dirtyRects, buffer, width, height);
        }
    }

    @Override
    public void onCursorChange(CefBrowser browser, int cursorType) {
        if (browser == null) {
            return;
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            realHandler.onCursorChange(browser, cursorType);
        }
    }

    @Override
    public boolean startDragging(CefBrowser browser, CefDragData dragData, int mask, int x, int y) {
        if (browser == null) {
            return false;
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            return realHandler.startDragging(browser, dragData, mask, x, y);
        }
        return false;
    }

    @Override
    public void updateDragCursor(CefBrowser browser, int operation) {
        if (browser == null) {
            return;
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            realHandler.updateDragCursor(browser, operation);
        }
    }

    public CefClient addRequestHandler(CefRequestHandler handler) {
        if (this.requestHandler_ == null) {
            this.requestHandler_ = handler;
        }
        return this;
    }

    public void removeRequestHandler() {
        this.requestHandler_ = null;
    }

    @Override
    public boolean onBeforeBrowse(CefBrowser browser, CefRequest request, boolean is_redirect) {
        if (this.requestHandler_ != null && browser != null) {
            return this.requestHandler_.onBeforeBrowse(browser, request, is_redirect);
        }
        return false;
    }

    @Override
    public boolean onBeforeResourceLoad(CefBrowser browser, CefRequest request) {
        if (this.requestHandler_ != null && browser != null) {
            return this.requestHandler_.onBeforeResourceLoad(browser, request);
        }
        return false;
    }

    @Override
    public CefResourceHandler getResourceHandler(CefBrowser browser, CefRequest request) {
        if (this.requestHandler_ != null && browser != null) {
            return this.requestHandler_.getResourceHandler(browser, request);
        }
        return null;
    }

    @Override
    public void onResourceRedirect(CefBrowser browser, String old_url, StringRef new_url) {
        if (this.requestHandler_ != null && browser != null) {
            this.requestHandler_.onResourceRedirect(browser, old_url, new_url);
        }
    }

    @Override
    public boolean getAuthCredentials(CefBrowser browser, boolean isProxy, String host, int port, String realm, String scheme, CefAuthCallback callback) {
        if (this.requestHandler_ != null && browser != null) {
            return this.requestHandler_.getAuthCredentials(browser, isProxy, host, port, realm, scheme, callback);
        }
        return false;
    }

    @Override
    public boolean onQuotaRequest(CefBrowser browser, String origin_url, long new_size, CefQuotaCallback callback) {
        if (this.requestHandler_ != null && browser != null) {
            return this.requestHandler_.onQuotaRequest(browser, origin_url, new_size, callback);
        }
        return false;
    }

    @Override
    public void onProtocolExecution(CefBrowser browser, String url, BoolRef allow_os_execution) {
        if (this.requestHandler_ != null && browser != null) {
            this.requestHandler_.onProtocolExecution(browser, url, allow_os_execution);
        }
    }

    @Override
    public boolean onCertificateError(CefLoadHandler.ErrorCode cert_error, String request_url, CefAllowCertificateErrorCallback callback) {
        if (this.requestHandler_ != null) {
            return this.requestHandler_.onCertificateError(cert_error, request_url, callback);
        }
        return false;
    }

    @Override
    public boolean onBeforePluginLoad(CefBrowser browser, String url, String policyUrl, CefWebPluginInfo info) {
        if (this.requestHandler_ != null) {
            return this.requestHandler_.onBeforePluginLoad(browser, url, policyUrl, info);
        }
        return false;
    }

    @Override
    public void onPluginCrashed(CefBrowser browser, String pluginPath) {
        if (this.requestHandler_ != null) {
            this.requestHandler_.onPluginCrashed(browser, pluginPath);
        }
    }

    @Override
    public void onRenderProcessTerminated(CefBrowser browser, CefRequestHandler.TerminationStatus status) {
        if (this.requestHandler_ != null) {
            this.requestHandler_.onRenderProcessTerminated(browser, status);
        }
    }
}

