/*
 * Decompiled with CFR 0.152.
 */
package org.cef;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;
import org.cef.CefClient;
import org.cef.OS;
import org.cef.callback.CefSchemeHandlerFactory;
import org.cef.handler.CefAppHandler;
import org.cef.handler.CefAppHandlerAdapter;

public class CefApp
extends CefAppHandlerAdapter {
    private static CefApp self = null;
    private static CefAppHandler appHandler_ = null;
    private HashSet<CefClient> clients_ = new HashSet();
    private final Lock lock = new ReentrantLock();
    private final Condition cefInitialized = this.lock.newCondition();
    private final Condition cefShutdown = this.lock.newCondition();
    private final Condition cefShutdownFinished = this.lock.newCondition();
    private boolean isInitialized_ = false;
    private final boolean osrSupportEnabled_;
    private final Thread context = new Thread(){

        @Override
        public void start() {
            if (!this.isAlive() && super.getState() == Thread.State.NEW) {
                CefApp.this.lock.lock();
                try {
                    if (SwingUtilities.isEventDispatchThread()) {
                        CefApp.this.initialize();
                    }
                    super.start();
                    CefApp.this.cefInitialized.awaitUninterruptibly();
                }
                finally {
                    CefApp.this.lock.unlock();
                }
            }
        }

        @Override
        public void run() {
            CefApp.this.lock.lock();
            try {
                try {
                    if (!CefApp.this.isInitialized_) {
                        CefApp.this.initialize();
                    }
                    CefApp.this.cefInitialized.signal();
                    if (OS.isMacintosh()) {
                        CefApp.this.cefShutdown.awaitUninterruptibly();
                    } else {
                        boolean doLoop = true;
                        while (doLoop) {
                            CefApp.this.doMessageLoopWork();
                            try {
                                doLoop = !CefApp.this.cefShutdown.await(33L, TimeUnit.MILLISECONDS);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    for (CefClient c : CefApp.this.clients_) {
                        c.dispose();
                    }
                    CefApp.this.clients_.clear();
                    CefApp.this.doMessageLoopWork();
                    CefApp.this.shutdown();
                    CefApp.this.cefShutdownFinished.signal();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    CefApp.this.lock.unlock();
                }
            }
            finally {
                CefApp.this.lock.unlock();
            }
        }
    };

    private CefApp(String[] args, boolean enableOsr) throws UnsatisfiedLinkError {
        super(args);
        this.osrSupportEnabled_ = enableOsr;
        if (OS.isWindows()) {
            System.loadLibrary("libcef");
        } else if (OS.isLinux()) {
            System.loadLibrary("cef");
        }
        System.loadLibrary("jcef");
        if (appHandler_ == null) {
            appHandler_ = this;
        }
    }

    public static void addAppHandler(CefAppHandler appHandler) {
        appHandler_ = appHandler;
    }

    public static synchronized CefApp getInstance() throws UnsatisfiedLinkError {
        return CefApp.getInstance(null, false);
    }

    public static synchronized CefApp getInstance(String[] args) throws UnsatisfiedLinkError {
        return CefApp.getInstance(args, false);
    }

    public static synchronized CefApp getInstance(boolean enableOsr) throws UnsatisfiedLinkError {
        return CefApp.getInstance(null, enableOsr);
    }

    public static synchronized CefApp getInstance(String[] args, boolean enableOsr) throws UnsatisfiedLinkError {
        if (self == null) {
            self = new CefApp(args, enableOsr);
        }
        return self;
    }

    public final CefVersion getVersion() {
        try {
            return this.N_GetVersion();
        }
        catch (UnsatisfiedLinkError ule) {
            ule.printStackTrace();
            return null;
        }
    }

    public final synchronized void dispose() {
        Thread t = new Thread(){

            @Override
            public void run() {
                CefApp.this.lock.lock();
                try {
                    try {
                        CefApp.this.cefShutdown.signal();
                        CefApp.this.cefShutdownFinished.awaitUninterruptibly();
                    }
                    catch (Throwable err) {
                        err.printStackTrace();
                        System.out.println("shutdown complete");
                        self = null;
                        CefApp.this.lock.unlock();
                    }
                }
                finally {
                    System.out.println("shutdown complete");
                    self = null;
                    CefApp.this.lock.unlock();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            t.start();
        } else {
            t.run();
        }
    }

    public CefClient createClient() {
        if (!this.isInitialized_) {
            this.context.start();
        }
        CefClient client = new CefClient();
        this.clients_.add(client);
        return client;
    }

    public boolean registerSchemeHandlerFactory(String schemeName, String domainName, CefSchemeHandlerFactory factory) {
        try {
            return this.N_RegisterSchemeHandlerFactory(schemeName, domainName, factory);
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
    }

    public boolean clearSchemeHandlerFactories() {
        try {
            return this.N_ClearSchemeHandlerFactories();
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
    }

    private final void initialize() {
        try {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    String library_path = CefApp.this.getJcefLibPath();
                    System.out.println("initialize on " + Thread.currentThread() + " with library path " + library_path);
                    CefApp.this.isInitialized_ = CefApp.this.N_Initialize(library_path, appHandler_, CefApp.this.osrSupportEnabled_);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeAndWait(r);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void shutdown() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    System.out.println("  shutdown on " + Thread.currentThread());
                    CefApp.this.N_Shutdown();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void doMessageLoopWork() {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CefApp.this.N_DoMessageLoopWork();
                }
            });
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    private final String getJcefLibPath() {
        String[] paths;
        String library_path = System.getProperty("java.library.path");
        library_path = String.valueOf(System.getProperty("cef.path")) + System.getProperty("path.separator") + library_path;
        String[] stringArray = paths = library_path.split(System.getProperty("path.separator"));
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File dir = new File(path);
            String[] found = dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.equalsIgnoreCase("libjcef.dylib") || name.equalsIgnoreCase("libjcef.so") || name.equalsIgnoreCase("jcef.dll");
                }
            });
            if (found != null && found.length != 0) {
                return path;
            }
            ++n2;
        }
        return library_path;
    }

    private final native boolean N_Initialize(String var1, CefAppHandler var2, boolean var3);

    private final native void N_Shutdown();

    private final native void N_DoMessageLoopWork();

    private final native CefVersion N_GetVersion();

    private final native boolean N_RegisterSchemeHandlerFactory(String var1, String var2, CefSchemeHandlerFactory var3);

    private final native boolean N_ClearSchemeHandlerFactories();

    public final class CefVersion {
        public final int JCEF_REVISION;
        public final int CEF_VERSION_MAJOR;
        public final int CEF_REVISION;
        public final int CHROME_VERSION_MAJOR;
        public final int CHROME_VERSION_MINOR;
        public final int CHROME_VERSION_BUILD;
        public final int CHROME_VERSION_PATCH;

        private CefVersion(int jcefRev, int cefMajor, int cefRev, int chrMajor, int chrMin, int chrBuild, int chrPatch) {
            this.JCEF_REVISION = jcefRev;
            this.CEF_VERSION_MAJOR = cefMajor;
            this.CEF_REVISION = cefRev;
            this.CHROME_VERSION_MAJOR = chrMajor;
            this.CHROME_VERSION_MINOR = chrMin;
            this.CHROME_VERSION_BUILD = chrBuild;
            this.CHROME_VERSION_PATCH = chrPatch;
        }

        public String getJcefVersion() {
            return String.valueOf(this.CEF_VERSION_MAJOR) + "." + this.CHROME_VERSION_BUILD + "." + this.CEF_REVISION + "." + this.JCEF_REVISION;
        }

        public String getCefVersion() {
            return String.valueOf(this.CEF_VERSION_MAJOR) + "." + this.CHROME_VERSION_BUILD + "." + this.CEF_REVISION;
        }

        public String getChromeVersion() {
            return String.valueOf(this.CHROME_VERSION_MAJOR) + "." + this.CHROME_VERSION_MINOR + "." + this.CHROME_VERSION_BUILD + "." + this.CHROME_VERSION_PATCH;
        }

        public String toString() {
            return "JCEF Version = " + this.getJcefVersion() + "\n" + "CEF Version = " + this.getCefVersion() + "\n" + "Chromium Version = " + this.getChromeVersion();
        }
    }
}

