/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.cef3.inspect;

import com.pandora.browser.remote.debug.RemoteDebugActivator;
import com.pandora.browser.remote.debug.RemoteDebugClient;
import com.pandora.browser.remote.debug.listener.MessageListener;
import com.pandora.cef3.inspect.InspectNodeStructure;
import com.pandora.cef3.inspect.InspectNodeStructureListener;
import com.pandora.core.log.HBLog;
import com.pandora.core.utils.StringUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.runtime.Plugin;

public class InspectNodeStructureListenerManager {
    private static final String objectGroup = "dcloud.getInspectNodeStructure";
    private Set<InspectNodeStructureListener> inspectNodeStructureListeners = new LinkedHashSet<InspectNodeStructureListener>();
    private static InspectNodeStructureListenerManager inspectNodeStructureListenerManager = null;

    private InspectNodeStructureListenerManager() {
    }

    public static InspectNodeStructureListenerManager getInstence() {
        if (inspectNodeStructureListenerManager == null) {
            inspectNodeStructureListenerManager = new InspectNodeStructureListenerManager();
        }
        return inspectNodeStructureListenerManager;
    }

    public void addInspectNodeStructureListener(InspectNodeStructureListener inspectNodeStructureListener) {
        if (inspectNodeStructureListener != null) {
            this.inspectNodeStructureListeners.add(inspectNodeStructureListener);
        }
    }

    public void removeInspectNodeStructureListener(InspectNodeStructureListener inspectNodeStructureListener) {
        if (inspectNodeStructureListener != null) {
            this.inspectNodeStructureListeners.remove(inspectNodeStructureListener);
        }
    }

    public void notify(JSONObject response) {
        try {
            int nodeId = -1;
            if (response.has("params")) {
                nodeId = response.getJSONObject("params").getInt("nodeId");
            } else if (response.has("nodeId")) {
                nodeId = response.getInt("nodeId");
            }
            this.notify(nodeId);
        }
        catch (Throwable e) {
            HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
        }
    }

    public void notify(int nodeId) {
        try {
            if (nodeId < 0) {
                return;
            }
            RemoteDebugClient.getInstence().getDom().resolveNode(nodeId, objectGroup, new MessageListener(){

                public void receive(JSONObject response) {
                    if (response.has("object")) {
                        try {
                            JSONObject object = response.getJSONObject("object");
                            if (object.has("className") && object.getString("className").endsWith("Element")) {
                                String className = object.getString("className");
                                String objectId = object.getString("objectId");
                                InspectNodeStructureListenerManager.this.notify(objectId, className, InspectNodeStructureListenerManager.objectGroup);
                            }
                        }
                        catch (JSONException e) {
                            HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
                        }
                    }
                }
            });
        }
        catch (Throwable e) {
            HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
        }
    }

    public void notify(final String objectId, final String className, final String objectGroup) {
        RemoteDebugClient.getInstence().getRunTime().evaluate("Object.prototype.getHbuilderParentNodes=function(){if(this.parentNode&&this.nodeName&&this.nodeName!='#document'){var pn=this;var nodes=null;while(pn.nodeName&&pn.nodeName!='#document'){var name=pn.nodeName;var num=1;if(pn.parentNode){var childs=pn.parentNode.childNodes;if(childs&&childs.length>1){for(i=0;i<childs.length;i++){if(childs[i]===pn){break}if(childs[i].nodeName==pn.nodeName){num++}}}};name=(name+':'+(num-1));if(nodes){nodes=name+' '+nodes}else{nodes=name}pn=pn.parentNode}if(nodes){return nodes}}return null};", objectGroup, new MessageListener(){

            public void receive(JSONObject response) {
                RemoteDebugClient.getInstence().getRunTime().callFunctionOn(objectId, "getHbuilderParentNodes", new MessageListener(){

                    public void receive(JSONObject response) {
                        try {
                            try {
                                RemoteDebugClient.getInstence().getRunTime().evaluate("delete Object.prototype.getHbuilderParentNodes", objectGroup, null);
                                String value = response.getJSONObject("result").getString("value");
                                if (StringUtil.isNotBlank((String)value)) {
                                    String[] nodes;
                                    InspectNodeStructure nodeStructure = new InspectNodeStructure();
                                    String[] stringArray = nodes = value.split(" ");
                                    int n = nodes.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String node = stringArray[n2];
                                        if (node.contains(":")) {
                                            String[] nameAndNum = node.split(":");
                                            if (nameAndNum.length > 1) {
                                                nodeStructure.addNode(nameAndNum[0], Integer.parseInt(nameAndNum[1]));
                                            } else {
                                                nodeStructure.addNode(nameAndNum[0], 0);
                                            }
                                        } else {
                                            nodeStructure.addNode(node, 0);
                                        }
                                        ++n2;
                                    }
                                    if (nodeStructure.getSize() > 0) {
                                        if (className.equalsIgnoreCase("Element")) {
                                            nodeStructure.removeNode(nodeStructure.getSize() - 1);
                                        }
                                        for (InspectNodeStructureListener listener : InspectNodeStructureListenerManager.this.inspectNodeStructureListeners) {
                                            try {
                                                listener.notify(nodeStructure);
                                            }
                                            catch (Throwable e) {
                                                HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
                                            }
                                        }
                                    }
                                }
                            }
                            catch (JSONException e) {
                                HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
                                try {
                                    RemoteDebugClient.getInstence().getRunTime().releaseObjectGroup(objectGroup, null);
                                }
                                catch (Throwable e2) {
                                    HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e2);
                                }
                            }
                        }
                        finally {
                            try {
                                RemoteDebugClient.getInstence().getRunTime().releaseObjectGroup(objectGroup, null);
                            }
                            catch (Throwable e) {
                                HBLog.logError((Plugin)RemoteDebugActivator.getDefault(), (Throwable)e);
                            }
                        }
                    }
                });
            }
        });
    }
}

