/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.cef3;

import com.pandora.browser.remote.debug.RemoteDebugClient;
import com.pandora.browser.remote.debug.listener.MessageListener;
import com.pandora.cef3.CEF3Browser;
import com.pandora.cef3.inspect.InspectNodeStructureListenerManager;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import org.cef.browser.CefBrowser;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefMenuModel;
import org.cef.handler.CefContextMenuHandlerAdapter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;

final class MenuHandler
extends CefContextMenuHandlerAdapter {
    private static final String objectGroup = "dcloud.getAttribute";
    private final CEF3Browser browser;

    public MenuHandler(CEF3Browser browser) {
        this.browser = browser;
    }

    @Override
    public void onBeforeContextMenu(CefBrowser cefBrowser, CefContextMenuParams params, CefMenuModel model) {
        if (!this.browser.enableDefaultMenu()) {
            model.clear();
        } else {
            model.clear();
            model.addItem(100, "\u8fd4\u56de(&B)");
            model.addItem(101, "\u524d\u8fdb(&F)");
            model.addItem(102, "\u5237\u65b0(&R)");
            model.setEnabled(100, cefBrowser.canGoBack());
            model.setEnabled(101, cefBrowser.canGoForward());
            if (Platform.inDevelopmentMode() || this.browser.enableDevTools()) {
                model.addSeparator();
                model.addItem(26500, "\u67e5\u627e\u4ee3\u7801\u4e2d\u5bf9\u5e94dom\u8282\u70b9(&J)");
                model.setEnabled(26500, this.browser.devToolsDialog == null || this.browser.devToolsDialog.isDisposed());
                model.addItem(28500, "\u6253\u5f00Chrome\u63a7\u5236\u53f0(&N)");
            }
        }
        final Event event = new Event();
        final int x = params.getXCoord();
        final int y = params.getYCoord();
        event.x = x;
        event.y = y;
        this.browser.notifyEventListeners(35, event);
        if (event.doit && !this.browser.enableDefaultMenu() && !this.browser.isDisposed()) {
            this.browser.runInUI(new Runnable(){

                @Override
                public void run() {
                    Menu menu = MenuHandler.this.browser.getMenu();
                    if (menu != null && !menu.isDisposed()) {
                        if (x != event.x || y != event.y) {
                            menu.setLocation(event.x, event.y);
                        }
                        menu.setVisible(true);
                    }
                }
            });
        }
    }

    @Override
    public boolean onContextMenuCommand(CefBrowser cefBrowser, CefContextMenuParams params, int commandId, int eventFlags) {
        switch (commandId) {
            case 26500: {
                final int x = params.getXCoord();
                final int y = params.getYCoord();
                Job job = new Job("right mouse inspect Node job"){

                    protected IStatus run(IProgressMonitor monitor) {
                        if (!RemoteDebugClient.getInstence().isOpen()) {
                            int port = MenuHandler.this.browser.getRemoteDebuggingPort();
                            try {
                                if (port < 0 || !RemoteDebugClient.getInstence().connect(port)) {
                                    return Status.CANCEL_STATUS;
                                }
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                                return Status.CANCEL_STATUS;
                            }
                        }
                        RemoteDebugClient.getInstence().getRunTime().evaluate("document.elementFromPoint(" + x + ", " + y + ");", MenuHandler.objectGroup, new MessageListener(){

                            public void receive(JSONObject response) {
                                if (response.has("result")) {
                                    try {
                                        response = response.getJSONObject("result");
                                        if (!response.has("objectId") || !response.has("className")) {
                                            return;
                                        }
                                        final String objectId = response.getString("objectId");
                                        final String className = response.getString("className");
                                        RemoteDebugClient.getInstence().getDom().highlightFromObjectId(objectId, new MessageListener(){

                                            public void receive(JSONObject response) {
                                                InspectNodeStructureListenerManager.getInstence().notify(objectId, className, MenuHandler.objectGroup);
                                            }
                                        });
                                    }
                                    catch (JSONException e) {
                                        e.printStackTrace();
                                    }
                                }
                                System.out.println(response);
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
                return true;
            }
            case 28500: {
                this.browser.openDevTools();
                return true;
            }
        }
        return false;
    }
}

